/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.views.systems.nodes;

import com.ibm.etools.fm.core.model.cics.CicsResource;
import com.ibm.etools.fm.core.model.cics.CicsResourceQuery;
import com.ibm.etools.fm.core.model.cics.CicsTransientData;
import com.ibm.etools.fm.ui.memento.CicsResourceQuerySaver;
import com.ibm.etools.fm.ui.views.systems.FMTreeContentHolder;
import com.ibm.etools.fm.ui.views.systems.nodes.CicsResourceNode;
import com.ibm.etools.fm.ui.views.systems.nodes.CicsTDTypeNode;
import com.ibm.etools.fm.ui.views.systems.properties.CicsResourceQueryPropertySource;
import com.ibm.pdtools.common.component.jhost.core.model.IHostProvider;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.ui.views.systems.model.DelayedNodeHelper;
import com.ibm.pdtools.common.component.ui.views.systems.nodes.SystemsDataNode;
import com.ibm.pdtools.common.component.ui.views.systems.nodes.SystemsTreeNode;
import java.util.ArrayList;
import java.util.List;

public class CicsResourceQueryNode
extends SystemsDataNode<CicsResourceQuery<?>>
implements DelayedNodeHelper.ChildrenCreator<List<? extends CicsResource>> {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final DelayedNodeHelper<CicsResourceQuery<?>, List<? extends CicsResource>> helper = new DelayedNodeHelper(FMTreeContentHolder.getInstance().getCicsContent().getResourceQueryCache());

    protected CicsResourceQueryNode(CicsResourceQuery<? extends CicsResource> query, SystemsTreeNode parent) {
        super(query, parent);
    }

    public boolean hasChildren() {
        return helper.isYetToLoad((IHostProvider)((CicsResourceQuery)this.getDataObject())) || super.hasChildren();
    }

    public List<? extends SystemsTreeNode> getChildren() {
        helper.triggerLoad((IHostProvider)((CicsResourceQuery)this.getDataObject()));
        return super.getChildren();
    }

    public List<? extends SystemsTreeNode> getKnownChildren() {
        return helper.getKnownChildren((IHostProvider)((CicsResourceQuery)this.getDataObject()), (SystemsTreeNode)this, (DelayedNodeHelper.ChildrenCreator)this);
    }

    public List<? extends SystemsTreeNode> createChildrenFromContent(List<? extends CicsResource> content, SystemsTreeNode parent) {
        ArrayList<SystemsDataNode> nodes = new ArrayList<SystemsDataNode>();
        CicsTDTypeNode extQueue = null;
        CicsTDTypeNode intQueue = null;
        CicsTDTypeNode indQueue = null;
        CicsTDTypeNode remQueue = null;
        for (CicsResource cicsResource : content) {
            if (cicsResource instanceof CicsTransientData) {
                CicsTransientData td = (CicsTransientData)cicsResource;
                if (td.getTDType() == CicsTransientData.TD_TYPE.EXTRAPARTITION_TD && extQueue == null) {
                    extQueue = new CicsTDTypeNode(td.getTDType(), (CicsResourceQuery)this.getDataObject(), parent);
                    nodes.add(extQueue);
                    continue;
                }
                if (td.getTDType() == CicsTransientData.TD_TYPE.INTRAPARTITION_TD && intQueue == null) {
                    intQueue = new CicsTDTypeNode(td.getTDType(), (CicsResourceQuery)this.getDataObject(), parent);
                    nodes.add(intQueue);
                    continue;
                }
                if (td.getTDType() == CicsTransientData.TD_TYPE.INDIRECT_TD && indQueue == null) {
                    indQueue = new CicsTDTypeNode(td.getTDType(), (CicsResourceQuery)this.getDataObject(), parent);
                    nodes.add(indQueue);
                    continue;
                }
                if (td.getTDType() != CicsTransientData.TD_TYPE.REMOTE_TD || remQueue != null) continue;
                remQueue = new CicsTDTypeNode(td.getTDType(), (CicsResourceQuery)this.getDataObject(), parent);
                nodes.add(remQueue);
                continue;
            }
            nodes.add(new CicsResourceNode(cicsResource, parent));
        }
        return nodes;
    }

    public void refreshSelf() {
        helper.triggerUnload((IHostProvider)((CicsResourceQuery)this.getDataObject()));
    }

    public DelayedNodeHelper getHelper() {
        return helper;
    }

    public void removeNode() {
        CicsResourceQuery entity = (CicsResourceQuery)this.getDataObject();
        IPDHost pdHost = entity.getSystem();
        boolean removed = FMTreeContentHolder.getInstance().getCicsContent().getResourceQueryRegistry().remove((Object)entity, false);
        FMTreeContentHolder.getInstance().saveCicsQueries(pdHost);
        if (removed && pdHost.getDelegatingHost() == null) {
            FMTreeContentHolder.getInstance().getCicsContent().getResourceQueryRegistry().announceRemove((Object)entity);
        }
    }

    public boolean isRemoveable() {
        return true;
    }

    public void exportNode(IPDHost toHost) {
        CicsResourceQuerySaver cicsResourceQuerySaver = new CicsResourceQuerySaver(toHost);
        CicsResourceQuery query = (CicsResourceQuery)FMTreeContentHolder.getInstance().getCicsContent().getResourceQueryRegistry().find((Object)((CicsResourceQuery)this.getDataObject()));
        if (query != null) {
            cicsResourceQuerySaver.saveTo(query);
        }
    }

    public boolean isExportable() {
        return true;
    }

    public Object getPropertySource() {
        return new CicsResourceQueryPropertySource((CicsResourceQuery)this.getDataObject());
    }
}

