/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.views.systems.nodes;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.cics.CicsResource;
import com.ibm.etools.fm.ui.views.systems.properties.CicsResourcePropertySource;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.model.ILeaf;
import com.ibm.pdtools.common.component.core.util.PDUtils;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import com.ibm.pdtools.common.component.ui.views.systems.PDSystemsView;
import com.ibm.pdtools.common.component.ui.views.systems.nodes.SystemsDataNode;
import com.ibm.pdtools.common.component.ui.views.systems.nodes.SystemsTreeNode;
import java.text.MessageFormat;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Display;

public class CicsResourceNode
extends SystemsDataNode<CicsResource>
implements ILeaf {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";

    protected CicsResourceNode(CicsResource cicsResource, SystemsTreeNode parent) {
        super((Object)cicsResource, parent);
    }

    public void refreshSelf() {
        new Job(MessageFormat.format(Messages._REFRESHING_X, ((CicsResource)this.getDataObject()).getName())){

            protected IStatus run(IProgressMonitor monitor) {
                Result result;
                IHowIsGoing howIsGoing = PDUtils.convertIprogressToIHowIsGoing((IProgressMonitor)monitor);
                try {
                    result = ((CicsResource)CicsResourceNode.this.getDataObject()).refreshSelf(howIsGoing);
                }
                catch (InterruptedException e) {
                    PDLogger.get(((Object)((Object)this)).getClass()).trace((Object)"cancelled cics resource refresh self");
                    return new Status(8, "com.ibm.etools.fm.core", Messages._JOB_WAS_CANCELLED);
                }
                if (result.isSuccessfulWithoutWarnings()) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            PDSystemsView.refreshPropertyPage();
                        }
                    });
                    return Status.OK_STATUS;
                }
                return new Status(4, "com.ibm.etools.fm.ui", result.getMessagesCombined().toString());
            }
        }.schedule();
        super.refreshSelf();
    }

    public Object getPropertySource() {
        return new CicsResourcePropertySource((CicsResource)this.getDataObject());
    }
}

