/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.views.systems.nodes;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.cics.CicsAppl;
import com.ibm.etools.fm.jhost.core.version.FMFeature;
import com.ibm.etools.fm.ui.views.systems.FMTreeContentHolder;
import com.ibm.etools.fm.ui.views.systems.nodes.CicsApplBrowseNode;
import com.ibm.etools.fm.ui.views.systems.nodes.CicsApplFolderNode;
import com.ibm.pdtools.common.component.jhost.comms.HostType;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.IPDPlatformObject;
import com.ibm.pdtools.common.component.jhost.version.PDFeature;
import com.ibm.pdtools.common.component.ui.views.systems.nodes.SystemsDataNode;
import com.ibm.pdtools.common.component.ui.views.systems.nodes.SystemsHostUniqueNode;
import com.ibm.pdtools.common.component.ui.views.systems.nodes.SystemsTreeNode;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.preference.BooleanFieldEditor;

public class CicsObjectRootNode
extends SystemsHostUniqueNode
implements IPDPlatformObject {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    public static final String PREFERENCE_ID = "ipv.Cics";
    private static BooleanFieldEditor featurePreference = null;

    public CicsObjectRootNode() {
        super((PDFeature)FMFeature.CICS);
    }

    public CicsObjectRootNode(IPDHost host, SystemsTreeNode parent) {
        super(host, parent);
    }

    public boolean hasChildren() {
        return true;
    }

    public List<? extends SystemsTreeNode> getKnownChildren() {
        ArrayList<SystemsDataNode> nodes = new ArrayList<SystemsDataNode>();
        nodes.add(new CicsApplBrowseNode(this.getSystem(), (SystemsTreeNode)this));
        if (!this.queriesLoaded) {
            FMTreeContentHolder.getInstance().loadCicsQFromDialogSetting(this.getSystem());
            this.queriesLoaded = true;
        }
        for (CicsAppl appl : FMTreeContentHolder.getInstance().getCicsContent().getApplicationsWithQueries(this.getSystem())) {
            CicsAppl cicsAppl = CicsAppl.create((IPDHost)this.getSystem(), (String)appl.getName());
            nodes.add(new CicsApplFolderNode(cicsAppl, (SystemsTreeNode)this));
        }
        return nodes;
    }

    public String getPDLabel() {
        if (this.getSystem().getHostType() == HostType.ZOS) {
            return Messages.CICS_ROOT_NODE_NAME_ZOS;
        }
        return Messages.CICS_ROOT_NODE_NAME_DISTRIBUTED;
    }

    public String getSubsysName() {
        return Messages.CICS_ROOT_NODE_NAME_ZOS;
    }

    public String getPDImageName() {
        return "cics";
    }

    public String getPDPluginId() {
        return "com.ibm.etools.fm.ui";
    }

    public String getPreferenceId() {
        return PREFERENCE_ID;
    }

    public void setFeaturePreference(BooleanFieldEditor status) {
        featurePreference = status;
    }

    public BooleanFieldEditor getFeaturePreference() {
        return featurePreference;
    }
}

