/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.views.systems.nodes;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.cics.CicsAppl;
import com.ibm.etools.fm.core.model.cics.CicsFileQuery;
import com.ibm.etools.fm.core.model.cics.CicsResourceQuery;
import com.ibm.etools.fm.core.model.cics.CicsTemporaryStorageQuery;
import com.ibm.etools.fm.core.model.cics.CicsTransientDataQuery;
import com.ibm.etools.fm.ui.views.systems.nodes.CicsResourceBrowseNode;
import com.ibm.etools.fm.ui.views.systems.properties.CicsApplPropertySource;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.model.ISystemsErrorFinder;
import com.ibm.pdtools.common.component.core.util.PDUtils;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.util.ArrayUtils;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import com.ibm.pdtools.common.component.ui.views.systems.PDSystemsView;
import com.ibm.pdtools.common.component.ui.views.systems.nodes.SystemsDataNode;
import com.ibm.pdtools.common.component.ui.views.systems.nodes.SystemsTreeNode;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Display;

public class CicsApplNode
extends SystemsDataNode<CicsAppl>
implements ISystemsErrorFinder {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";

    protected CicsApplNode(CicsAppl cicsAppl, SystemsTreeNode parent) {
        super((Object)cicsAppl, parent);
    }

    public void refreshSelf() {
        new Job(MessageFormat.format(Messages._REFRESHING_X, ((CicsAppl)this.getDataObject()).getName())){

            protected IStatus run(IProgressMonitor monitor) {
                Result result = null;
                IHowIsGoing howIsGoing = PDUtils.convertIprogressToIHowIsGoing((IProgressMonitor)monitor);
                try {
                    result = ((CicsAppl)CicsApplNode.this.getDataObject()).refreshSelf(howIsGoing);
                }
                catch (InterruptedException e) {
                    PDLogger.get(((Object)((Object)this)).getClass()).trace((Object)"Cancelled cics appl refresh self");
                    return new Status(8, "com.ibm.etools.fm.core", Messages._JOB_WAS_CANCELLED);
                }
                if (result.isSuccessfulWithoutWarnings()) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            PDSystemsView.refreshPropertyPage();
                        }
                    });
                    return Status.OK_STATUS;
                }
                return new Status(4, "com.ibm.etools.fm.ui", result.getMessagesCombined().toString());
            }
        }.schedule();
        super.refreshSelf();
    }

    public boolean hasChildren() {
        return ((CicsAppl)this.getDataObject()).canConnect() && super.hasChildren();
    }

    public List<? extends SystemsTreeNode> getKnownChildren() {
        ArrayList<CicsResourceBrowseNode> nodes = new ArrayList<CicsResourceBrowseNode>();
        nodes.add(new CicsResourceBrowseNode(this, (CicsResourceQuery<?>)CicsFileQuery.createForApplication((CicsAppl)((CicsAppl)this.getDataObject())), Messages.CICS_BROWSE_FILES_NAME));
        nodes.add(new CicsResourceBrowseNode(this, (CicsResourceQuery<?>)CicsTransientDataQuery.createForApplication((CicsAppl)((CicsAppl)this.getDataObject())), Messages.CICS_BROWSE_TD_NAME));
        nodes.add(new CicsResourceBrowseNode(this, (CicsResourceQuery<?>)CicsTemporaryStorageQuery.createForApplication((CicsAppl)((CicsAppl)this.getDataObject())), Messages.CICS_BROWSE_TS_NAME));
        return nodes;
    }

    public String getErrorText() {
        ArrayList messages = ((CicsAppl)this.getDataObject()).getMessages();
        if (messages != null && !messages.isEmpty()) {
            return ArrayUtils.join((Object[])messages.toArray(), (String)"\n").toString();
        }
        return null;
    }

    public Object getPropertySource() {
        return new CicsApplPropertySource((CicsAppl)this.getDataObject());
    }
}

