/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.views.systems.nodes;

import com.ibm.etools.fm.core.model.cics.CicsAppl;
import com.ibm.etools.fm.core.model.cics.CicsFileQuery;
import com.ibm.etools.fm.core.model.cics.CicsResource;
import com.ibm.etools.fm.core.model.cics.CicsResourceQuery;
import com.ibm.etools.fm.core.model.cics.CicsTemporaryStorageQuery;
import com.ibm.etools.fm.core.model.cics.CicsTransientDataQuery;
import com.ibm.etools.fm.ui.memento.CicsResourceQuerySaver;
import com.ibm.etools.fm.ui.views.systems.FMTreeContentHolder;
import com.ibm.etools.fm.ui.views.systems.model.CicsTreeContent;
import com.ibm.etools.fm.ui.views.systems.nodes.CicsResourceQueryNode;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.ui.views.systems.nodes.SystemsDataNode;
import com.ibm.pdtools.common.component.ui.views.systems.nodes.SystemsTreeNode;
import java.util.ArrayList;
import java.util.List;

public class CicsApplFolderNode
extends SystemsDataNode<CicsAppl> {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";

    public CicsApplFolderNode(CicsAppl applId, SystemsTreeNode parent) {
        super((Object)applId, parent);
    }

    public List<? extends SystemsTreeNode> getKnownChildren() {
        ArrayList<CicsResourceQueryNode> nodes = new ArrayList<CicsResourceQueryNode>();
        for (CicsResourceQuery<?> query : FMTreeContentHolder.getInstance().getCicsContent().getQueriesForApplication((CicsAppl)this.getDataObject())) {
            if (this.isInRS()) {
                CicsFileQuery aQuery = null;
                if (query instanceof CicsFileQuery) {
                    aQuery = CicsFileQuery.create((CicsAppl)((CicsAppl)this.getDataObject()), (String)query.getQuery());
                } else if (query instanceof CicsTemporaryStorageQuery) {
                    aQuery = CicsTemporaryStorageQuery.create((CicsAppl)((CicsAppl)this.getDataObject()), (String)query.getQuery());
                } else if (query instanceof CicsTransientDataQuery) {
                    aQuery = CicsTransientDataQuery.create((CicsAppl)((CicsAppl)this.getDataObject()), (String)query.getQuery());
                }
                if (aQuery == null) continue;
                aQuery.setSystem(((CicsAppl)this.getDataObject()).getSystem());
                nodes.add(new CicsResourceQueryNode((CicsResourceQuery<? extends CicsResource>)aQuery, (SystemsTreeNode)this));
                continue;
            }
            nodes.add(new CicsResourceQueryNode(query, (SystemsTreeNode)this));
        }
        return nodes;
    }

    public void removeNode() {
        CicsAppl entity = (CicsAppl)this.getDataObject();
        IPDHost pdHost = entity.getSystem();
        CicsTreeContent cicsContent = FMTreeContentHolder.getInstance().getCicsContent();
        List<CicsResourceQuery<?>> queries = cicsContent.getQueriesForApplication(entity);
        for (CicsResourceQuery<?> query : queries) {
            cicsContent.getResourceQueryRegistry().remove(query, false);
        }
        FMTreeContentHolder.getInstance().saveCicsQueries(pdHost);
        if (pdHost.getDelegatingHost() == null) {
            for (CicsResourceQuery<?> query : queries) {
                cicsContent.getResourceQueryRegistry().announceRemove(query);
            }
        }
    }

    public boolean isRemoveable() {
        return true;
    }

    public void exportNode(IPDHost toHost) {
        CicsTreeContent cicsContent = FMTreeContentHolder.getInstance().getCicsContent();
        List<CicsResourceQuery<?>> queries = cicsContent.getQueriesForApplication((CicsAppl)this.getDataObject());
        CicsResourceQuerySaver cicsResourceQuerySaver = new CicsResourceQuerySaver(toHost);
        for (CicsResourceQuery<?> query : queries) {
            cicsResourceQuerySaver.saveTo(query);
        }
    }

    public boolean isExportable() {
        return true;
    }
}

