/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.views.systems.nodes;

import com.ibm.etools.fm.ui.history.ActionType;
import com.ibm.etools.fm.ui.history.IActionItem;
import com.ibm.etools.fm.ui.views.systems.FMTreeContentHolder;
import com.ibm.etools.fm.ui.views.systems.model.ActionHistoryContent;
import com.ibm.etools.fm.ui.views.systems.nodes.ActionItemFavoriteNode;
import com.ibm.etools.fm.ui.views.systems.nodes.ActionItemNode;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.ui.views.systems.IHasLabelAndImage;
import com.ibm.pdtools.common.component.ui.views.systems.nodes.SystemsDataNode;
import com.ibm.pdtools.common.component.ui.views.systems.nodes.SystemsTreeNode;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ActionTypeNode
extends SystemsDataNode<ActionType>
implements IHasLabelAndImage {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private final boolean showFavoritesOnly;
    private final IPDHost host;

    protected ActionTypeNode(IPDHost host, ActionType type, boolean showFavoritesOnly, SystemsTreeNode parent) {
        super((Object)type, parent);
        this.host = host;
        this.showFavoritesOnly = showFavoritesOnly;
    }

    public IPDHost getHost() {
        return this.host;
    }

    public List<? extends SystemsTreeNode> getKnownChildren() {
        List<IActionItem> actions = FMTreeContentHolder.getInstance().getActionHistoryContent().getActionsForType(this.host, (ActionType)((Object)this.getDataObject()));
        if (this.showFavoritesOnly) {
            ActionHistoryContent.removeNonFavorites(actions);
        } else {
            Collections.sort(actions, ActionHistoryContent.EXECUTION_ORDER_COMPARATOR);
            while (actions.size() > 25) {
                actions.remove(actions.size() - 1);
            }
        }
        ArrayList<ActionItemNode> nodes = new ArrayList<ActionItemNode>();
        for (IActionItem action : actions) {
            if (this.showFavoritesOnly) {
                nodes.add(new ActionItemFavoriteNode(action, (SystemsTreeNode)this));
                continue;
            }
            nodes.add(new ActionItemNode(action, (SystemsTreeNode)this));
        }
        return nodes;
    }

    public String getPDLabel() {
        return ((ActionType)((Object)this.getDataObject())).getLabel();
    }

    public String getPDImageName() {
        return "action_history" + File.separator + ((ActionType)((Object)this.getDataObject())).getImageName() + "_folder";
    }

    public String getPDPluginId() {
        return "com.ibm.etools.fm.ui";
    }

    public void removeNode() {
        ActionHistoryContent ahContent = FMTreeContentHolder.getInstance().getActionHistoryContent();
        List<IActionItem> actions = ahContent.getActionsForType(this.getHost(), (ActionType)((Object)this.getDataObject()));
        for (IActionItem action : actions) {
            ahContent.getRegistry().remove((Object)action);
        }
    }
}

