/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.views.systems.model;

import com.ibm.etools.fm.core.model.UssFile;
import com.ibm.etools.fm.core.model.UssFileQuery;
import com.ibm.pdtools.common.component.core.Messages;
import com.ibm.pdtools.common.component.jhost.comms.CommunicationException;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.registery.EListener;
import com.ibm.pdtools.common.component.jhost.registery.EntityEvent;
import com.ibm.pdtools.common.component.jhost.registery.EntityEventType;
import com.ibm.pdtools.common.component.jhost.registery.EntityRegistry;
import com.ibm.pdtools.common.component.jhost.registery.HostRegistry;
import com.ibm.pdtools.common.component.jhost.registery.IContentLoadStatus;
import com.ibm.pdtools.common.component.jhost.registery.RegistryLocator;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import com.ibm.pdtools.common.component.ui.views.systems.model.ContentCache;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;

public class UssTreeContent {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private final ContentCache<UssFile, List<UssFile>> fileContentCache = new ContentCache((ContentCache.IEntityContentLoader)new ContentCache.IEntityContentLoader<UssFile, List<UssFile>>(){

        public List<UssFile> loadEntityContent(UssFile file, IHowIsGoing monitor) throws CommunicationException, InterruptedException {
            Result result = file.loadFiles(monitor, true);
            if (!result.isSuccessfulWithoutWarnings()) {
                String message = result.getMessagesCombined().toString();
                throw new CommunicationException(MessageFormat.format(Messages.__LOAD_FAILED_DUE_TO_X, message));
            }
            return (List)result.getOutput();
        }

        public String getJobName(UssFile entity) {
            return MessageFormat.format(Messages._LOADING_X, entity.getName());
        }
    });
    private final EntityRegistry<UssFileQuery> queryRegistry;
    private final ContentCache<UssFileQuery, List<UssFile>> queryContentCache;

    public UssTreeContent() {
        this.fileContentCache.addContentLoadedListener((ContentCache.EntityContentListener)new ContentCache.EntityContentListener<UssFile, List<UssFile>>(){

            public void postEntityContentLoad(UssFile entity, IContentLoadStatus<List<UssFile>> status) {
                if (status.getError() == null && status.getContentOnly() != null) {
                    for (UssFile ussFile : (List)status.getContentOnly()) {
                        UssTreeContent.this.fileContentCache.acquireContentLock((Object)ussFile);
                    }
                }
            }

            public void preEntityContentUnload(UssFile entity, IContentLoadStatus<List<UssFile>> status) {
                if (status.getError() == null && status.getContentOnly() != null) {
                    for (UssFile ussFile : (List)status.getContentOnly()) {
                        UssTreeContent.this.fileContentCache.releaseContentLock((Object)ussFile);
                    }
                }
            }
        });
        this.queryRegistry = new EntityRegistry();
        this.queryContentCache = new ContentCache((ContentCache.IEntityContentLoader)new ContentCache.IEntityContentLoader<UssFileQuery, List<UssFile>>(){

            public List<UssFile> loadEntityContent(UssFileQuery query, IHowIsGoing monitor) throws CommunicationException, InterruptedException {
                Result result = query.loadFiles(monitor);
                if (!result.isSuccessfulWithoutWarnings()) {
                    String message = result.getMessagesCombined().toString();
                    throw new CommunicationException(MessageFormat.format(Messages.__LOAD_FAILED_DUE_TO_X, message));
                }
                return (List)result.getOutput();
            }

            public String getJobName(UssFileQuery entity) {
                return MessageFormat.format(Messages._LOADING_X, entity.getQuery());
            }
        });
        this.queryContentCache.addContentLoadedListener((ContentCache.EntityContentListener)new ContentCache.EntityContentListener<UssFileQuery, List<UssFile>>(){

            public void postEntityContentLoad(UssFileQuery entity, IContentLoadStatus<List<UssFile>> status) {
                if (status.getError() == null && status.getContentOnly() != null) {
                    for (UssFile ussFile : (List)status.getContentOnly()) {
                        UssTreeContent.this.fileContentCache.acquireContentLock((Object)ussFile);
                    }
                }
            }

            public void preEntityContentUnload(UssFileQuery entity, IContentLoadStatus<List<UssFile>> status) {
                if (status.getError() == null && status.getContentOnly() != null) {
                    for (UssFile ussFile : (List)status.getContentOnly()) {
                        UssTreeContent.this.fileContentCache.releaseContentLock((Object)ussFile);
                    }
                }
            }
        });
        this.queryRegistry.addListener((EListener)new EListener<EntityEvent<UssFileQuery>>(){

            public void onEvent(EntityEvent<UssFileQuery> event) {
                if (event.getType() == EntityEventType.ADDED) {
                    UssTreeContent.this.queryContentCache.acquireContentLock((Object)((UssFileQuery)event.getEntity()));
                } else if (event.getType() == EntityEventType.REMOVED) {
                    UssTreeContent.this.queryContentCache.releaseContentLock((Object)((UssFileQuery)event.getEntity()));
                }
            }
        });
        HostRegistry hostRegistry = RegistryLocator.instance().getHostRegistry();
        hostRegistry.addListener((EListener)new EListener<EntityEvent<IPDHost>>(){

            public void onEvent(EntityEvent<IPDHost> event) {
                IPDHost host = (IPDHost)event.getEntity();
                if (event.getType() == EntityEventType.ADDED) {
                    UssTreeContent.this.queryContentCache.acquireContentLock((Object)UssFileQuery.createForHost((IPDHost)host));
                } else if (event.getType() == EntityEventType.REMOVED) {
                    List<UssFileQuery> queriesToRemove = UssTreeContent.this.getQueriesForHost(host);
                    for (UssFileQuery ussFileQuery : queriesToRemove) {
                        UssTreeContent.this.queryRegistry.remove((Object)ussFileQuery);
                    }
                    UssTreeContent.this.queryContentCache.releaseContentLock((Object)UssFileQuery.createForHost((IPDHost)host));
                }
            }
        });
        for (IPDHost host : hostRegistry.all()) {
            this.queryContentCache.acquireContentLock((Object)UssFileQuery.createForHost((IPDHost)host));
        }
    }

    public List<UssFileQuery> getQueriesForHost(IPDHost host) {
        List queries = this.queryRegistry.all();
        Iterator iterator = queries.iterator();
        while (iterator.hasNext()) {
            UssFileQuery query = (UssFileQuery)iterator.next();
            if (host.equals(query.getSystem())) continue;
            iterator.remove();
        }
        return queries;
    }

    public EntityRegistry<UssFileQuery> getQueryRegistry() {
        return this.queryRegistry;
    }

    public ContentCache<UssFile, List<UssFile>> getFileContentCache() {
        return this.fileContentCache;
    }

    public ContentCache<UssFileQuery, List<UssFile>> getQueryContentCache() {
        return this.queryContentCache;
    }
}

