/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.views.systems.model;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.MessageQueue;
import com.ibm.etools.fm.core.model.MessageQueueManager;
import com.ibm.etools.fm.core.model.MessageQueueManagerQuery;
import com.ibm.etools.fm.core.model.MessageQueueQuery;
import com.ibm.etools.fm.ui.views.systems.model.FMTreeContent;
import com.ibm.pdtools.common.component.jhost.comms.CommunicationException;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.PDHostJhost;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.registery.EListener;
import com.ibm.pdtools.common.component.jhost.registery.EntityEvent;
import com.ibm.pdtools.common.component.jhost.registery.EntityEventType;
import com.ibm.pdtools.common.component.jhost.registery.EntityRegistry;
import com.ibm.pdtools.common.component.jhost.registery.HostRegistry;
import com.ibm.pdtools.common.component.jhost.registery.IContentLoadStatus;
import com.ibm.pdtools.common.component.jhost.registery.RegistryLocator;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import com.ibm.pdtools.common.component.ui.views.systems.model.ContentCache;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class MqTreeContent
extends FMTreeContent {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2020. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private final EntityRegistry<MessageQueueQuery> mqQueryRegistry;
    private final ContentCache<MessageQueueManagerQuery, List<MessageQueueManager>> mqmContentCache;
    private final ContentCache<MessageQueueQuery, List<MessageQueue>> mqQueryContentCache = new ContentCache((ContentCache.IEntityContentLoader)new ContentCache.IEntityContentLoader<MessageQueueQuery, List<MessageQueue>>(){

        public List<MessageQueue> loadEntityContent(MessageQueueQuery query, IHowIsGoing monitor) throws InterruptedException, CommunicationException {
            Result result = query.loadMessageQueues(monitor, true);
            if (!result.isSuccessfulWithoutWarnings()) {
                throw new CommunicationException(MessageFormat.format(com.ibm.pdtools.common.component.core.Messages.__LOAD_FAILED_DUE_TO_X, result.getMessagesCombined()));
            }
            return query.getMessageQueues();
        }

        public String getJobName(MessageQueueQuery entity) {
            return MessageFormat.format(com.ibm.pdtools.common.component.core.Messages._LOADING_X, entity.getLabel());
        }
    });

    public MqTreeContent() {
        this.mqmContentCache = new ContentCache((ContentCache.IEntityContentLoader)new ContentCache.IEntityContentLoader<MessageQueueManagerQuery, List<MessageQueueManager>>(){

            public List<MessageQueueManager> loadEntityContent(MessageQueueManagerQuery entity, IHowIsGoing monitor) throws InterruptedException, CommunicationException {
                Result result = entity.loadMessageQueueManagers(monitor, true);
                return (List)result.getOutput();
            }

            public String getJobName(MessageQueueManagerQuery entity) {
                return MessageFormat.format(com.ibm.pdtools.common.component.core.Messages._LOADING_X, Messages.MqTreeContent_MQ_MANAGERS);
            }
        });
        this.mqmContentCache.addContentLoadedListener((ContentCache.EntityContentListener)new ContentCache.EntityContentListener<MessageQueueManagerQuery, List<MessageQueueManager>>(){

            public void postEntityContentLoad(MessageQueueManagerQuery entity, IContentLoadStatus<List<MessageQueueManager>> status) {
                if (status.getError() == null && status.getContentOnly() != null) {
                    for (MessageQueueManager mqm : (List)status.getContentOnly()) {
                        MqTreeContent.this.mqQueryContentCache.acquireContentLock((Object)MessageQueueQuery.createForManager((MessageQueueManager)mqm));
                    }
                }
            }

            public void preEntityContentUnload(MessageQueueManagerQuery entity, IContentLoadStatus<List<MessageQueueManager>> status) {
                if (status.getError() == null && status.getContentOnly() != null) {
                    for (MessageQueueManager mqm : (List)status.getContentOnly()) {
                        MqTreeContent.this.mqQueryContentCache.releaseContentLock((Object)MessageQueueQuery.createForManager((MessageQueueManager)mqm));
                    }
                }
            }
        });
        this.mqQueryRegistry = new EntityRegistry();
        this.mqQueryRegistry.addListener((EListener)new EListener<EntityEvent<MessageQueueQuery>>(){

            public void onEvent(EntityEvent<MessageQueueQuery> event) {
                if (event.getType() == EntityEventType.ADDED) {
                    MqTreeContent.this.mqQueryContentCache.acquireContentLock((Object)((MessageQueueQuery)event.getEntity()));
                } else if (event.getType() == EntityEventType.REMOVED) {
                    MqTreeContent.this.mqQueryContentCache.releaseContentLock((Object)((MessageQueueQuery)event.getEntity()));
                }
            }
        });
        HostRegistry hostRegistry = RegistryLocator.instance().getHostRegistry();
        hostRegistry.addListener((EListener)new EListener<EntityEvent<IPDHost>>(){

            public void onEvent(EntityEvent<IPDHost> event) {
                IPDHost host = (IPDHost)event.getEntity();
                if (event.getType() == EntityEventType.ADDED) {
                    MqTreeContent.this.mqmContentCache.acquireContentLock((Object)new MessageQueueManagerQuery(host));
                } else if (event.getType() == EntityEventType.REMOVED) {
                    List<MessageQueueQuery> queriesToRemove = MqTreeContent.this.getQueriesForHost(host);
                    for (MessageQueueQuery query : queriesToRemove) {
                        MqTreeContent.this.mqQueryRegistry.remove((Object)query);
                    }
                    MqTreeContent.this.mqmContentCache.releaseContentLock((Object)new MessageQueueManagerQuery(host));
                }
            }
        });
        for (IPDHost host : hostRegistry.all()) {
            this.mqmContentCache.acquireContentLock((Object)new MessageQueueManagerQuery(host));
        }
    }

    public List<MessageQueueQuery> getQueriesForHost(IPDHost host) {
        List queries = this.mqQueryRegistry.all();
        Iterator iterator = queries.iterator();
        while (iterator.hasNext()) {
            MessageQueueQuery query = (MessageQueueQuery)iterator.next();
            if (host.equals(query.getSystem()) && PDHostJhost.xnorDeligated((IPDHost)host, (IPDHost)query.getSystem())) continue;
            iterator.remove();
        }
        return queries;
    }

    public List<MessageQueueQuery> getQueriesForManager(MessageQueueManager manager) {
        List queries = this.mqQueryRegistry.all();
        Iterator iterator = queries.iterator();
        while (iterator.hasNext()) {
            MessageQueueQuery query = (MessageQueueQuery)iterator.next();
            if (manager.equals((Object)query.getMQManager()) && PDHostJhost.xnorDeligated((IPDHost)manager.getSystem(), (IPDHost)query.getSystem())) continue;
            iterator.remove();
        }
        return queries;
    }

    public List<MessageQueueManager> getManagersWithQueries(IPDHost host) {
        HashSet<MessageQueueManager> managers = new HashSet<MessageQueueManager>();
        List<MessageQueueQuery> queries = this.getQueriesForHost(host);
        for (MessageQueueQuery mqQuery : queries) {
            managers.add(mqQuery.getMQManager());
        }
        return new ArrayList<MessageQueueManager>(managers);
    }

    public EntityRegistry<MessageQueueQuery> getQueryRegistry() {
        return this.mqQueryRegistry;
    }

    public ContentCache<MessageQueueManagerQuery, List<MessageQueueManager>> getHostContentCache() {
        return this.mqmContentCache;
    }

    public ContentCache<MessageQueueQuery, List<MessageQueue>> getMqQueryContentCache() {
        return this.mqQueryContentCache;
    }
}

