/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.views.systems.model;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.DataSet;
import com.ibm.etools.fm.core.model.FMHost;
import com.ibm.etools.fm.core.model.Member;
import com.ibm.etools.fm.core.model.ims.ImsAccessMode;
import com.ibm.etools.fm.core.model.ims.ImsDatabase;
import com.ibm.etools.fm.core.model.ims.ImsDatabaseQuery;
import com.ibm.etools.fm.core.model.ims.ImsPcb;
import com.ibm.etools.fm.core.model.ims.ImsPsb;
import com.ibm.etools.fm.core.model.ims.ImsPsbQuery;
import com.ibm.etools.fm.core.model.ims.ImsRegionType;
import com.ibm.etools.fm.core.model.ims.ImsSubsystem;
import com.ibm.etools.fm.core.model.ims.ImsSubsystemConfig;
import com.ibm.etools.fm.core.model.ims.ImsSubsystemQuery;
import com.ibm.etools.fm.core.socket.func.DSFMParser;
import com.ibm.etools.fm.core.socket.func.UtilityFunctionRunner;
import com.ibm.etools.fm.core.socket.func.ims.PCBL;
import com.ibm.etools.fm.core.socket.func.ims.PCBLParser;
import com.ibm.etools.fm.core.socket.func.ims.XDBDL;
import com.ibm.etools.fm.core.socket.func.ims.XPSBL;
import com.ibm.etools.fm.jhost.core.socket.func.UtilityFunction;
import com.ibm.etools.fm.jhost.core.socket.func.UtilityFunctionParser;
import com.ibm.etools.fm.ui.views.systems.model.DataSetTreeContent;
import com.ibm.etools.fm.ui.views.systems.model.FMTreeContent;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.jhost.comms.CommunicationException;
import com.ibm.pdtools.common.component.jhost.core.model.IPDConnectEndpoint;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.PDHostJhost;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.registery.EListener;
import com.ibm.pdtools.common.component.jhost.registery.EntityEvent;
import com.ibm.pdtools.common.component.jhost.registery.EntityEventType;
import com.ibm.pdtools.common.component.jhost.registery.EntityRegistry;
import com.ibm.pdtools.common.component.jhost.registery.HostRegistry;
import com.ibm.pdtools.common.component.jhost.registery.IContentLoadStatus;
import com.ibm.pdtools.common.component.jhost.registery.RegistryLocator;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import com.ibm.pdtools.common.component.ui.views.systems.model.ContentCache;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class ImsTreeContent
extends FMTreeContent {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2020. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final PDLogger logger = PDLogger.get(ImsTreeContent.class);
    private final ContentCache<ImsSubsystemQuery, List<ImsSubsystemConfig>> subsystemQueryCache;
    private final ContentCache<ImsPsbQuery, List<ImsPsb>> psbQueryCache;
    private final ContentCache<ImsDatabaseQuery, List<ImsDatabase>> databaseQueryCache;
    private final EntityRegistry<ImsPsbQuery> psbQueries;
    private final EntityRegistry<ImsDatabaseQuery> databaseQueries;
    private final EListener<EntityEvent<ImsSubsystemConfig>> subsystemConfigChangeListener = new EListener<EntityEvent<ImsSubsystemConfig>>(){

        public void onEvent(EntityEvent<ImsSubsystemConfig> event) {
            ImsSubsystem subsys = ((ImsSubsystemConfig)event.getEntity()).getSubsystem();
            for (ImsDatabaseQuery imsDatabaseQuery : ImsTreeContent.this.databaseQueries.all()) {
                if (!subsys.equals((Object)imsDatabaseQuery.getSubsystem())) continue;
                ImsTreeContent.this.databaseQueryCache.unloadContent((Object)imsDatabaseQuery);
            }
            for (ImsPsbQuery imsPsbQuery : ImsTreeContent.this.psbQueries.all()) {
                if (!subsys.equals((Object)imsPsbQuery.getSubsystem())) continue;
                ImsTreeContent.this.psbQueryCache.unloadContent((Object)imsPsbQuery);
            }
        }
    };

    public static List<ImsPcb> loadPCBs(ImsPsb entity, ImsRegionType regionType, IHowIsGoing monitor) throws InterruptedException, CommunicationException {
        PCBL pcbl = new PCBL();
        pcbl.setPsb(entity, regionType);
        pcbl.setConfig(entity.getSubsystem().getCanonicalConfig());
        Result result = UtilityFunctionRunner.executeAndParse((IPDHost)entity.getSystem(), (IPDConnectEndpoint)entity.getSubsystem(), (UtilityFunction)pcbl, (UtilityFunctionParser)new PCBLParser(entity), (IHowIsGoing)monitor);
        if (!result.isSuccessfulWithoutWarnings()) {
            StringBuilder message = result.getMessagesCombined();
            throw new CommunicationException(MessageFormat.format(com.ibm.pdtools.common.component.core.Messages.__LOAD_FAILED_DUE_TO_X, ImsTreeContent.removeFMNBB291(message.toString())));
        }
        return (List)result.getOutput();
    }

    private static String removeFMNBB291(String msg) {
        return msg.replace("FMNBB291 Function terminated", "").replace("FMNBB291 The user canceled the function, or the function could not be performed", "");
    }

    public static List<ImsDatabase> loadDatabases(ImsDatabaseQuery entity, String function, IHowIsGoing monitor) throws InterruptedException, CommunicationException {
        Result result;
        Objects.requireNonNull(entity, "Must specify a non-null entity.");
        ImsSubsystemConfig config = entity.getSubsystem().getCanonicalConfig();
        ArrayList<String> dsns = new ArrayList<String>();
        if (!config.isDir()) {
            List dbdLibs = config.getDbdLibs();
            for (DataSet dataSet : dbdLibs) {
                dsns.add(dataSet.getFormattedName());
            }
        }
        if (entity.getAccessMode() == ImsAccessMode.DYNAMIC) {
            XDBDL dbdl = new XDBDL();
            dbdl.setRegnType(entity.getRegionType());
            dbdl.setMember(entity.getPattern());
            dbdl.setIMSID(config.getSubsystem().getSubsystemID());
            dbdl.setFunctionCode(function);
            dbdl.setConfig(config);
            result = UtilityFunctionRunner.executeAndParse((IPDHost)entity.getSystem(), (IPDConnectEndpoint)entity.getSubsystem(), (UtilityFunction)dbdl, (UtilityFunctionParser)new DSFMParser(entity.getSystem(), dsns), (IHowIsGoing)monitor);
        } else {
            XPSBL psbl = new XPSBL();
            psbl.setRegnType(entity.getRegionType());
            psbl.setMember(entity.getPattern());
            psbl.setIMSID(config.getSubsystem().getSubsystemID());
            psbl.setConfig(config);
            result = UtilityFunctionRunner.executeAndParse((IPDHost)entity.getSystem(), (IPDConnectEndpoint)entity.getSubsystem(), (UtilityFunction)psbl, (UtilityFunctionParser)new DSFMParser(entity.getSystem(), dsns), (IHowIsGoing)monitor);
        }
        if (!result.isSuccessfulWithoutWarnings()) {
            throw new CommunicationException(MessageFormat.format(com.ibm.pdtools.common.component.core.Messages.__LOAD_FAILED_DUE_TO_X, result.getMessagesCombined()));
        }
        ArrayList<ImsDatabase> dbs = new ArrayList<ImsDatabase>();
        for (Member member : (List)result.getOutput()) {
            dbs.add(new ImsDatabase(entity.getSubsystem(), member.getName(), entity.getRegionType()));
        }
        return dbs;
    }

    public ImsTreeContent(final DataSetTreeContent dataSetContent) {
        this.psbQueryCache = new ContentCache((ContentCache.IEntityContentLoader)new ContentCache.IEntityContentLoader<ImsPsbQuery, List<ImsPsb>>(){

            public List<ImsPsb> loadEntityContent(ImsPsbQuery entity, IHowIsGoing monitor) throws InterruptedException, CommunicationException {
                return ImsPsb.loadPSBs((ImsPsbQuery)entity, (IHowIsGoing)monitor);
            }

            public String getJobName(ImsPsbQuery entity) {
                return MessageFormat.format(Messages.ImsTreeContent_LOADING_X, entity.getPDLabel());
            }
        });
        this.databaseQueryCache = new ContentCache((ContentCache.IEntityContentLoader)new ContentCache.IEntityContentLoader<ImsDatabaseQuery, List<ImsDatabase>>(){

            public List<ImsDatabase> loadEntityContent(ImsDatabaseQuery entity, IHowIsGoing monitor) throws InterruptedException, CommunicationException {
                return ImsTreeContent.loadDatabases(entity, null, monitor);
            }

            public String getJobName(ImsDatabaseQuery entity) {
                return MessageFormat.format(Messages.ImsTreeContent_LOADING_DBS_FOR_X, entity.getPDLabel());
            }
        });
        this.subsystemQueryCache = new ContentCache((ContentCache.IEntityContentLoader)new ContentCache.IEntityContentLoader<ImsSubsystemQuery, List<ImsSubsystemConfig>>(){

            public List<ImsSubsystemConfig> loadEntityContent(ImsSubsystemQuery query, IHowIsGoing monitor) throws CommunicationException, InterruptedException {
                Result result = query.loadSubsystems(monitor);
                if (!result.isSuccessfulWithoutWarnings()) {
                    throw new CommunicationException(MessageFormat.format(com.ibm.pdtools.common.component.core.Messages.__LOAD_FAILED_DUE_TO_X, result.getMessagesCombined()));
                }
                List subsystems = query.getSubsystems();
                for (ImsSubsystemConfig config : subsystems) {
                    ((FMHost)FMHost.getSystem((IPDHost)config.getSystem())).saveImsCanonicalConfig(config);
                }
                return subsystems;
            }

            public String getJobName(ImsSubsystemQuery entity) {
                return MessageFormat.format(com.ibm.pdtools.common.component.core.Messages._LOADING_X, Messages.ImsTreeContent_IMSSubsystems);
            }
        });
        this.subsystemQueryCache.addContentLoadedListener((ContentCache.EntityContentListener)new ContentCache.EntityContentListener<ImsSubsystemQuery, List<ImsSubsystemConfig>>(){

            public void postEntityContentLoad(ImsSubsystemQuery entity, IContentLoadStatus<List<ImsSubsystemConfig>> status) {
                if (status.getError() == null && status.getContentOnly() != null) {
                    for (ImsSubsystemConfig imsSubsystemConfig : (List)status.getContentOnly()) {
                        ImsTreeContent.this.subsystemLoaded(dataSetContent, imsSubsystemConfig.getSubsystem());
                    }
                }
            }

            public void preEntityContentUnload(ImsSubsystemQuery entity, IContentLoadStatus<List<ImsSubsystemConfig>> status) {
                if (status.getError() == null && status.getContentOnly() != null) {
                    for (ImsSubsystemConfig imsSubsystemConfig : (List)status.getContentOnly()) {
                        ImsTreeContent.this.subsystemPreUnload(dataSetContent, imsSubsystemConfig.getSubsystem());
                    }
                }
            }
        });
        this.psbQueries = new EntityRegistry();
        this.psbQueries.addListener((EListener)new EListener<EntityEvent<ImsPsbQuery>>(){

            public void onEvent(EntityEvent<ImsPsbQuery> event) {
                if (event.getType() == EntityEventType.ADDED) {
                    ImsTreeContent.this.psbQueryCache.acquireContentLock((Object)((ImsPsbQuery)event.getEntity()));
                } else if (event.getType() == EntityEventType.REMOVED) {
                    ImsTreeContent.this.psbQueryCache.releaseContentLock((Object)((ImsPsbQuery)event.getEntity()));
                }
            }
        });
        this.databaseQueries = new EntityRegistry();
        this.databaseQueries.addListener((EListener)new EListener<EntityEvent<ImsDatabaseQuery>>(){

            public void onEvent(EntityEvent<ImsDatabaseQuery> event) {
                if (event.getType() == EntityEventType.ADDED) {
                    ImsTreeContent.this.databaseQueryCache.acquireContentLock((Object)((ImsDatabaseQuery)event.getEntity()));
                } else if (event.getType() == EntityEventType.REMOVED) {
                    ImsTreeContent.this.databaseQueryCache.releaseContentLock((Object)((ImsDatabaseQuery)event.getEntity()));
                }
            }
        });
        HostRegistry hostRegistry = RegistryLocator.instance().getHostRegistry();
        hostRegistry.addListener((EListener)new EListener<EntityEvent<IPDHost>>(){

            public void onEvent(EntityEvent<IPDHost> event) {
                IPDHost host = (IPDHost)event.getEntity();
                if (event.getType() == EntityEventType.ADDED) {
                    ImsTreeContent.this.subsystemQueryCache.acquireContentLock((Object)ImsSubsystemQuery.createForHost((IPDHost)host));
                    ((FMHost)FMHost.getSystem((IPDHost)host)).addSubsystemConfigChangeListener(ImsTreeContent.this.subsystemConfigChangeListener);
                } else if (event.getType() == EntityEventType.REMOVED) {
                    ImsTreeContent.this.subsystemQueryCache.releaseContentLock((Object)ImsSubsystemQuery.createForHost((IPDHost)host));
                    ((FMHost)FMHost.getSystem((IPDHost)host)).removeSubsystemConfigChangeListener(ImsTreeContent.this.subsystemConfigChangeListener);
                }
            }
        });
        for (IPDHost host : hostRegistry.all()) {
            this.subsystemQueryCache.acquireContentLock((Object)ImsSubsystemQuery.createForHost((IPDHost)host));
        }
    }

    private void subsystemLoaded(DataSetTreeContent dataSetContent, ImsSubsystem imsSubsystem) {
        ImsSubsystemConfig config = imsSubsystem.getCanonicalConfig();
        this.psbQueryCache.acquireContentLock((Object)new ImsPsbQuery(config.getSubsystem(), "*", ImsRegionType.BMP, ImsAccessMode.STATIC));
        this.databaseQueryCache.acquireContentLock((Object)new ImsDatabaseQuery(config.getSubsystem(), "*", ImsRegionType.BMP, ImsAccessMode.STATIC));
        for (DataSet templateLib : config.getTemplateLibs()) {
            dataSetContent.getDataSetContentCache().acquireContentLock((Object)templateLib);
            dataSetContent.getDataSetTemplateInfoCache().acquireContentLock((Object)templateLib);
        }
        for (DataSet dbdLib : config.getDbdLibs()) {
            dataSetContent.getDataSetContentCache().acquireContentLock((Object)dbdLib);
            dataSetContent.getDataSetTemplateInfoCache().acquireContentLock((Object)dbdLib);
        }
        for (DataSet psbLib : config.getPsbLibs()) {
            dataSetContent.getDataSetContentCache().acquireContentLock((Object)psbLib);
            dataSetContent.getDataSetTemplateInfoCache().acquireContentLock((Object)psbLib);
        }
    }

    private void subsystemPreUnload(DataSetTreeContent dataSetContent, ImsSubsystem imsSubsystem) {
        ImsSubsystemConfig config = imsSubsystem.getCanonicalConfig();
        if (config != null) {
            this.psbQueryCache.releaseContentLock((Object)new ImsPsbQuery(config.getSubsystem(), "*", ImsRegionType.BMP, ImsAccessMode.STATIC));
            this.databaseQueryCache.releaseContentLock((Object)new ImsDatabaseQuery(config.getSubsystem(), "*", ImsRegionType.BMP, ImsAccessMode.STATIC));
            for (DataSet templateLib : config.getTemplateLibs()) {
                dataSetContent.getDataSetContentCache().releaseContentLock((Object)templateLib);
                dataSetContent.getDataSetTemplateInfoCache().releaseContentLock((Object)templateLib);
            }
            for (DataSet dbdLib : config.getDbdLibs()) {
                dataSetContent.getDataSetContentCache().releaseContentLock((Object)dbdLib);
                dataSetContent.getDataSetTemplateInfoCache().releaseContentLock((Object)dbdLib);
            }
            for (DataSet psbLib : config.getPsbLibs()) {
                dataSetContent.getDataSetContentCache().releaseContentLock((Object)psbLib);
                dataSetContent.getDataSetTemplateInfoCache().releaseContentLock((Object)psbLib);
            }
        } else {
            logger.info((Object)MessageFormat.format("IMS system {0} has no canonical config ( it is null).", config));
        }
    }

    public List<ImsPsbQuery> getPsbQueriesForHost(IPDHost host) {
        List queries = this.psbQueries.all();
        Iterator iterator = queries.iterator();
        while (iterator.hasNext()) {
            ImsPsbQuery query = (ImsPsbQuery)iterator.next();
            if (query.getSystem().equals(host)) continue;
            iterator.remove();
        }
        return queries;
    }

    public List<ImsPsbQuery> getPsbQueriesForSubsystem(ImsSubsystem subsystem) {
        List queries = this.psbQueries.all();
        Iterator iterator = queries.iterator();
        while (iterator.hasNext()) {
            ImsPsbQuery query = (ImsPsbQuery)iterator.next();
            if (query.getSubsystem().equals((Object)subsystem) && PDHostJhost.xnorDeligated((IPDHost)subsystem.getSystem(), (IPDHost)query.getSubsystem().getSystem())) continue;
            iterator.remove();
        }
        return queries;
    }

    public List<ImsDatabaseQuery> getDatabaseQueriesForHost(IPDHost host) {
        List queries = this.databaseQueries.all();
        Iterator iterator = queries.iterator();
        while (iterator.hasNext()) {
            ImsDatabaseQuery query = (ImsDatabaseQuery)iterator.next();
            if (query.getSystem().equals(host) && PDHostJhost.xnorDeligated((IPDHost)host, (IPDHost)query.getSystem())) continue;
            iterator.remove();
        }
        return queries;
    }

    public List<ImsDatabaseQuery> getDatabaseQueriesForSubsystem(ImsSubsystem subsystem) {
        List queries = this.databaseQueries.all();
        Iterator iterator = queries.iterator();
        while (iterator.hasNext()) {
            ImsDatabaseQuery query = (ImsDatabaseQuery)iterator.next();
            if (query.getSubsystem().equals((Object)subsystem) && PDHostJhost.xnorDeligated((IPDHost)subsystem.getSystem(), (IPDHost)query.getSubsystem().getSystem())) continue;
            iterator.remove();
        }
        return queries;
    }

    public Set<ImsSubsystem> getSubsystemsWithQueriesOrCustomConfigsForHost(IPDHost host) {
        HashSet<ImsSubsystem> subsystemsSet = new HashSet<ImsSubsystem>();
        for (ImsSubsystemConfig config : ((FMHost)FMHost.getSystem((IPDHost)host)).getImsConfigs()) {
            subsystemsSet.add(config.getSubsystem());
        }
        subsystemsSet.addAll(this.getSubsystemsWithQueriesForHost(host));
        return subsystemsSet;
    }

    public List<ImsSubsystem> getSubsystemsWithQueriesForHost(IPDHost host) {
        HashSet<ImsSubsystem> imsSubsystemsWithQueries = new HashSet<ImsSubsystem>();
        for (ImsPsbQuery psbQuery : this.getPsbQueriesForHost(host)) {
            imsSubsystemsWithQueries.add(psbQuery.getSubsystem());
        }
        for (ImsDatabaseQuery dbQuery : this.getDatabaseQueriesForHost(host)) {
            imsSubsystemsWithQueries.add(dbQuery.getSubsystem());
        }
        return new ArrayList<ImsSubsystem>(imsSubsystemsWithQueries);
    }

    public ContentCache<ImsSubsystemQuery, List<ImsSubsystemConfig>> getSubsystemQueryCache() {
        return this.subsystemQueryCache;
    }

    public ContentCache<ImsPsbQuery, List<ImsPsb>> getPsbQueryCache() {
        return this.psbQueryCache;
    }

    public ContentCache<ImsDatabaseQuery, List<ImsDatabase>> getDatabaseQueryCache() {
        return this.databaseQueryCache;
    }

    public EntityRegistry<ImsDatabaseQuery> getDatabaseQueries() {
        return this.databaseQueries;
    }

    public EntityRegistry<ImsPsbQuery> getPsbQueries() {
        return this.psbQueries;
    }
}

