/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.views.systems.model;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.db2.Db2Database;
import com.ibm.etools.fm.core.model.db2.Db2Object;
import com.ibm.etools.fm.core.model.db2.Db2ObjectQuery;
import com.ibm.etools.fm.core.model.db2.Db2Subsystem;
import com.ibm.etools.fm.core.model.db2.Db2SubsystemQuery;
import com.ibm.etools.fm.core.model.db2.Db2Table;
import com.ibm.etools.fm.ui.views.systems.model.FMTreeContent;
import com.ibm.pdtools.common.component.jhost.comms.CommunicationException;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.PDHostJhost;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.registery.EListener;
import com.ibm.pdtools.common.component.jhost.registery.EntityEvent;
import com.ibm.pdtools.common.component.jhost.registery.EntityEventType;
import com.ibm.pdtools.common.component.jhost.registery.EntityRegistry;
import com.ibm.pdtools.common.component.jhost.registery.HostRegistry;
import com.ibm.pdtools.common.component.jhost.registery.IContentLoadStatus;
import com.ibm.pdtools.common.component.jhost.registery.RegistryLocator;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import com.ibm.pdtools.common.component.ui.views.systems.model.ContentCache;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class Db2TreeContent
extends FMTreeContent {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private final EntityRegistry<Db2ObjectQuery<?>> objectQueryRegistry;
    private final ContentCache<Db2SubsystemQuery, List<Db2Subsystem>> subsystemQueryCache;
    private final ContentCache<Db2ObjectQuery<?>, List<? extends Db2Object>> objectQueryCache = new ContentCache(new ContentCache.IEntityContentLoader<Db2ObjectQuery<?>, List<? extends Db2Object>>(){

        public List<? extends Db2Object> loadEntityContent(Db2ObjectQuery<?> entity, IHowIsGoing monitor) throws InterruptedException, CommunicationException {
            Result result = entity.loadObjects(monitor);
            if (!result.isSuccessfulWithoutWarnings()) {
                throw new CommunicationException(MessageFormat.format(com.ibm.pdtools.common.component.core.Messages.__LOAD_FAILED_DUE_TO_X, result.getMessagesCombined()));
            }
            return entity.getObjects();
        }

        public String getJobName(Db2ObjectQuery<?> entity) {
            return MessageFormat.format(com.ibm.pdtools.common.component.core.Messages._LOADING_X, entity.getLabel());
        }
    });

    public Db2TreeContent() {
        this.objectQueryCache.addContentLoadedListener(new ContentCache.EntityContentListener<Db2ObjectQuery<?>, List<? extends Db2Object>>(){

            public void postEntityContentLoad(Db2ObjectQuery<?> entity, IContentLoadStatus<List<? extends Db2Object>> status) {
                if (status.getError() == null && status.getContentOnly() != null) {
                    for (Db2Object db2Object : (List)status.getContentOnly()) {
                        if (!(db2Object instanceof Db2Database)) continue;
                        Db2Database db = (Db2Database)db2Object;
                        Db2TreeContent.this.objectQueryCache.acquireContentLock((Object)Db2ObjectQuery.createBrowseUserForDatabase((Db2Database)db));
                    }
                }
            }

            public void preEntityContentUnload(Db2ObjectQuery<?> entity, IContentLoadStatus<List<? extends Db2Object>> status) {
                if (status.getError() == null && status.getContentOnly() != null) {
                    for (Db2Object db2Object : (List)status.getContentOnly()) {
                        if (!(db2Object instanceof Db2Database)) continue;
                        Db2Database db = (Db2Database)db2Object;
                        Db2TreeContent.this.objectQueryCache.releaseContentLock((Object)Db2ObjectQuery.createBrowseUserForDatabase((Db2Database)db));
                    }
                }
            }
        });
        this.subsystemQueryCache = new ContentCache((ContentCache.IEntityContentLoader)new ContentCache.IEntityContentLoader<Db2SubsystemQuery, List<Db2Subsystem>>(){

            public List<Db2Subsystem> loadEntityContent(Db2SubsystemQuery query, IHowIsGoing monitor) throws InterruptedException, CommunicationException {
                Result result = query.loadSubsystems(monitor);
                if (!result.isSuccessfulWithoutWarnings()) {
                    throw new CommunicationException(MessageFormat.format(com.ibm.pdtools.common.component.core.Messages.__LOAD_FAILED_DUE_TO_X, result.getMessagesCombined()));
                }
                return query.getSubsystems();
            }

            public String getJobName(Db2SubsystemQuery entity) {
                return MessageFormat.format(com.ibm.pdtools.common.component.core.Messages._LOADING_X, Messages.Db2TreeContent_DB2Subsystems);
            }
        });
        this.subsystemQueryCache.addContentLoadedListener((ContentCache.EntityContentListener)new ContentCache.EntityContentListener<Db2SubsystemQuery, List<Db2Subsystem>>(){

            public void postEntityContentLoad(Db2SubsystemQuery entity, IContentLoadStatus<List<Db2Subsystem>> status) {
                if (status.getError() == null && status.getContentOnly() != null) {
                    for (Db2Subsystem subsystem : (List)status.getContentOnly()) {
                        Db2TreeContent.this.objectQueryCache.acquireContentLock((Object)Db2ObjectQuery.createBrowseUser((Db2Subsystem)subsystem, Db2Table.class));
                        Db2TreeContent.this.objectQueryCache.acquireContentLock((Object)Db2ObjectQuery.createBrowseUser((Db2Subsystem)subsystem, Db2Database.class));
                    }
                }
            }

            public void preEntityContentUnload(Db2SubsystemQuery entity, IContentLoadStatus<List<Db2Subsystem>> status) {
                if (status.getError() == null && status.getContentOnly() != null) {
                    for (Db2Subsystem subsystem : (List)status.getContentOnly()) {
                        Db2TreeContent.this.objectQueryCache.releaseContentLock((Object)Db2ObjectQuery.createBrowseUser((Db2Subsystem)subsystem, Db2Table.class));
                        Db2TreeContent.this.objectQueryCache.releaseContentLock((Object)Db2ObjectQuery.createBrowseUser((Db2Subsystem)subsystem, Db2Database.class));
                    }
                }
            }
        });
        this.objectQueryRegistry = new EntityRegistry();
        this.objectQueryRegistry.addListener(new EListener<EntityEvent<Db2ObjectQuery<?>>>(){

            public void onEvent(EntityEvent<Db2ObjectQuery<?>> event) {
                if (event.getType() == EntityEventType.ADDED) {
                    Db2TreeContent.this.objectQueryCache.acquireContentLock((Object)((Db2ObjectQuery)event.getEntity()));
                } else if (event.getType() == EntityEventType.REMOVED) {
                    Db2TreeContent.this.objectQueryCache.releaseContentLock((Object)((Db2ObjectQuery)event.getEntity()));
                }
            }
        });
        HostRegistry hostRegistry = RegistryLocator.instance().getHostRegistry();
        hostRegistry.addListener((EListener)new EListener<EntityEvent<IPDHost>>(){

            public void onEvent(EntityEvent<IPDHost> event) {
                IPDHost host = (IPDHost)event.getEntity();
                if (event.getType() == EntityEventType.ADDED) {
                    Db2TreeContent.this.subsystemQueryCache.acquireContentLock((Object)Db2SubsystemQuery.createForHost((IPDHost)host));
                } else if (event.getType() == EntityEventType.REMOVED) {
                    List<Db2ObjectQuery<?>> queriesToRemove = Db2TreeContent.this.getQueriesForHost(host);
                    for (Db2ObjectQuery<?> query : queriesToRemove) {
                        Db2TreeContent.this.objectQueryRegistry.remove(query);
                    }
                    Db2TreeContent.this.subsystemQueryCache.releaseContentLock((Object)Db2SubsystemQuery.createForHost((IPDHost)host));
                }
            }
        });
        for (IPDHost host : hostRegistry.all()) {
            this.subsystemQueryCache.acquireContentLock((Object)Db2SubsystemQuery.createForHost((IPDHost)host));
        }
    }

    public List<Db2ObjectQuery<?>> getQueriesForHost(IPDHost host) {
        List queries = this.objectQueryRegistry.all();
        Iterator iterator = queries.iterator();
        while (iterator.hasNext()) {
            Db2ObjectQuery query = (Db2ObjectQuery)iterator.next();
            if (host.equals(query.getSystem())) continue;
            iterator.remove();
        }
        return queries;
    }

    public List<Db2ObjectQuery<?>> getQueriesForSubsystem(Db2Subsystem subsystem) {
        List queries = this.objectQueryRegistry.all();
        Iterator iterator = queries.iterator();
        while (iterator.hasNext()) {
            Db2ObjectQuery query = (Db2ObjectQuery)iterator.next();
            if (subsystem.equals((Object)query.getSubsystem()) && PDHostJhost.xnorDeligated((IPDHost)subsystem.getSystem(), (IPDHost)query.getSubsystem().getSystem())) continue;
            iterator.remove();
        }
        return queries;
    }

    public List<Db2Subsystem> getSubsystemsWithQueries(IPDHost host) {
        HashSet<Db2Subsystem> appls = new HashSet<Db2Subsystem>();
        List<Db2ObjectQuery<?>> queries = this.getQueriesForHost(host);
        for (Db2ObjectQuery<?> query : queries) {
            appls.add(query.getSubsystem());
        }
        return new ArrayList<Db2Subsystem>(appls);
    }

    public EntityRegistry<Db2ObjectQuery<?>> getObjectQueryRegistry() {
        return this.objectQueryRegistry;
    }

    public ContentCache<Db2SubsystemQuery, List<Db2Subsystem>> getSubsystemQueryCache() {
        return this.subsystemQueryCache;
    }

    public ContentCache<Db2ObjectQuery<?>, List<? extends Db2Object>> getObjectQueryCache() {
        return this.objectQueryCache;
    }
}

