/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.views.systems.model;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.DataSet;
import com.ibm.etools.fm.core.model.DataSetQuery;
import com.ibm.etools.fm.core.model.FMHost;
import com.ibm.etools.fm.core.model.HostVersion;
import com.ibm.etools.fm.core.model.Member;
import com.ibm.etools.fm.core.socket.func.DSFM;
import com.ibm.etools.fm.core.socket.func.DSFMParser;
import com.ibm.etools.fm.core.socket.func.UtilityFunctionRunner;
import com.ibm.etools.fm.jhost.core.socket.func.UtilityFunction;
import com.ibm.etools.fm.jhost.core.socket.func.UtilityFunctionParser;
import com.ibm.etools.fm.jhost.core.version.FMFeature;
import com.ibm.pdtools.common.component.jhost.comms.CommunicationException;
import com.ibm.pdtools.common.component.jhost.core.model.IPDConnectEndpoint;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.registery.EListener;
import com.ibm.pdtools.common.component.jhost.registery.EntityEvent;
import com.ibm.pdtools.common.component.jhost.registery.EntityEventType;
import com.ibm.pdtools.common.component.jhost.registery.EntityRegistry;
import com.ibm.pdtools.common.component.jhost.registery.HostRegistry;
import com.ibm.pdtools.common.component.jhost.registery.IContentLoadStatus;
import com.ibm.pdtools.common.component.jhost.registery.RegistryLocator;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import com.ibm.pdtools.common.component.jhost.version.PDFeature;
import com.ibm.pdtools.common.component.ui.views.systems.PDSystemsView;
import com.ibm.pdtools.common.component.ui.views.systems.model.ContentCache;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class DataSetTreeContent {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2021. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private final ContentCache<DataSet, List<Member>> dataSetTemplateInfoCache = new ContentCache((ContentCache.IEntityContentLoader)new ContentCache.IEntityContentLoader<DataSet, List<Member>>(){

        public List<Member> loadEntityContent(DataSet dataSet, IHowIsGoing monitor) throws InterruptedException, CommunicationException {
            Result result;
            DSFM dsfm = new DSFM(dataSet.getSystem());
            List<String> dsns = Collections.singletonList(dataSet.getName());
            dsfm.setDsnList(dsns);
            dsfm.setMember("*");
            dsfm.setTypes(Arrays.asList(Member.TemplateInfo.DsfmTemplateType.values()));
            HostVersion.getInstance().setHost(dataSet.getSystem());
            int hostVersion = HostVersion.getInstance().getVersion();
            int MAX_HOST_VER = 140114;
            if (hostVersion >= MAX_HOST_VER) {
                dsfm.setXMLVER();
            }
            if (!(result = UtilityFunctionRunner.executeAndParse((IPDHost)dataSet.getSystem(), (IPDConnectEndpoint)FMHost.getSystem((IPDHost)dataSet.getSystem()), (UtilityFunction)dsfm, (UtilityFunctionParser)new DSFMParser(dataSet.getSystem(), dsns), (IHowIsGoing)monitor)).isSuccessfulWithoutWarnings()) {
                String message = result.getMessagesCombined().toString();
                throw new CommunicationException(MessageFormat.format(com.ibm.pdtools.common.component.core.Messages.__LOAD_FAILED_DUE_TO_X, message));
            }
            return (List)result.getOutput();
        }

        public String getJobName(DataSet entity) {
            return Messages.DataSetNode_SEARCHING_FOR_TEMPLATES;
        }
    });
    private final ContentCache<DataSet, List<Member>> dataSetMembersCache;
    private final EntityRegistry<DataSetQuery> queryRegistry;
    private final ContentCache<DataSetQuery, List<DataSet>> queryDataSetsCache;

    public DataSetTreeContent() {
        this.dataSetTemplateInfoCache.addContentLoadedListener((ContentCache.EntityContentListener)new ContentCache.EntityContentListener<DataSet, List<Member>>(){

            public void postEntityContentLoad(DataSet dataSet, IContentLoadStatus<List<Member>> status) {
                List templateInfoMembers = (List)status.getContentOnly();
                if (templateInfoMembers != null) {
                    List knownMembers = (List)DataSetTreeContent.this.dataSetMembersCache.getLoadStatus((Object)dataSet).getContentOnly();
                    for (Member knownMember : knownMembers) {
                        int templateInfoPos = templateInfoMembers.indexOf(knownMember);
                        if (templateInfoPos == -1) continue;
                        Member.TemplateInfo templateInfo = ((Member)templateInfoMembers.get(templateInfoPos)).getTemplateInfo();
                        knownMember.setTemplateInfo(templateInfo);
                    }
                    PDSystemsView.tryRefresh();
                }
            }

            public void preEntityContentUnload(DataSet entity, IContentLoadStatus<List<Member>> status) {
            }
        });
        this.dataSetMembersCache = new ContentCache((ContentCache.IEntityContentLoader)new ContentCache.IEntityContentLoader<DataSet, List<Member>>(){

            public List<Member> loadEntityContent(DataSet dataSet, IHowIsGoing monitor) throws InterruptedException, CommunicationException {
                Result result = dataSet.refreshSelf(monitor);
                if (!result.isSuccessfulWithoutWarnings()) {
                    String shortMessage = result.getMessagesCombined().toString();
                    throw new CommunicationException(MessageFormat.format(com.ibm.pdtools.common.component.core.Messages.__LOAD_FAILED_DUE_TO_X, shortMessage));
                }
                return dataSet.getMembers();
            }

            public String getJobName(DataSet entity) {
                return MessageFormat.format(com.ibm.pdtools.common.component.core.Messages._LOADING_X, entity.getName());
            }
        });
        this.dataSetMembersCache.addContentLoadedListener((ContentCache.EntityContentListener)new ContentCache.EntityContentListener<DataSet, List<Member>>(){

            public void postEntityContentLoad(DataSet entity, IContentLoadStatus<List<Member>> status) {
                if (entity.getConfirmedExists() && entity.getMembers() != null && entity.getMembers().size() > 0 && entity.getSystem().supports((PDFeature)FMFeature.MEMBER_TEMPLATE_LIST)) {
                    DataSetTreeContent.this.dataSetTemplateInfoCache.loadContent((Object)entity);
                }
            }

            public void preEntityContentUnload(DataSet entity, IContentLoadStatus<List<Member>> status) {
                if (entity.getSystem().supports((PDFeature)FMFeature.MEMBER_TEMPLATE_LIST)) {
                    DataSetTreeContent.this.dataSetTemplateInfoCache.unloadContent((Object)entity);
                }
            }
        });
        this.queryRegistry = new EntityRegistry();
        this.queryDataSetsCache = new ContentCache((ContentCache.IEntityContentLoader)new ContentCache.IEntityContentLoader<DataSetQuery, List<DataSet>>(){

            public List<DataSet> loadEntityContent(DataSetQuery query, IHowIsGoing monitor) throws InterruptedException, CommunicationException {
                Result result = query.loadDataSets(monitor);
                if (!result.isSuccessfulWithoutWarnings()) {
                    String message = result.getMessagesCombined().toString();
                    throw new CommunicationException(MessageFormat.format(com.ibm.pdtools.common.component.core.Messages.__LOAD_FAILED_DUE_TO_X, message));
                }
                return (List)result.getOutput();
            }

            public String getJobName(DataSetQuery entity) {
                return MessageFormat.format(com.ibm.pdtools.common.component.core.Messages._LOADING_X, entity.getLabel());
            }
        });
        this.queryDataSetsCache.addContentLoadedListener((ContentCache.EntityContentListener)new ContentCache.EntityContentListener<DataSetQuery, List<DataSet>>(){

            public void postEntityContentLoad(DataSetQuery entity, IContentLoadStatus<List<DataSet>> status) {
                if (status.getError() == null && status.getContentOnly() != null) {
                    for (DataSet ds : (List)status.getContentOnly()) {
                        DataSetTreeContent.this.dataSetMembersCache.acquireContentLock((Object)ds);
                        DataSetTreeContent.this.dataSetTemplateInfoCache.acquireContentLock((Object)ds);
                    }
                }
            }

            public void preEntityContentUnload(DataSetQuery entity, IContentLoadStatus<List<DataSet>> status) {
                if (status.getError() == null && status.getContentOnly() != null) {
                    for (DataSet ds : (List)status.getContentOnly()) {
                        DataSetTreeContent.this.dataSetMembersCache.releaseContentLock((Object)ds);
                        DataSetTreeContent.this.dataSetTemplateInfoCache.releaseContentLock((Object)ds);
                    }
                }
            }
        });
        this.queryRegistry.addListener((EListener)new EListener<EntityEvent<DataSetQuery>>(){

            public void onEvent(EntityEvent<DataSetQuery> event) {
                if (event.getType() == EntityEventType.ADDED) {
                    DataSetTreeContent.this.queryDataSetsCache.acquireContentLock((Object)((DataSetQuery)event.getEntity()));
                    ((DataSetQuery)event.getEntity()).setFetchingProperties(false);
                } else if (event.getType() == EntityEventType.REMOVED) {
                    DataSetTreeContent.this.queryDataSetsCache.releaseContentLock((Object)((DataSetQuery)event.getEntity()));
                }
            }
        });
        HostRegistry hostRegistry = RegistryLocator.instance().getHostRegistry();
        hostRegistry.addListener((EListener)new EListener<EntityEvent<IPDHost>>(){

            public void onEvent(EntityEvent<IPDHost> event) {
                IPDHost host = (IPDHost)event.getEntity();
                if (event.getType() == EntityEventType.ADDED) {
                    DataSetTreeContent.this.queryDataSetsCache.acquireContentLock((Object)DataSetQuery.createBrowseUser((IPDHost)host));
                } else if (event.getType() == EntityEventType.REMOVED) {
                    List<DataSetQuery> queriesToRemove = DataSetTreeContent.this.getQueriesForHost(host);
                    for (DataSetQuery query : queriesToRemove) {
                        DataSetTreeContent.this.queryRegistry.remove((Object)query);
                    }
                    DataSetTreeContent.this.queryDataSetsCache.releaseContentLock((Object)DataSetQuery.createBrowseUser((IPDHost)host));
                }
            }
        });
        for (IPDHost host : hostRegistry.all()) {
            this.queryDataSetsCache.acquireContentLock((Object)DataSetQuery.createBrowseUser((IPDHost)host));
        }
    }

    public List<DataSetQuery> getQueriesForHost(IPDHost host) {
        List queries = this.queryRegistry.all();
        Iterator iterator = queries.iterator();
        while (iterator.hasNext()) {
            DataSetQuery query = (DataSetQuery)iterator.next();
            if (host.equals(query.getSystem())) continue;
            iterator.remove();
        }
        return queries;
    }

    public EntityRegistry<DataSetQuery> getQueryRegistry() {
        return this.queryRegistry;
    }

    public ContentCache<DataSet, List<Member>> getDataSetContentCache() {
        return this.dataSetMembersCache;
    }

    public ContentCache<DataSet, List<Member>> getDataSetTemplateInfoCache() {
        return this.dataSetTemplateInfoCache;
    }

    public ContentCache<DataSetQuery, List<DataSet>> getQueryContentCache() {
        return this.queryDataSetsCache;
    }
}

