/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.views.systems.model;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.cics.CicsAppl;
import com.ibm.etools.fm.core.model.cics.CicsApplIDQuery;
import com.ibm.etools.fm.core.model.cics.CicsFileQuery;
import com.ibm.etools.fm.core.model.cics.CicsResource;
import com.ibm.etools.fm.core.model.cics.CicsResourceQuery;
import com.ibm.etools.fm.core.model.cics.CicsTemporaryStorageQuery;
import com.ibm.etools.fm.core.model.cics.CicsTransientDataQuery;
import com.ibm.etools.fm.ui.views.systems.model.FMTreeContent;
import com.ibm.pdtools.common.component.jhost.comms.CommunicationException;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.PDHostJhost;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.registery.EListener;
import com.ibm.pdtools.common.component.jhost.registery.EntityEvent;
import com.ibm.pdtools.common.component.jhost.registery.EntityEventType;
import com.ibm.pdtools.common.component.jhost.registery.EntityRegistry;
import com.ibm.pdtools.common.component.jhost.registery.HostRegistry;
import com.ibm.pdtools.common.component.jhost.registery.IContentLoadStatus;
import com.ibm.pdtools.common.component.jhost.registery.RegistryLocator;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import com.ibm.pdtools.common.component.ui.views.systems.model.ContentCache;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class CicsTreeContent
extends FMTreeContent {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private final EntityRegistry<CicsResourceQuery<?>> resourceQueryRegistry;
    private final ContentCache<CicsApplIDQuery, List<CicsAppl>> applQueryCache;
    private final ContentCache<CicsResourceQuery<?>, List<? extends CicsResource>> resourceQueryCache = new ContentCache(new ContentCache.IEntityContentLoader<CicsResourceQuery<?>, List<? extends CicsResource>>(){

        public List<? extends CicsResource> loadEntityContent(CicsResourceQuery<?> entity, IHowIsGoing monitor) throws InterruptedException, CommunicationException {
            Result result = entity.loadCICSResources(monitor);
            if (!result.isSuccessfulWithoutWarnings()) {
                throw new CommunicationException(MessageFormat.format(com.ibm.pdtools.common.component.core.Messages.__LOAD_FAILED_DUE_TO_X, result.getMessagesCombined()));
            }
            return entity.getCICSResources();
        }

        public String getJobName(CicsResourceQuery<?> entity) {
            return MessageFormat.format(com.ibm.pdtools.common.component.core.Messages._LOADING_X, entity.getLabel());
        }
    });

    public CicsTreeContent() {
        this.applQueryCache = new ContentCache((ContentCache.IEntityContentLoader)new ContentCache.IEntityContentLoader<CicsApplIDQuery, List<CicsAppl>>(){

            public List<CicsAppl> loadEntityContent(CicsApplIDQuery query, IHowIsGoing monitor) throws InterruptedException, CommunicationException {
                Result result = query.loadCICSApps(monitor);
                if (!result.isSuccessfulWithoutWarnings()) {
                    throw new CommunicationException(MessageFormat.format(com.ibm.pdtools.common.component.core.Messages.__LOAD_FAILED_DUE_TO_X, result.getMessagesCombined()));
                }
                return (List)result.getOutput();
            }

            public String getJobName(CicsApplIDQuery entity) {
                return MessageFormat.format(com.ibm.pdtools.common.component.core.Messages._LOADING_X, Messages.CicsTreeContent_CICSApplications);
            }
        });
        this.applQueryCache.addContentLoadedListener((ContentCache.EntityContentListener)new ContentCache.EntityContentListener<CicsApplIDQuery, List<CicsAppl>>(){

            public void postEntityContentLoad(CicsApplIDQuery entity, IContentLoadStatus<List<CicsAppl>> status) {
                if (status.getError() == null && status.getContentOnly() != null) {
                    for (CicsAppl cicsAppl : (List)status.getContentOnly()) {
                        CicsTreeContent.this.resourceQueryCache.acquireContentLock((Object)CicsFileQuery.createForApplication((CicsAppl)cicsAppl));
                        CicsTreeContent.this.resourceQueryCache.acquireContentLock((Object)CicsTransientDataQuery.createForApplication((CicsAppl)cicsAppl));
                        CicsTreeContent.this.resourceQueryCache.acquireContentLock((Object)CicsTemporaryStorageQuery.createForApplication((CicsAppl)cicsAppl));
                    }
                }
            }

            public void preEntityContentUnload(CicsApplIDQuery entity, IContentLoadStatus<List<CicsAppl>> status) {
                if (status.getError() == null && status.getContentOnly() != null) {
                    for (CicsAppl cicsAppl : (List)status.getContentOnly()) {
                        CicsTreeContent.this.resourceQueryCache.releaseContentLock((Object)CicsFileQuery.createForApplication((CicsAppl)cicsAppl));
                        CicsTreeContent.this.resourceQueryCache.releaseContentLock((Object)CicsTransientDataQuery.createForApplication((CicsAppl)cicsAppl));
                        CicsTreeContent.this.resourceQueryCache.releaseContentLock((Object)CicsTemporaryStorageQuery.createForApplication((CicsAppl)cicsAppl));
                    }
                }
            }
        });
        this.resourceQueryRegistry = new EntityRegistry();
        this.resourceQueryRegistry.addListener(new EListener<EntityEvent<CicsResourceQuery<?>>>(){

            public void onEvent(EntityEvent<CicsResourceQuery<?>> event) {
                if (event.getType() == EntityEventType.ADDED) {
                    CicsTreeContent.this.resourceQueryCache.acquireContentLock((Object)((CicsResourceQuery)event.getEntity()));
                } else if (event.getType() == EntityEventType.REMOVED) {
                    CicsTreeContent.this.resourceQueryCache.releaseContentLock((Object)((CicsResourceQuery)event.getEntity()));
                }
            }
        });
        HostRegistry hostRegistry = RegistryLocator.instance().getHostRegistry();
        hostRegistry.addListener((EListener)new EListener<EntityEvent<IPDHost>>(){

            public void onEvent(EntityEvent<IPDHost> event) {
                IPDHost host = (IPDHost)event.getEntity();
                if (event.getType() == EntityEventType.ADDED) {
                    CicsTreeContent.this.applQueryCache.acquireContentLock((Object)CicsApplIDQuery.createForHost((IPDHost)host));
                } else if (event.getType() == EntityEventType.REMOVED) {
                    List<CicsResourceQuery<?>> queriesToRemove = CicsTreeContent.this.getQueriesForHost(host);
                    for (CicsResourceQuery<?> query : queriesToRemove) {
                        CicsTreeContent.this.resourceQueryRegistry.remove(query);
                    }
                    CicsTreeContent.this.applQueryCache.releaseContentLock((Object)CicsApplIDQuery.createForHost((IPDHost)host));
                }
            }
        });
        for (IPDHost host : hostRegistry.all()) {
            this.applQueryCache.acquireContentLock((Object)CicsApplIDQuery.createForHost((IPDHost)host));
        }
    }

    public List<CicsResourceQuery<?>> getQueriesForHost(IPDHost host) {
        List queries = this.resourceQueryRegistry.all();
        Iterator iterator = queries.iterator();
        while (iterator.hasNext()) {
            CicsResourceQuery query = (CicsResourceQuery)iterator.next();
            if (host.equals(query.getSystem()) && PDHostJhost.xnorDeligated((IPDHost)host, (IPDHost)query.getSystem())) continue;
            iterator.remove();
        }
        return queries;
    }

    public List<CicsResourceQuery<?>> getQueriesForApplication(CicsAppl cicsAppl) {
        List queries = this.resourceQueryRegistry.all();
        Iterator iterator = queries.iterator();
        while (iterator.hasNext()) {
            CicsResourceQuery query = (CicsResourceQuery)iterator.next();
            if (cicsAppl.equals((Object)query.getCICSAppl()) && PDHostJhost.xnorDeligated((IPDHost)cicsAppl.getSystem(), (IPDHost)query.getSystem())) continue;
            iterator.remove();
        }
        return queries;
    }

    public List<CicsAppl> getApplicationsWithQueries(IPDHost host) {
        HashSet<CicsAppl> appls = new HashSet<CicsAppl>();
        List<CicsResourceQuery<?>> queries = this.getQueriesForHost(host);
        for (CicsResourceQuery<?> query : queries) {
            appls.add(query.getCICSAppl());
        }
        return new ArrayList<CicsAppl>(appls);
    }

    public EntityRegistry<CicsResourceQuery<?>> getResourceQueryRegistry() {
        return this.resourceQueryRegistry;
    }

    public ContentCache<CicsApplIDQuery, List<CicsAppl>> getApplQueryCache() {
        return this.applQueryCache;
    }

    public ContentCache<CicsResourceQuery<?>, List<? extends CicsResource>> getResourceQueryCache() {
        return this.resourceQueryCache;
    }
}

