/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.views.systems.model;

import com.ibm.etools.fm.ui.history.ActionHistorySourceProvider;
import com.ibm.etools.fm.ui.history.ActionType;
import com.ibm.etools.fm.ui.history.IActionItem;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.registery.EListener;
import com.ibm.pdtools.common.component.jhost.registery.EntityEvent;
import com.ibm.pdtools.common.component.jhost.registery.EntityEventType;
import com.ibm.pdtools.common.component.jhost.registery.EntityRegistry;
import com.ibm.pdtools.common.component.jhost.registery.RegistryLocator;
import com.ibm.pdtools.common.component.ui.util.EclipseUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.eclipse.swt.widgets.Display;

public class ActionHistoryContent {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private final EntityRegistry<IActionItem> actionRegistry = new EntityRegistry();
    public static final Comparator<IActionItem> EXECUTION_ORDER_COMPARATOR = new Comparator<IActionItem>(){

        @Override
        public int compare(IActionItem a, IActionItem b) {
            long diff = b.getLastExecutionTime() - a.getLastExecutionTime();
            return diff == 0L ? 0 : (diff < -1L ? -1 : 1);
        }
    };
    public static final int MAX_RECENTLY_EXECUTED_SIZE = 10;
    public static final int RECENT_LIMIT = 25;

    public static void removeNonFavorites(List<IActionItem> actionItems) {
        Objects.requireNonNull(actionItems, "Must specify a non-null actionItems.");
        Iterator<IActionItem> iterator = actionItems.iterator();
        while (iterator.hasNext()) {
            IActionItem action = iterator.next();
            if (action.isFavorite()) continue;
            iterator.remove();
        }
    }

    public ActionHistoryContent() {
        this.actionRegistry.addListener((EListener)new EListener<EntityEvent<IActionItem>>(){

            public void onEvent(EntityEvent<IActionItem> event) {
                if (event.getType() == EntityEventType.ADDED) {
                    List<IActionItem> actions = ActionHistoryContent.this.getActionsForType(((IActionItem)event.getEntity()).getSystem(), ((IActionItem)event.getEntity()).getActionType());
                    ArrayList<IActionItem> seen = new ArrayList<IActionItem>();
                    Collections.sort(actions, EXECUTION_ORDER_COMPARATOR);
                    ArrayList<IActionItem> tagged = new ArrayList<IActionItem>();
                    int i = 0;
                    while (i < actions.size()) {
                        int indexOfActionInSeen;
                        IActionItem currAction = actions.get(i);
                        boolean isTagged = false;
                        if (i > 25 && !currAction.isFavorite()) {
                            tagged.add(currAction);
                            isTagged = true;
                        }
                        if ((indexOfActionInSeen = seen.indexOf(currAction)) != -1) {
                            IActionItem alreadySeen;
                            if (!isTagged) {
                                tagged.add(currAction);
                            }
                            alreadySeen.setFavorite((alreadySeen = (IActionItem)seen.get(indexOfActionInSeen)).isFavorite() || currAction.isFavorite());
                        } else {
                            seen.add(currAction);
                        }
                        ++i;
                    }
                    for (IActionItem item : tagged) {
                        PDLogger.get(ActionHistoryContent.class).trace((Object)("Removing tagged action: " + String.valueOf(item)));
                        ActionHistoryContent.this.actionRegistry.remove((Object)item);
                    }
                }
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        EclipseUtils.refreshSourceProviderVariable((String)ActionHistorySourceProvider.getVarActionsExist());
                        EclipseUtils.retestEclipseProperty((String)"com.ibm.etools.fm.ui.tree", (String)"canExecuteActionItem");
                        EclipseUtils.retestEclipseProperty((String)"com.ibm.etools.fm.ui.tree", (String)"canModifyActionItem");
                        EclipseUtils.retestEclipseProperty((String)"com.ibm.etools.fm.ui.tree", (String)"favoriteActionItem");
                    }
                });
            }
        });
        RegistryLocator.instance().getHostRegistry().addListener((EListener)new EListener<EntityEvent<IPDHost>>(){

            public void onEvent(EntityEvent<IPDHost> event) {
                if (event.getType() == EntityEventType.REMOVED) {
                    List<IActionItem> actions = ActionHistoryContent.this.getActionsForHost((IPDHost)event.getEntity());
                    for (IActionItem action : actions) {
                        ActionHistoryContent.this.actionRegistry.remove((Object)action);
                    }
                }
            }
        });
    }

    public List<IActionItem> getActionsForHost(IPDHost host) {
        List actions = this.actionRegistry.all();
        Iterator iterator = actions.iterator();
        while (iterator.hasNext()) {
            IActionItem action = (IActionItem)iterator.next();
            if (host.equals(action.getSystem())) continue;
            iterator.remove();
        }
        return actions;
    }

    public Set<ActionType> getActionTypesForHost(IPDHost host) {
        List<IActionItem> actions = this.getActionsForHost(host);
        HashSet<ActionType> actionTypes = new HashSet<ActionType>();
        for (IActionItem action : actions) {
            actionTypes.add(action.getActionType());
        }
        return actionTypes;
    }

    public List<IActionItem> getActionsForType(IPDHost host, ActionType type) {
        List<IActionItem> actions = this.getActionsForHost(host);
        Iterator<IActionItem> iterator = actions.iterator();
        while (iterator.hasNext()) {
            IActionItem action = iterator.next();
            if (type.equals((Object)action.getActionType())) continue;
            iterator.remove();
        }
        return actions;
    }

    public List<IActionItem> getMostRecentlyExecuted() {
        List actions = this.actionRegistry.all();
        Collections.sort(actions, EXECUTION_ORDER_COMPARATOR);
        while (actions.size() > 10) {
            actions.remove(actions.size() - 1);
        }
        return actions;
    }

    public EntityRegistry<IActionItem> getRegistry() {
        return this.actionRegistry;
    }
}

