/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.views.systems.handlers;

import com.ibm.etools.fm.core.model.DataSet;
import com.ibm.etools.fm.core.model.DataSetOrMember;
import com.ibm.etools.fm.core.model.Member;
import com.ibm.etools.fm.ui.views.systems.FMTreeContentHolder;
import com.ibm.etools.fm.ui.wizards.ViewLoadModuleActionItem;
import com.ibm.etools.fm.ui.wizards.ViewLoadModuleModel;
import com.ibm.etools.fm.ui.wizards.ViewLoadModuleWizard;
import com.ibm.pdtools.common.component.jhost.core.model.IHostProvider;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.ui.dialog.PDScrollableWizardDialog;
import com.ibm.pdtools.common.component.ui.views.systems.handlers.PDTreeHandlerUtil;
import com.ibm.pdtools.common.component.ui.views.systems.handlers.SkeletonHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.wizard.IWizard;

public class ViewLoadModule
extends SkeletonHandler {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";

    protected void handle(ExecutionEvent event) throws ExecutionException {
        List selectedItems = PDTreeHandlerUtil.getSelectedDataObjects((ExecutionEvent)event);
        IPDHost system = null;
        DataSet dataSet = null;
        ArrayList<Member> members = new ArrayList<Member>();
        for (Object item : selectedItems) {
            Member member;
            if (system == null && item instanceof IHostProvider) {
                system = ((IHostProvider)item).getSystem();
            }
            if (dataSet == null && item instanceof DataSetOrMember && ((DataSetOrMember)item).getSystem().equals(system)) {
                dataSet = ((DataSetOrMember)item).asDataSet();
            }
            if (!(item instanceof Member) || !(member = (Member)item).asDataSet().equals(dataSet) || members.contains(member)) continue;
            members.add(member);
        }
        ViewLoadModule.showViewLoadModuleWizard(system, dataSet, members);
    }

    public static void showViewLoadModuleWizard(IPDHost system, DataSet dataSet, List<Member> members) {
        Objects.requireNonNull(system, "Must provide a non-null system.");
        if (dataSet != null && !dataSet.getSystem().equals(system)) {
            throw new IllegalArgumentException();
        }
        if (members != null) {
            for (Member member : members) {
                if (!member.getSystem().equals(system)) {
                    throw new IllegalArgumentException();
                }
                if (dataSet == null) {
                    dataSet = member.asDataSet();
                }
                if (member.asDataSet().equals((Object)dataSet)) continue;
                throw new IllegalArgumentException();
            }
        }
        ViewLoadModuleModel model = new ViewLoadModuleModel(system);
        if (dataSet != null) {
            model.dataSet = dataSet.clone();
        }
        if (members != null) {
            for (Member member : members) {
                model.membersList.add(member.clone());
            }
        }
        ViewLoadModuleWizard wizard = new ViewLoadModuleWizard(model);
        final ViewLoadModuleActionItem action = new ViewLoadModuleActionItem(model);
        wizard.getRunnable().addCallback(new Runnable(){

            @Override
            public void run() {
                FMTreeContentHolder.getInstance().getActionHistoryContent().getRegistry().add((Object)action);
            }
        });
        wizard.getRunnable().addCallback(action.getUpdateStateCallback(wizard.getRunnable()));
        PDScrollableWizardDialog.openWizard((IWizard)wizard);
    }
}

