/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.views.systems.handlers;

import com.ibm.etools.fm.core.model.FMHost;
import com.ibm.etools.fm.core.model.db2.Db2Subsystem;
import com.ibm.etools.fm.core.model.db2.Db2SubsystemQuery;
import com.ibm.etools.fm.jhost.core.version.FMFeature;
import com.ibm.etools.fm.jhost.core.version.ServerTooOldException;
import com.ibm.pdtools.common.component.core.util.PDUtils;
import com.ibm.pdtools.common.component.jhost.comms.CommunicationException;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.logging.ThrowableRenderer;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import com.ibm.pdtools.common.component.ui.util.PDDialogs;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.PlatformUI;

public class VersionUtils {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";

    public static boolean loadServerVersion(final IPDHost pdHost, final FMHost fmHost) {
        Objects.requireNonNull(fmHost, "Must provide a non-null fmHost.");
        final AtomicBoolean loaded = new AtomicBoolean(false);
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InterruptedException {
                    try {
                        IHowIsGoing howIsGoing = PDUtils.convertIprogressToIHowIsGoing((IProgressMonitor)monitor);
                        fmHost.loadServerVersion(pdHost, howIsGoing);
                        loaded.set(true);
                    }
                    catch (CommunicationException e) {
                        PDDialogs.openErrorThreadSafe((String)"An exception occured while loading the server version", (String)ThrowableRenderer.renderShortForm((Throwable)e).toString(), (Throwable)e);
                    }
                }
            });
        }
        catch (InvocationTargetException e2) {
            PDDialogs.openErrorThreadSafe((String)"An exception occured while loading the server version", (String)ThrowableRenderer.renderShortForm((Throwable)e2).toString(), (Throwable)e2);
        }
        catch (InterruptedException e2) {
            PDDialogs.openInfoThreadSafe((String)"Loading of server version cancelled.");
        }
        return loaded.get();
    }

    public static boolean isServerNewEnoughForImsEdit(FMHost fmHost, IPDHost pdHost) {
        Objects.requireNonNull(fmHost, "Must provide a non-null fmHost.");
        try {
            if (VersionUtils.loadServerVersion(pdHost, fmHost)) {
                fmHost.ensureSupported(pdHost, FMFeature.IMS_EDIT);
                return true;
            }
        }
        catch (ServerTooOldException stoe) {
            PDDialogs.openErrorThreadSafe((String)stoe.getMessage());
        }
        return false;
    }

    public static boolean isDB2SubsystemConnectable(final IPDHost pdHost, final String ssid) {
        Objects.requireNonNull(ssid, "Must provide a non-null ssid");
        final AtomicBoolean templateInfo = new AtomicBoolean(false);
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InterruptedException {
                    IHowIsGoing howIsGoing;
                    Db2SubsystemQuery query = Db2SubsystemQuery.createForHost((IPDHost)pdHost, (String)ssid);
                    Result result = query.loadSubsystems(howIsGoing = PDUtils.convertIprogressToIHowIsGoing((IProgressMonitor)monitor));
                    if (result.isSuccessfulWithoutWarnings()) {
                        List subsystems = query.getSubsystems();
                        templateInfo.set(subsystems != null && !subsystems.isEmpty() ? ((Db2Subsystem)subsystems.get(0)).getCanConnect() : false);
                    } else {
                        PDDialogs.openErrorThreadSafe((String)"Error loading subsystems.");
                    }
                }
            });
        }
        catch (InvocationTargetException e2) {
            PDDialogs.openErrorThreadSafe((String)"An exception occured while loading the server version", (String)ThrowableRenderer.renderShortForm((Throwable)e2).toString(), (Throwable)e2);
        }
        catch (InterruptedException e2) {
            PDDialogs.openInfoThreadSafe((String)"Loading of server version cancelled.");
        }
        return templateInfo.get();
    }
}

