/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.views.systems.handlers;

import com.ibm.etools.fm.core.model.IRenamable;
import com.ibm.etools.fm.ui.views.systems.FMTreeContentHolder;
import com.ibm.etools.fm.ui.wizards.RenameActionItem;
import com.ibm.etools.fm.ui.wizards.RenameModel;
import com.ibm.etools.fm.ui.wizards.RenameWizard;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.ui.dialog.PDScrollableWizardDialog;
import com.ibm.pdtools.common.component.ui.dialog.SystemLookupDialog;
import com.ibm.pdtools.common.component.ui.views.systems.handlers.PDTreeHandlerUtil;
import com.ibm.pdtools.common.component.ui.views.systems.handlers.SkeletonHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.wizard.IWizard;

public class RenameResource
extends SkeletonHandler {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";

    protected void handle(ExecutionEvent event) throws ExecutionException {
        List selectedItems = PDTreeHandlerUtil.getSelectedDataObjects((ExecutionEvent)event);
        IPDHost system = null;
        ArrayList<IRenamable> itemsToRename = new ArrayList<IRenamable>();
        for (Object selected : selectedItems) {
            if (!(selected instanceof IRenamable)) continue;
            IRenamable selectedRenamable = (IRenamable)selected;
            if (system == null) {
                system = selectedRenamable.getSystem();
            }
            if (!selectedRenamable.getSystem().equals(system)) continue;
            itemsToRename.add(selectedRenamable);
        }
        if (system == null) {
            SystemLookupDialog dialog = new SystemLookupDialog();
            if (dialog.open() != 0) {
                return;
            }
            system = dialog.getSelectedHost();
        }
        RenameResource.showRenameWizard(system, itemsToRename);
    }

    public static void showRenameWizard(IPDHost system, List<IRenamable> itemsToRename) {
        Objects.requireNonNull(system, "Must provide a non-null system");
        Objects.requireNonNull(itemsToRename, "Must provide a non-null itemsToRename");
        if (itemsToRename.isEmpty()) {
            throw new IllegalArgumentException();
        }
        RenameModel model = new RenameModel(system);
        for (IRenamable renamable : itemsToRename) {
            if (!renamable.getSystem().equals(system)) {
                throw new IllegalArgumentException();
            }
            model.addRenameTask(new RenameModel.RenameTask(renamable));
        }
        RenameWizard wizard = new RenameWizard(model);
        final RenameActionItem action = new RenameActionItem(model);
        wizard.getRunnable().addCallback(new Runnable(){

            @Override
            public void run() {
                FMTreeContentHolder.getInstance().getActionHistoryContent().getRegistry().add((Object)action);
            }
        });
        wizard.getRunnable().addCallback(action.getUpdateStateCallback(wizard.getRunnable()));
        PDScrollableWizardDialog.openWizard((IWizard)wizard);
    }
}

