/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.views.systems.handlers;

import com.ibm.etools.fm.core.model.cics.CicsAppl;
import com.ibm.etools.fm.core.model.db2.Db2SubsystemProvider;
import com.ibm.etools.fm.core.model.db2.Db2SubsystemQuery;
import com.ibm.etools.fm.core.model.ims.ImsDatabase;
import com.ibm.etools.fm.core.model.ims.ImsPsb;
import com.ibm.etools.fm.core.model.ims.ImsPsbQuery;
import com.ibm.etools.fm.core.model.ims.ImsSubsystemProvider;
import com.ibm.etools.fm.core.model.ims.ImsSubsystemQuery;
import com.ibm.etools.fm.ui.views.systems.FMTreeContentHolder;
import com.ibm.etools.fm.ui.views.systems.nodes.Db2ObjectRootNode;
import com.ibm.etools.fm.ui.views.systems.nodes.Db2SubsystemBrowseNode;
import com.ibm.etools.fm.ui.views.systems.nodes.ImsRootNode;
import com.ibm.etools.fm.ui.views.systems.nodes.ImsSubsystemBrowseNode;
import com.ibm.etools.fm.ui.wizards.PrintActionItem;
import com.ibm.etools.fm.ui.wizards.PrintModel;
import com.ibm.etools.fm.ui.wizards.PrintWizard;
import com.ibm.etools.fm.ui.wizards.db2.Db2PrintHandler;
import com.ibm.etools.fm.ui.wizards.ims.ImsPrintHandler;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.IZRL;
import com.ibm.pdtools.common.component.ui.dialog.PDScrollableWizardDialog;
import com.ibm.pdtools.common.component.ui.views.systems.handlers.PDTreeHandlerUtil;
import com.ibm.pdtools.common.component.ui.views.systems.handlers.SkeletonHandler;
import com.ibm.pdtools.common.component.ui.views.systems.nodes.SystemsTreeNode;
import java.util.Objects;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.wizard.IWizard;

public class Print
extends SkeletonHandler {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";

    protected void handle(ExecutionEvent event) throws ExecutionException {
        Object selected = PDTreeHandlerUtil.getFirstSelectedDataObject((ExecutionEvent)event);
        IPDHost system = PDTreeHandlerUtil.getSystemFrom((Object)selected);
        if (system == null) {
            return;
        }
        IZRL resource = null;
        if (selected instanceof IZRL) {
            resource = (IZRL)selected;
        }
        Print.showPrintWizard(system, resource);
    }

    public static void doOpen(SystemsTreeNode selected, IPDHost system) {
        if (system != null) {
            Object item;
            Object object = item = selected == null ? null : selected.getDataObject();
            if (item instanceof Db2SubsystemProvider || item instanceof Db2ObjectRootNode || item instanceof Db2SubsystemBrowseNode || item instanceof Db2SubsystemQuery) {
                Db2PrintHandler.doOpen(item, system);
            } else if (item instanceof ImsSubsystemProvider || item instanceof ImsRootNode || item instanceof ImsPsb || item instanceof ImsDatabase || item instanceof ImsSubsystemBrowseNode || item instanceof ImsPsbQuery || item instanceof ImsSubsystemQuery) {
                ImsPrintHandler.doOpen(item, system);
            } else {
                Print.showPrintWizard(system, item instanceof IZRL ? (IZRL)item : null);
            }
        }
    }

    public static void showPrintWizard(IPDHost system, IZRL resource) {
        Objects.requireNonNull(system, "Must specify a non-null system.");
        if (resource != null && !resource.getSystem().equals(system)) {
            throw new IllegalArgumentException();
        }
        PrintModel model = new PrintModel(system);
        if (resource != null) {
            model.setResource(resource.clone());
        }
        if (resource instanceof CicsAppl) {
            model.setResource("");
        }
        PrintWizard wizard = new PrintWizard(model);
        final PrintActionItem action = new PrintActionItem(model);
        wizard.getRunnable().addCallback(new Runnable(){

            @Override
            public void run() {
                FMTreeContentHolder.getInstance().getActionHistoryContent().getRegistry().add((Object)action);
            }
        });
        wizard.getRunnable().addCallback(action.getUpdateStateCallback(wizard.getRunnable()));
        PDScrollableWizardDialog.openWizard((IWizard)wizard);
    }
}

