/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.views.systems.handlers;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.AbstractSessionTemplate;
import com.ibm.etools.fm.core.model.DataSet;
import com.ibm.etools.fm.core.model.DataSetOrMember;
import com.ibm.etools.fm.core.model.FMHost;
import com.ibm.etools.fm.core.model.Member;
import com.ibm.etools.fm.core.model.UssFile;
import com.ibm.etools.fm.core.model.db2.Db2Subsystem;
import com.ibm.etools.fm.core.model.db2.Db2SubsystemProvider;
import com.ibm.etools.fm.core.model.db2.Db2Table;
import com.ibm.etools.fm.core.model.db2.Db2TemplateOptions;
import com.ibm.etools.fm.core.model.db2.SessionTemplate2;
import com.ibm.etools.fm.core.model.ims.ImsDatabase;
import com.ibm.etools.fm.core.model.ims.ImsRegionType;
import com.ibm.etools.fm.core.model.ims.ImsSubsystemConfig;
import com.ibm.etools.fm.core.model.ims.ImsSubsystemProvider;
import com.ibm.etools.fm.core.model.ims.ImsSubsystemQuery;
import com.ibm.etools.fm.core.model.ims.ImsTemplateOptions;
import com.ibm.etools.fm.core.model.ims.ImsTemplateType;
import com.ibm.etools.fm.core.model.ims.SessionTemplate1;
import com.ibm.etools.fm.editor.template.FMTemplateEditorInput;
import com.ibm.etools.fm.editor.template.TemplateEditorUtilities;
import com.ibm.etools.fm.editor.template.dialogs.NewDynamicTemplateDialog;
import com.ibm.etools.fm.editor.template1.FMTemplateEditorInput1;
import com.ibm.etools.fm.editor.template1.SegmentAndLayoutIndex;
import com.ibm.etools.fm.editor.template1.dialogs.ImsTemplateEditorWizard;
import com.ibm.etools.fm.editor.template2.FMTemplateEditorInput2;
import com.ibm.etools.fm.editor.template2.dialogs.Db2TemplateEditorDialog2;
import com.ibm.etools.fm.jhost.core.socket.func.MsgParser;
import com.ibm.etools.fm.model.template.CopybooksType;
import com.ibm.etools.fm.model.template.TemplateFactory;
import com.ibm.etools.fm.model.template.TemplateType;
import com.ibm.etools.fm.model.template.util.TemplateSerializeUtils;
import com.ibm.etools.fm.ui.FMUIPlugin;
import com.ibm.etools.fm.ui.dialog.lookup.ImsDatabaseLookupDialog;
import com.ibm.etools.fm.ui.dialog.lookup.ImsSubsystemLookupDialog;
import com.ibm.etools.fm.ui.history.IActionItem;
import com.ibm.etools.fm.ui.history.action.OpenAsTemplate1ActionItem;
import com.ibm.etools.fm.ui.history.action.OpenAsTemplate2ActionItem;
import com.ibm.etools.fm.ui.history.action.OpenAsTemplateActionItem;
import com.ibm.etools.fm.ui.util.EditorManagement;
import com.ibm.etools.fm.ui.views.systems.FMTreeContentHolder;
import com.ibm.etools.fm.ui.views.systems.handlers.VersionUtils;
import com.ibm.etools.fm.ui.views.systems.nodes.Db2ObjectRootNode;
import com.ibm.etools.fm.ui.views.systems.nodes.Db2SubsystemBrowseNode;
import com.ibm.etools.fm.ui.views.systems.nodes.ImsRootNode;
import com.ibm.etools.fm.ui.views.systems.nodes.ImsSubsystemBrowseNode;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.model.ISessionEdit;
import com.ibm.pdtools.common.component.core.util.PDFileSystemUtil;
import com.ibm.pdtools.common.component.core.util.PDUtils;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.IZRL;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import com.ibm.pdtools.common.component.ui.dialog.PDDialogWithText;
import com.ibm.pdtools.common.component.ui.dialog.PDScrollableWizardDialog;
import com.ibm.pdtools.common.component.ui.util.PDDialogs;
import com.ibm.pdtools.common.component.ui.util.PDEditorManagement;
import com.ibm.pdtools.common.component.ui.views.systems.PDSystemsTreeUpdater;
import com.ibm.pdtools.common.component.ui.views.systems.handlers.PDTreeHandlerUtil;
import com.ibm.pdtools.common.component.ui.views.systems.handlers.SkeletonHandler;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.List;
import java.util.Objects;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.xml.sax.SAXException;

public class OpenTemplate
extends SkeletonHandler {
    private static final PDLogger logger = PDLogger.get(OpenTemplate.class);
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    public static final String COMMAND_ID = "com.ibm.etools.fm.ui.model.commands.openTemplate";

    protected void handle(ExecutionEvent event) throws ExecutionException {
        for (Object item : PDTreeHandlerUtil.getSelectedDataObjects((ExecutionEvent)event)) {
            ImsSubsystemConfig config;
            IPDHost host = PDTreeHandlerUtil.getSystemFrom(item);
            if (host == null) continue;
            if (item instanceof Member) {
                OpenTemplate.openTemplate((Member)item);
                continue;
            }
            if (item instanceof DataSet) {
                OpenTemplate.openTemplateEditor((IZRL)((DataSet)item), null);
                continue;
            }
            if (item instanceof Db2SubsystemProvider) {
                OpenTemplate.openTemplateEditor2(new Db2TemplateOptions((Db2SubsystemProvider)item, null));
                continue;
            }
            if (PDTreeHandlerUtil.getFirstSelectedTreeNode((ExecutionEvent)event) instanceof Db2ObjectRootNode || PDTreeHandlerUtil.getFirstSelectedTreeNode((ExecutionEvent)event) instanceof Db2SubsystemBrowseNode) {
                Db2TemplateOptions opts = new Db2TemplateOptions();
                opts.setHost(host);
                OpenTemplate.openTemplateEditor2(opts);
                continue;
            }
            if (item instanceof UssFile) {
                OpenTemplate.openTemplateEditor((IZRL)((UssFile)item), null);
                continue;
            }
            if (item instanceof ImsSubsystemProvider) {
                OpenTemplate.openTemplateEditor1(new ImsTemplateOptions((ImsSubsystemProvider)item, null), null, false);
                continue;
            }
            if (!(item instanceof ImsRootNode) && !(item instanceof ImsSubsystemBrowseNode) && !(item instanceof ImsSubsystemQuery) || !VersionUtils.isServerNewEnoughForImsEdit((FMHost)FMHost.getSystem((IPDHost)host), host) || (config = ImsSubsystemLookupDialog.promptForValidConfig(host, null)) == null) continue;
            OpenTemplate.openTemplateEditor1(new ImsTemplateOptions((ImsSubsystemProvider)config.getSubsystem(), null), null, false);
        }
    }

    public static void openTemplate(Member member) {
        Objects.requireNonNull(member, "Must provide a non-null member");
        Member.TemplateInfo templateInfo = member.getTemplateInfo();
        if (templateInfo != null) {
            if (Member.TemplateInfo.DsfmTemplateType.IMS.equals((Object)templateInfo.getType())) {
                ImsSubsystemConfig config;
                if (VersionUtils.isServerNewEnoughForImsEdit((FMHost)FMHost.getSystem((IPDHost)member.getSystem()), member.getSystem()) && (config = ImsSubsystemLookupDialog.promptForValidConfig(member.getSystem(), null)) != null) {
                    ImsDatabase aDatabase = new ImsDatabase(config.getSubsystem(), member.getName());
                    ImsTemplateOptions options = new ImsTemplateOptions((ImsSubsystemProvider)aDatabase, (DataSetOrMember)member);
                    OpenTemplate.openTemplateEditor1(options, null, false);
                }
            } else if (Member.TemplateInfo.DsfmTemplateType.VIEW.equals((Object)templateInfo.getType())) {
                if (VersionUtils.isServerNewEnoughForImsEdit((FMHost)FMHost.getSystem((IPDHost)member.getSystem()), member.getSystem())) {
                    ImsSubsystemConfig config = ImsSubsystemLookupDialog.promptForValidConfig(member.getSystem(), null);
                    if (config != null) {
                        ImsDatabase aDatabase = ImsDatabaseLookupDialog.promptForValidConfig(member.getSystem(), config, null, "", ImsRegionType.BMP, null, config.isDir() || config.isStaticOnly(ImsRegionType.BMP) ? "XTPED" : null);
                        if (aDatabase != null) {
                            ImsTemplateOptions options = new ImsTemplateOptions((ImsSubsystemProvider)aDatabase, (DataSetOrMember)member);
                            options.setType(ImsTemplateType.VIEW);
                            OpenTemplate.openTemplateEditor1(options, null, false);
                        }
                    } else {
                        logger.trace((Object)"User cancelled selecting an IMS subsystem");
                    }
                }
            } else if (Member.TemplateInfo.DsfmTemplateType.DB2.equals((Object)templateInfo.getType())) {
                Db2Subsystem db2subsys = new Db2Subsystem(member.getSystem(), templateInfo.getDb2Ssid());
                Db2Table db2Table = new Db2Table(db2subsys, templateInfo.getDb2Object(), templateInfo.getDb2Owner());
                OpenTemplate.openTemplateEditor2(new Db2TemplateOptions((Db2SubsystemProvider)db2Table, (DataSetOrMember)member));
            } else {
                OpenTemplate.openTemplateEditor((IZRL)member, null);
            }
        } else {
            OpenTemplate.openTemplateEditor((IZRL)member, null);
        }
    }

    public static void openTemplateEditor(final IZRL aTemplate, final IActionItem actionItem) {
        Objects.requireNonNull(aTemplate, "Must provide a non-null aTemplate");
        if (FMUIPlugin.getDefault().templateEditSessionExist(aTemplate)) {
            PDDialogs.openInfoThreadSafe((String)MessageFormat.format(Messages.OpenAsTemplate_DUP_SESSION, aTemplate.getFormattedName()));
            return;
        }
        String taskName = MessageFormat.format(Messages.OpenAsTemplate_OPEN_TEMPLATE, aTemplate.getFormattedName());
        FMUIPlugin.getDefault().addNewTemplateEditSession(aTemplate);
        final AbstractSessionTemplate session = AbstractSessionTemplate.createTemplateEditSession((IZRL)aTemplate);
        final Result overallResult = new Result((Object)new StringBuffer());
        final Job job = new Job(taskName){

            public IStatus run(IProgressMonitor monitor) {
                Result result;
                monitor.beginTask(MessageFormat.format(Messages.OpenAsTemplate_TASK_NAME, aTemplate.getFormattedName()), 3);
                IHowIsGoing howIsGoing = PDUtils.convertIprogressToIHowIsGoing((IProgressMonitor)monitor);
                monitor.worked(1);
                try {
                    result = session.start(howIsGoing);
                }
                catch (InterruptedException e) {
                    logger.trace((Object)"cancelled starting template editing session");
                    return new Status(8, "com.ibm.etools.fm.core", Messages._JOB_WAS_CANCELLED);
                }
                overallResult.copy(result);
                if (result.getRC() >= 8 || session.getFromCacheFile() == null) {
                    FMUIPlugin.getDefault().removeTemplateEditSession(aTemplate);
                    return Status.OK_STATUS;
                }
                monitor.worked(1);
                FMTemplateEditorInput fmiInput = new FMTemplateEditorInput(session.getFromCacheFile(), aTemplate, (ISessionEdit)session, true, null, -1);
                EditorManagement.openTemplateEditorFromWorkerThread(session.getFromCacheFile(), fmiInput, monitor, true);
                monitor.worked(1);
                monitor.done();
                this.setName("");
                return Status.OK_STATUS;
            }
        };
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                job.setName("");
                if (!overallResult.isSuccessfulWithoutWarnings()) {
                    FMUIPlugin.getDefault().removeTemplateEditSession(aTemplate);
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            String errMsg = MessageFormat.format(Messages.OpenAsTemplate_START_ERR_MSG, aTemplate.getFormattedName());
                            String overallResultMsg = overallResult.getMessagesCombined().toString();
                            if (overallResultMsg.startsWith("FMNBE046")) {
                                PDDialogWithText.ITextDialogRunnable action = OpenTemplate.getShowCompilerListingAction(session, actionItem);
                                PDDialogs.openErrorThreadSafe((String)Messages.OpenAsTemplate_START_ERR_TITLE, (String)errMsg, (String)overallResultMsg, (String[])new String[]{Messages.OpenAsTemplate_GET_LIST}, (PDDialogWithText.ITextDialogRunnable[])new PDDialogWithText.ITextDialogRunnable[]{action});
                            } else {
                                PDDialogs.openErrorThreadSafe((String)Messages.OpenAsTemplate_START_ERR_TITLE, (String)errMsg, (String)overallResultMsg);
                            }
                            if (actionItem != null) {
                                actionItem.setErrorToolTipText(errMsg);
                            }
                            session.unlock();
                        }
                    });
                } else if (actionItem == null) {
                    FMTreeContentHolder.getInstance().getActionHistoryContent().getRegistry().add((Object)new OpenAsTemplateActionItem(aTemplate));
                } else {
                    actionItem.setErrorToolTipText(null);
                }
            }
        });
        job.schedule();
    }

    private static PDDialogWithText.ITextDialogRunnable getShowCompilerListingAction(final AbstractSessionTemplate session, final IActionItem actionItem) {
        return new PDDialogWithText.ITextDialogRunnable(){

            public void run(PDDialogWithText dialog) {
                block2: {
                    try {
                        PlatformUI.getWorkbench().getProgressService().run(true, false, new IRunnableWithProgress(){

                            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                                block5: {
                                    monitor.setTaskName(Messages.OpenAsTemplate_GET_LIST_OPS_NAME);
                                    IHowIsGoing howIsGoing = PDUtils.convertIprogressToIHowIsGoing((IProgressMonitor)monitor);
                                    IFile tmpFile = null;
                                    try {
                                        tmpFile = PDFileSystemUtil.getTempFile((String)"FM");
                                        Result listResult = session.getCompilerListing(howIsGoing, tmpFile);
                                        if (listResult.getRC() == 0) {
                                            PDEditorManagement.openEditorFromWorkerThread((IFile)tmpFile, (IHowIsGoing)howIsGoing);
                                        } else {
                                            PDDialogs.openErrorThreadSafe((String)Messages.OpenAsTemplate_GET_LIST_ERR, (String)listResult.getMessagesCombined().toString());
                                            if (actionItem != null) {
                                                actionItem.setErrorToolTipText(listResult.getMessagesCombined().toString());
                                            }
                                        }
                                    }
                                    catch (CoreException e) {
                                        String errMsg = Messages.OpenAsTemplate_GET_LIST_ERR;
                                        PDDialogs.openErrorThreadSafe((String)errMsg, (Throwable)e);
                                        if (actionItem == null) break block5;
                                        actionItem.setErrorToolTipText(errMsg);
                                    }
                                }
                            }
                        });
                    }
                    catch (Exception e) {
                        String errMsg = Messages.OpenAsTemplate_GET_LIST_ERR;
                        PDDialogs.openErrorThreadSafe((String)errMsg, (Throwable)e);
                        if (actionItem == null) break block2;
                        actionItem.setErrorToolTipText(errMsg);
                    }
                }
            }
        };
    }

    private static boolean createImsTemplate(final ImsTemplateOptions opts) {
        if (FMUIPlugin.getDefault().templateEditSessionExist(opts.getTemplate())) {
            PDDialogs.openInfoThreadSafe((String)MessageFormat.format(Messages.CreateTemplateWizard_DUP_EDIT, opts.getTemplate()));
            return false;
        }
        final TemplateType aNewTemplate = OpenTemplate.createNewImsTemplate(opts);
        final SessionTemplate1 session = new SessionTemplate1(opts);
        final Result overallResult = new Result((Object)new StringBuffer());
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask(MessageFormat.format(Messages.CreateTemplateDynamicPage_CHECK_EXIST, opts.getTemplate().getFormattedName()), 3);
                    IHowIsGoing howIsGoing = PDUtils.convertIprogressToIHowIsGoing((IProgressMonitor)monitor);
                    try {
                        Result result = session.startWithLocalContentsForNewTemplate(howIsGoing, TemplateSerializeUtils.save((TemplateType)aNewTemplate, (IZRL)opts.getTemplate()));
                        if (result.getRC() >= 8 || session.getFromCacheFile() == null) {
                            String errMsg = MessageFormat.format(Messages.OpenAsTemplate_START_ERR_MSG, opts.getTemplate().getFormattedName());
                            overallResult.addSubResult(result);
                            overallResult.add(errMsg);
                            monitor.done();
                            return;
                        }
                        monitor.worked(1);
                        if (opts.isCreateNew() && opts.getType() == ImsTemplateType.VIEW) {
                            StringBuffer newTemplateContents = session.updateTemplate(TemplateSerializeUtils.save((TemplateType)aNewTemplate, (IZRL)opts.getTemplate()), howIsGoing, overallResult, true, false);
                            session.getFromCacheFile().setContents((InputStream)new ByteArrayInputStream(newTemplateContents.toString().getBytes(StandardCharsets.UTF_8)), true, false, monitor);
                            Result saveReuslt = session.save(howIsGoing);
                            if (!saveReuslt.isSuccessfulWithoutWarnings()) {
                                String errMsg = MessageFormat.format(Messages.OpenTemplate_0, opts.getTemplate().getFormattedName());
                                overallResult.addSubResult(saveReuslt);
                                overallResult.add(errMsg);
                                monitor.done();
                                return;
                            }
                        }
                        PDSystemsTreeUpdater.refreshAllRelatedTo((Object)opts.getTemplate());
                        FMTemplateEditorInput1 fmiInput = new FMTemplateEditorInput1(session.getFromCacheFile(), opts.getTemplate(), session, true, null, new SegmentAndLayoutIndex());
                        EditorManagement.openTemplateEditorFromWorkerThread(session.getFromCacheFile(), fmiInput, monitor, true);
                        monitor.worked(1);
                        FMUIPlugin.getDefault().addNewTemplateEditSession(opts.getTemplate());
                        monitor.done();
                    }
                    catch (InterruptedException ie) {
                        throw ie;
                    }
                    catch (Exception e) {
                        String errString = MessageFormat.format(Messages.CreateTemplateWizard_CREATE_EXC, opts.getTemplate().getFormattedName());
                        overallResult.add((Throwable)e);
                        overallResult.add(errString);
                        logger.error((Object)errString, (Throwable)e);
                    }
                }
            });
        }
        catch (InvocationTargetException e1) {
            PDDialogs.openErrorThreadSafe((String)MessageFormat.format(Messages.CreateTemplateWizard_CREATE_EXC, opts.getTemplate()), (Throwable)e1);
            TemplateEditorUtilities.end((AbstractSessionTemplate)session);
            return false;
        }
        catch (InterruptedException e1) {
            TemplateEditorUtilities.end((AbstractSessionTemplate)session);
            return false;
        }
        if (!overallResult.isSuccessfulWithoutWarnings()) {
            NewDynamicTemplateDialog.displayCreateTemplateErrCompilerListing((AbstractSessionTemplate)session, opts.getTemplate(), (Result<StringBuffer>)overallResult, true);
            return false;
        }
        return true;
    }

    private static TemplateType createNewImsTemplate(ImsTemplateOptions opts) {
        TemplateType aNewTemplate = TemplateFactory.eINSTANCE.createTemplateType();
        aNewTemplate.setDbd(opts.getDatabase().getName());
        ImsSubsystemConfig aConfig = opts.getSubsystem().getCanonicalConfig();
        List dbdLibs = aConfig.getDbdLibs();
        for (DataSet aDbdLib : dbdLibs) {
            aNewTemplate.getDbdlib().add((Object)aDbdLib.getName());
        }
        if (opts.getType() == ImsTemplateType.TEMPLATE) {
            aNewTemplate.setType("IMS");
            CopybooksType copybooks = TemplateFactory.eINSTANCE.createCopybooksType();
            aNewTemplate.setCopybooks(copybooks);
        } else if (opts.getType() == ImsTemplateType.VIEW) {
            aNewTemplate.setType("VIEW");
            List imsTmpLibs = aConfig.getTemplateLibs();
            for (DataSet aTmpLib : imsTmpLibs) {
                aNewTemplate.getImstp().add((Object)aTmpLib.getName());
            }
        } else {
            aNewTemplate.setType("CRITERIA");
        }
        return aNewTemplate;
    }

    public static void openTemplateEditor1(ImsTemplateOptions initialOptions, final OpenAsTemplate1ActionItem actionItem, boolean suppressDialog) {
        ImsTemplateOptions finalOptions;
        Objects.requireNonNull(initialOptions, "Must provide a non-null initialOptions");
        if (!VersionUtils.isServerNewEnoughForImsEdit((FMHost)FMHost.getSystem((IPDHost)initialOptions.getHost()), initialOptions.getHost())) {
            return;
        }
        ImsTemplateEditorWizard dialog = null;
        if (suppressDialog) {
            finalOptions = initialOptions;
        } else {
            dialog = new ImsTemplateEditorWizard(new ImsTemplateOptions(initialOptions));
            if (PDScrollableWizardDialog.openWizard((IWizard)dialog) != 0) {
                return;
            }
            finalOptions = dialog.getOptions();
        }
        if (finalOptions.isCreateNew()) {
            OpenTemplate.createImsTemplate(finalOptions);
            return;
        }
        if (FMUIPlugin.getDefault().templateEditSessionExist(finalOptions.getTemplate())) {
            PDDialogs.openInfoThreadSafe((String)MessageFormat.format(Messages.OpenAsTemplate_DUP_SESSION, finalOptions.getTemplate().getFormattedName()));
            return;
        }
        FMUIPlugin.getDefault().addNewTemplateEditSession(finalOptions.getTemplate());
        FMHost.getSystem((IPDHost)finalOptions.getSystem()).addTemplateAssociation(finalOptions.getTemplate(), finalOptions.getTemplate());
        final Result overallResult = new Result((Object)new StringBuffer());
        Job job = OpenTemplate.getOpenTemplateEditor1Job(finalOptions, (Result<StringBuffer>)overallResult);
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (overallResult.isSuccessfulWithoutWarnings()) {
                    if (actionItem == null) {
                        FMTreeContentHolder.getInstance().getActionHistoryContent().getRegistry().add((Object)new OpenAsTemplate1ActionItem(finalOptions));
                    } else {
                        actionItem.setErrorToolTipText(null);
                    }
                } else {
                    String errMsg = MessageFormat.format(Messages.OpenAsTemplate_START_ERR_MSG_IMS, finalOptions.getTemplate().getFormattedName(), finalOptions.getDatabase().getName());
                    String msg = overallResult.getMessagesCombined().toString();
                    if (msg.trim().isEmpty()) {
                        MsgParser msgParser = new MsgParser();
                        try {
                            msgParser.parse(overallResult.dumpOutputAndMessages(true));
                            msg = msgParser.getMessages();
                        }
                        catch (IOException | ParserConfigurationException | SAXException e) {
                            msg = overallResult.dumpOutputAndMessages(true);
                        }
                        msg = MessageFormat.format("{0}", msg);
                    }
                    PDDialogs.openErrorThreadSafe((String)errMsg, (String)msg);
                    if (actionItem != null) {
                        actionItem.setErrorToolTipText(overallResult.dumpOutputAndMessages(true));
                    } else {
                        OpenAsTemplate1ActionItem newItem = new OpenAsTemplate1ActionItem(finalOptions);
                        newItem.setErrorToolTipText(overallResult.dumpOutputAndMessages(true));
                        FMTreeContentHolder.getInstance().getActionHistoryContent().getRegistry().add((Object)newItem);
                    }
                }
            }
        });
        job.schedule();
    }

    private static Job getOpenTemplateEditor1Job(final ImsTemplateOptions options, final Result<StringBuffer> overallResult) {
        return new Job(MessageFormat.format(Messages.OpenAsTemplate_OPEN_TEMPLATE, options.getTemplate().getFormattedName())){

            public IStatus run(IProgressMonitor monitor) {
                Result result;
                monitor.beginTask(MessageFormat.format(Messages.OpenAsTemplate_TASK_NAME, options.getTemplate().getFormattedName()), 3);
                IHowIsGoing howIsGoing = PDUtils.convertIprogressToIHowIsGoing((IProgressMonitor)monitor);
                monitor.worked(1);
                SessionTemplate1 session = new SessionTemplate1(options);
                try {
                    result = session.start(howIsGoing);
                }
                catch (InterruptedException e) {
                    FMUIPlugin.getDefault().removeTemplateEditSession(options.getTemplate());
                    session.end(howIsGoing);
                    logger.trace((Object)"cancelled starting template editing session");
                    return new Status(8, "com.ibm.etools.fm.core", Messages._JOB_WAS_CANCELLED);
                }
                overallResult.copy(result);
                if (result.getRC() >= 8 || session.getFromCacheFile() == null) {
                    FMUIPlugin.getDefault().removeTemplateEditSession(options.getTemplate());
                    session.end(howIsGoing);
                    return Status.OK_STATUS;
                }
                monitor.worked(1);
                FMTemplateEditorInput1 fmiInput = new FMTemplateEditorInput1(session.getFromCacheFile(), options.getTemplate(), session, true, null, new SegmentAndLayoutIndex());
                EditorManagement.openTemplateEditorFromWorkerThread(session.getFromCacheFile(), fmiInput, monitor, true);
                monitor.worked(1);
                monitor.done();
                this.setName("");
                return Status.OK_STATUS;
            }
        };
    }

    public static void openTemplateEditor2(Db2TemplateOptions opts) {
        Objects.requireNonNull(opts, "Must specify a non-null opts.");
        OpenTemplate.openTemplateEditor2(opts, null, false);
    }

    public static void openTemplateEditor2(Db2TemplateOptions initialOptions, final OpenAsTemplate2ActionItem actionItem, boolean suppressDialog) {
        Db2TemplateOptions finalOptions;
        Objects.requireNonNull(initialOptions, "Must specify a non-null initialOptions.");
        Db2TemplateEditorDialog2 dialog = null;
        if (suppressDialog) {
            finalOptions = initialOptions;
        } else {
            dialog = new Db2TemplateEditorDialog2(initialOptions);
            if (dialog.open() != 0) {
                return;
            }
            finalOptions = dialog.getOptions();
        }
        if (FMUIPlugin.getDefault().templateEditSessionExist(finalOptions.getTemplate())) {
            PDDialogs.openInfoThreadSafe((String)MessageFormat.format(Messages.OpenAsTemplate_DUP_SESSION, finalOptions.getTemplate().getFormattedName()));
            return;
        }
        if (!VersionUtils.isDB2SubsystemConnectable(finalOptions.getSystem(), finalOptions.getSubsystem().getName())) {
            PDDialogs.openErrorThreadSafe((String)MessageFormat.format("Subsystem {0} is not connectable.", initialOptions.getSubsystem().getName()));
            return;
        }
        FMUIPlugin.getDefault().addNewTemplateEditSession(finalOptions.getTemplate());
        FMHost.getSystem((IPDHost)finalOptions.getSystem()).addTemplateAssociation((IZRL)finalOptions.getTable(), finalOptions.getTemplate());
        final Result overallResult = new Result((Object)new StringBuffer());
        Job job = OpenTemplate.getOpenTemplateEditor2Job(finalOptions, (Result<StringBuffer>)overallResult);
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (overallResult.isSuccessfulWithoutWarnings()) {
                    if (actionItem == null) {
                        FMTreeContentHolder.getInstance().getActionHistoryContent().getRegistry().add((Object)new OpenAsTemplate2ActionItem(finalOptions));
                    } else {
                        actionItem.setErrorToolTipText(null);
                    }
                } else {
                    String errMsg = MessageFormat.format(Messages.OpenAsTemplate_START_ERR_MSG_DB2, finalOptions.getTemplate().getFormattedName(), finalOptions.getTable().getFormattedName());
                    PDDialogs.openErrorThreadSafe((String)errMsg, (String)overallResult.getMessagesCombined().toString());
                    if (actionItem != null) {
                        actionItem.setErrorToolTipText(overallResult.dumpOutputAndMessages(true));
                    } else {
                        OpenAsTemplate2ActionItem newItem = new OpenAsTemplate2ActionItem(finalOptions);
                        newItem.setErrorToolTipText(overallResult.dumpOutputAndMessages(true));
                        FMTreeContentHolder.getInstance().getActionHistoryContent().getRegistry().add((Object)newItem);
                    }
                }
            }
        });
        job.schedule();
    }

    private static Job getOpenTemplateEditor2Job(final Db2TemplateOptions options, final Result<StringBuffer> overallResult) {
        return new Job(MessageFormat.format(Messages.OpenAsTemplate_OPEN_TEMPLATE, options.getTemplate().getFormattedName())){

            public IStatus run(IProgressMonitor monitor) {
                Result result;
                monitor.beginTask(MessageFormat.format(Messages.OpenAsTemplate_TASK_NAME, options.getTemplate().getFormattedName()), 3);
                IHowIsGoing howIsGoing = PDUtils.convertIprogressToIHowIsGoing((IProgressMonitor)monitor);
                monitor.worked(1);
                SessionTemplate2 session = new SessionTemplate2(options);
                try {
                    result = session.start(howIsGoing);
                }
                catch (InterruptedException e) {
                    logger.trace((Object)"cancelled starting template editing session");
                    return new Status(8, "com.ibm.etools.fm.core", Messages._JOB_WAS_CANCELLED);
                }
                overallResult.copy(result);
                if (result.getRC() >= 8 || session.getFromCacheFile() == null) {
                    FMUIPlugin.getDefault().removeTemplateEditSession(options.getTemplate());
                    return Status.OK_STATUS;
                }
                if (options.isGenRep()) {
                    PDSystemsTreeUpdater.refreshAllRelatedTo((Object)options.getTemplate());
                }
                monitor.worked(1);
                FMTemplateEditorInput2 fmiInput = new FMTemplateEditorInput2(session.getFromCacheFile(), options.getTemplate(), session, true, null, -1);
                EditorManagement.openTemplateEditorFromWorkerThread(session.getFromCacheFile(), fmiInput, monitor, true);
                monitor.worked(1);
                monitor.done();
                this.setName("");
                return Status.OK_STATUS;
            }
        };
    }
}

