/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.views.systems.handlers;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.ZRLs;
import com.ibm.etools.fm.ui.views.systems.handlers.OpenFormatted;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.jhost.comms.HostType;
import com.ibm.pdtools.common.component.jhost.core.model.FakeZRL;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.IZRL;
import com.ibm.pdtools.common.component.jhost.core.model.PDHostJhost;
import com.ibm.pdtools.common.component.jhost.registery.RegistryLocator;
import com.ibm.pdtools.common.component.ui.dialog.SystemLookupDialog;
import com.ibm.pdtools.common.component.ui.util.PDDialogs;
import com.ibm.pdtools.common.component.ui.util.PDPlatformUIUtils;
import com.ibm.pdtools.common.component.ui.views.systems.PDTreeContentHolder;
import com.ibm.pdtools.common.component.ui.views.systems.handlers.AddSystem;
import com.ibm.pdtools.common.component.ui.views.systems.handlers.SkeletonHandler;
import java.text.MessageFormat;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.handlers.HandlerUtil;

public class OpenFormattedSelection
extends SkeletonHandler {
    protected void handle(ExecutionEvent event) throws ExecutionException {
        String selectedText = null;
        ISelection sel = HandlerUtil.getCurrentSelectionChecked((ExecutionEvent)event);
        if (sel instanceof ITextSelection) {
            selectedText = ((ITextSelection)sel).getText();
        } else if (sel instanceof ITreeSelection) {
            ITreeSelection ts = (ITreeSelection)sel;
            Object firstElement = ts.getPaths()[0].getLastSegment();
            selectedText = firstElement.toString();
        } else {
            selectedText = PDPlatformUIUtils.editor.text.getCurrentTextSelectionFromActiveEditor();
        }
        if (selectedText != null) {
            selectedText = selectedText.trim();
        }
        PDHostJhost host = new PDHostJhost();
        host.setHostType(HostType.ZOS);
        host.setCodePage("cp037");
        if (selectedText == null || selectedText.isEmpty()) {
            PDDialogs.openInfoThreadSafe((String)Messages.OpenFormattedSelection_EmptySelectionTryAgain);
        } else {
            PDLogger.get(((Object)((Object)this)).getClass()).info((Object)MessageFormat.format("Attempting to open ''{0}'' in Formatted Editor.", selectedText));
            IPDHost aHost = null;
            PDTreeContentHolder.addNewConnectionsDefined((boolean)false);
            if (RegistryLocator.instance().getHostRegistry().size() == 0) {
                AddSystem.addNewSystem();
                if (RegistryLocator.instance().getHostRegistry().size() == 0) {
                    return;
                }
                aHost = (IPDHost)RegistryLocator.instance().getHostRegistry().all().get(0);
            } else {
                aHost = OpenFormattedSelection.parseHostFromEditorInputFileName();
                if (aHost == null) {
                    aHost = OpenFormattedSelection.askForSystem();
                }
            }
            if (aHost != null) {
                try {
                    IZRL zrl = ZRLs.parseZRL((IPDHost)aHost, (String)selectedText);
                    if (zrl != null) {
                        OpenFormatted.showFormattedEditorDialog(aHost, zrl);
                    } else {
                        OpenFormattedSelection.reportBadResourceName(selectedText);
                    }
                }
                catch (IllegalArgumentException e) {
                    FakeZRL zrl = new FakeZRL(aHost, selectedText);
                    OpenFormatted.showFormattedEditorDialog(aHost, (IZRL)zrl);
                }
            }
        }
    }

    private static void reportBadResourceName(String selectedText) {
        PDDialogs.openWarningThreadSafe((String)Messages.OpenFormattedSelection_Warning, (String)MessageFormat.format(Messages.OpenFormattedSelection_nonParseableSelection, selectedText));
    }

    private static IPDHost parseHostFromEditorInputFileName() {
        IPath reportPath;
        IEditorInput input = PDPlatformUIUtils.editor.getInputFromActiveEditor();
        if (input instanceof IFileEditorInput && (reportPath = ((IFileEditorInput)input).getFile().getProjectRelativePath()) != null) {
            String hostName = reportPath.segment(0);
            if (reportPath.segment(1).trim().matches("\\d+")) {
                int portNo = Integer.parseInt(reportPath.segment(1));
                return PDHostJhost.findPDHostIgnoreHostNameCase((String)hostName, (int)portNo);
            }
        }
        return null;
    }

    private static IPDHost askForSystem() {
        SystemLookupDialog systemLookupDialog;
        int rc;
        if (PDDialogs.openConfirmThreadSafe((String)Messages.OpenFormattedSelection_systemSelection, (String)Messages.OpenFormattedSelection_ChooseAHostQuestion) && (rc = (systemLookupDialog = new SystemLookupDialog()).open()) == 0) {
            return systemLookupDialog.getSelectedHost();
        }
        return null;
    }
}

