/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.views.systems.handlers;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.BaseEditorOptions;
import com.ibm.etools.fm.core.model.DataSet;
import com.ibm.etools.fm.core.model.DataSetOrMember;
import com.ibm.etools.fm.core.model.DummyDataSet;
import com.ibm.etools.fm.core.model.DummyMember;
import com.ibm.etools.fm.core.model.FMHost;
import com.ibm.etools.fm.core.model.MessageQueue;
import com.ibm.etools.fm.core.model.UssFile;
import com.ibm.etools.fm.core.model.data.DataSetProperties;
import com.ibm.etools.fm.core.model.db2.Db2Database;
import com.ibm.etools.fm.core.model.db2.Db2EditOptions;
import com.ibm.etools.fm.core.model.db2.Db2Subsystem;
import com.ibm.etools.fm.core.model.db2.Db2SubsystemProvider;
import com.ibm.etools.fm.core.model.db2.Db2Table;
import com.ibm.etools.fm.core.model.ims.ImsAccessMode;
import com.ibm.etools.fm.core.model.ims.ImsDatabase;
import com.ibm.etools.fm.core.model.ims.ImsEditorOptions;
import com.ibm.etools.fm.core.model.ims.ImsPsb;
import com.ibm.etools.fm.core.model.ims.ImsPsbQuery;
import com.ibm.etools.fm.core.model.ims.ImsRegionType;
import com.ibm.etools.fm.core.model.ims.ImsSubsystem;
import com.ibm.etools.fm.core.model.ims.ImsSubsystemConfig;
import com.ibm.etools.fm.core.model.ims.ImsSubsystemProvider;
import com.ibm.etools.fm.editor.formatted.FMEditSessionProperties;
import com.ibm.etools.fm.editor.formatted.OpenFormattedEditorJob;
import com.ibm.etools.fm.editor.formatted.dialogs.EditorOptionDialog;
import com.ibm.etools.fm.editor.formatted1.dialogs.ImsEditorOptionsDialog;
import com.ibm.etools.fm.editor.formatted2.dialogs.Db2EditorDialog;
import com.ibm.etools.fm.ui.FMUIPlugin;
import com.ibm.etools.fm.ui.dialog.lookup.ImsSubsystemLookupDialog;
import com.ibm.etools.fm.ui.history.action.OpenAsFormattedEditor1ActionItem;
import com.ibm.etools.fm.ui.history.action.OpenAsFormattedEditor2ActionItem;
import com.ibm.etools.fm.ui.history.action.OpenAsFormattedEditorActionItem;
import com.ibm.etools.fm.ui.views.systems.FMTreeContentHolder;
import com.ibm.etools.fm.ui.views.systems.handlers.VersionUtils;
import com.ibm.etools.fm.ui.views.systems.nodes.Db2ObjectRootNode;
import com.ibm.etools.fm.ui.views.systems.nodes.Db2SubsystemBrowseNode;
import com.ibm.etools.fm.ui.views.systems.nodes.Db2SubsystemNode;
import com.ibm.etools.fm.ui.views.systems.nodes.ImsRootNode;
import com.ibm.etools.fm.ui.views.systems.nodes.ImsSubsystemBrowseNode;
import com.ibm.pdtools.common.component.core.comms.ConnectionUtilities;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.model.BaseStartPosType;
import com.ibm.pdtools.common.component.core.util.PDUtils;
import com.ibm.pdtools.common.component.jhost.comms.CommunicationException;
import com.ibm.pdtools.common.component.jhost.comms.HostDetails;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.IZRL;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import com.ibm.pdtools.common.component.ui.util.PDDialogs;
import com.ibm.pdtools.common.component.ui.views.systems.handlers.PDEventNode;
import com.ibm.pdtools.common.component.ui.views.systems.handlers.PDTreeHandlerUtil;
import com.ibm.pdtools.common.component.ui.views.systems.handlers.SkeletonHandler;
import com.ibm.pdtools.common.component.ui.views.systems.nodes.SystemsTreeNode;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Objects;
import java.util.UUID;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class OpenFormatted
extends SkeletonHandler {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2022. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    public static final String COMMAND_ID = "com.ibm.etools.fm.ui.model.commands.openFormatted";

    protected void handle(ExecutionEvent event) throws ExecutionException {
        SystemsTreeNode selected = event.getTrigger() instanceof PDEventNode ? PDTreeHandlerUtil.getFirstSelectedRseNode((ExecutionEvent)event) : PDTreeHandlerUtil.getFirstSelectedTreeNode((ExecutionEvent)event);
        if (selected != null) {
            IPDHost host = PDTreeHandlerUtil.getSystemFrom((Object)selected);
            OpenFormatted.doOpen(selected, host, host.getCodePage());
        }
    }

    public static void doOpen(SystemsTreeNode selected, IPDHost system, String encoding) {
        if (system != null && selected != null) {
            Object item;
            Object object = item = selected == null ? null : selected.getDataObject();
            if (selected instanceof Db2SubsystemNode && ((Db2SubsystemNode)selected).isNotEnabled()) {
                PDDialogs.openInfoThreadSafe((String)MessageFormat.format(Messages.Db2TemplateEditorDialog2_9, ((Db2Subsystem)((Db2SubsystemNode)selected).getDataObject()).getName()));
                return;
            }
            if (item instanceof Db2SubsystemProvider) {
                Db2EditOptions opts = new Db2EditOptions();
                Db2Subsystem db2SubSystem = ((Db2SubsystemProvider)item).getSubsystem();
                db2SubSystem.setSystem(system);
                opts.setSubsystem(db2SubSystem);
                if (item instanceof Db2Table) {
                    opts.setTable((Db2Table)item);
                } else if (item instanceof Db2Database) {
                    opts.setOwner((Db2Database)item);
                }
                opts.setEncoding(encoding);
                OpenFormatted.invokeDb2Editor(opts);
            } else if (selected instanceof Db2ObjectRootNode || selected instanceof Db2SubsystemBrowseNode) {
                Db2EditOptions opts = new Db2EditOptions();
                opts.setHost(system);
                opts.setEncoding(encoding);
                OpenFormatted.invokeDb2Editor(opts);
            } else if (selected instanceof ImsRootNode) {
                ImsRootNode aRoot = (ImsRootNode)selected;
                OpenFormatted.invokeImsEditor(aRoot.getSystem(), encoding);
            } else if (selected instanceof ImsSubsystemBrowseNode) {
                OpenFormatted.invokeImsEditor(((ImsSubsystemBrowseNode)selected).getSystem(), encoding);
            } else if (item instanceof ImsSubsystemProvider) {
                ImsSubsystemProvider isp = (ImsSubsystemProvider)item;
                ImsAccessMode mode = item instanceof ImsPsbQuery || item instanceof ImsPsb ? ImsAccessMode.STATIC : ImsAccessMode.DYNAMIC;
                ImsRegionType regionType = ImsRegionType.BMP;
                if (item instanceof ImsPsb) {
                    regionType = ((ImsPsb)item).getRegionType();
                } else if (item instanceof ImsDatabase) {
                    regionType = ((ImsDatabase)item).getRegionType();
                } else if (item instanceof ImsPsbQuery) {
                    regionType = ((ImsPsbQuery)item).getRegionType();
                }
                if (item instanceof ImsPsb || item instanceof ImsDatabase) {
                    OpenFormatted.invokeImsEditor(system, isp.getSubsystem(), (IZRL)item, mode, regionType, encoding);
                } else {
                    OpenFormatted.invokeImsEditor(isp.getSystem(), isp.getSubsystem(), mode, regionType, encoding);
                }
            } else {
                OpenFormatted.showFormattedEditorDialog(system, selected.getDataObject() instanceof IZRL ? (IZRL)selected.getDataObject() : null);
            }
        }
    }

    private static void invokeImsEditor(IPDHost host, String encoding) {
        ImsSubsystemConfig config;
        if (VersionUtils.isServerNewEnoughForImsEdit((FMHost)FMHost.getSystem((IPDHost)host), host) && (config = ImsSubsystemLookupDialog.promptForValidConfig(host, null)) != null) {
            OpenFormatted.invokeImsEditor(host, config.getSubsystem(), ImsAccessMode.DYNAMIC, ImsRegionType.BMP, encoding);
        }
    }

    private static void invokeImsEditor(IPDHost aHost, ImsSubsystem aSubsystem, IZRL imsResource, ImsAccessMode accessMode, ImsRegionType regionType, String encoding) {
        ImsEditorOptions opts = new ImsEditorOptions(aHost, aSubsystem, imsResource, null);
        opts.setAccessMode(accessMode);
        opts.setRegionType(regionType);
        opts.setEncoding(encoding);
        OpenFormatted.invokeImsEditor(opts);
    }

    private static void invokeImsEditor(IPDHost aHost, ImsSubsystem aSubsystem, ImsAccessMode accessMode, ImsRegionType regionType, String encoding) {
        ImsEditorOptions opts = new ImsEditorOptions(aHost, aSubsystem, null, null);
        opts.setEncoding(encoding);
        opts.setAccessMode(accessMode);
        opts.setRegionType(regionType);
        OpenFormatted.invokeImsEditor(opts);
    }

    public static void showFormattedEditorDialog(IPDHost system, IZRL resource) {
        Objects.requireNonNull(system, "Must specify a non-null system.");
        OpenFormatted.showFormattedEditorDialog(system, resource, null, null, null);
    }

    public static void showFormattedEditorDialog(final IPDHost system, final IZRL resource, final IZRL template, final String position, final BaseStartPosType positionType) {
        Objects.requireNonNull(system, "Must specify a non-null system.");
        if (resource != null && !resource.getSystem().equals(system)) {
            throw new IllegalArgumentException();
        }
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                EditorOptionDialog dialog;
                Shell activeShell = Display.getCurrent().getActiveShell();
                if (resource != null && FMUIPlugin.getDefault().dsEditSessionExist(resource)) {
                    PDDialogs.openInfoThreadSafe((String)MessageFormat.format(Messages.OpenAsFormatted_DUP_EDIT, resource.getFormattedName()));
                    return;
                }
                BaseEditorOptions editorOptions = new BaseEditorOptions();
                editorOptions.setaResource(resource);
                HostDetails hostDetails = ConnectionUtilities.getHostDetails((String)system.getHostID());
                String encoding = hostDetails.getHostDefaultEncoding();
                editorOptions.setEncodingForSession(encoding);
                editorOptions.setBidiFormat(system.getBidiFormat());
                editorOptions.setaTemplate(template);
                if (position != null) {
                    editorOptions.setaStartPosition(position);
                }
                if (positionType != null && positionType == BaseStartPosType.RECORD_NUMBER) {
                    editorOptions.setStartTypeToRecordNumber();
                }
                if ((dialog = new EditorOptionDialog(activeShell, system, editorOptions)).open() != 0) {
                    PDLogger.get(OpenFormatted.class).trace((Object)"Cancel EditorOptionDialog.");
                    return;
                }
                if (FMUIPlugin.getDefault().dsEditSessionExist(dialog.getEditorOptions().getaResource())) {
                    PDDialogs.openInfoThreadSafe((String)MessageFormat.format(Messages.OpenAsFormatted_DUP_EDIT, dialog.getEditorOptions().getaResource()));
                    return;
                }
                OpenFormatted.invokeEditor(dialog.getEditorOptions(), null);
            }
        });
    }

    public static void invokeEditor(final BaseEditorOptions options, OpenAsFormattedEditorActionItem actionItem) {
        OpenAsFormattedEditorActionItem actionItemToUse;
        IZRL templateForEdit;
        Objects.requireNonNull(options, "Must specify a non-null options.");
        PDLogger.get(OpenFormatted.class).printCurrentStackTrace(MessageFormat.format("Opening with options: {0} actionItem: {1}", options == null ? "" : options, actionItem == null ? "" : actionItem));
        IPDHost system = options.getaResource().getSystem();
        final IZRL aTemplate = options.getaTemplate() != null ? (templateForEdit = options.getaTemplate()) : null;
        IZRL template = aTemplate;
        if (template != null) {
            FMHost.getSystem((IPDHost)system).addTemplateAssociation(options.getaResource(), template);
        } else {
            FMHost.getSystem((IPDHost)system).setCurrentTemplateAssociationToNoTemplate(options.getaResource());
        }
        options.getaResource().setPersistentProperty("encoding", options.getEncodingForSession());
        options.getaResource().setPersistentProperty("bidiFormat", options.getBidiFormat());
        if (actionItem == null) {
            actionItemToUse = new OpenAsFormattedEditorActionItem(options);
            FMTreeContentHolder.getInstance().getActionHistoryContent().getRegistry().add((Object)actionItemToUse);
        } else {
            actionItemToUse = actionItem;
        }
        try {
            PlatformUI.getWorkbench().getProgressService().run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask(MessageFormat.format(Messages.OpenAsFormatted_START, options.getaResource().getFormattedName(), aTemplate != null ? aTemplate.getFormattedName() : Messages.NONE), 3);
                    IHowIsGoing howIsGoing = PDUtils.convertIprogressToIHowIsGoing((IProgressMonitor)monitor);
                    try {
                        FMEditSessionProperties properties = OpenFormatted.prepareSessionProperties(options, howIsGoing);
                        actionItemToUse.setEditSessionProperties(properties);
                        monitor.worked(1);
                        UUID uniqueKey = options.getRunTempKey();
                        OpenFormattedEditorJob job = uniqueKey != null ? new OpenFormattedEditorJob(properties, options, null, actionItemToUse, uniqueKey) : new OpenFormattedEditorJob(properties, options, null, actionItemToUse);
                        job.schedule();
                    }
                    catch (CommunicationException e) {
                        throw new InvocationTargetException(e);
                    }
                    monitor.done();
                }
            });
        }
        catch (Exception e) {
            String message = "";
            if (e instanceof InvocationTargetException && e.getCause() != null) {
                message = e.getCause().getMessage();
            }
            String errMsg = MessageFormat.format(Messages.OpenFormatted_ErrorOpeningEditor, options.getaResource().getFormattedName(), aTemplate != null ? aTemplate.getFormattedName() : Messages.NONE);
            PDDialogs.openErrorThreadSafe((String)errMsg, (String)message, (Throwable)e);
            actionItemToUse.setErrorToolTipText(errMsg);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static FMEditSessionProperties prepareSessionProperties(BaseEditorOptions options, IHowIsGoing monitor) throws InterruptedException, CommunicationException {
        Objects.requireNonNull(options, "Must specify a non-null options.");
        DataSetProperties props = null;
        if (options.getaResource() instanceof DataSetOrMember) {
            DataSet dataSet = ((DataSetOrMember)options.getaResource()).asDataSet();
            Result result = dataSet.refreshSelf(monitor);
            if (!result.isSuccessfulWithoutWarnings()) throw new CommunicationException(result.getMessagesCombined().toString());
            props = dataSet.getProperties();
            return new FMEditSessionProperties(props);
        } else if (options.getaResource() instanceof UssFile) {
            rawProperties = new HashMap<String, String>();
            String binLenValue = options.getBinaryLength();
            if (binLenValue == null || binLenValue.isEmpty()) {
                rawProperties.put("Record format", "VB");
                rawProperties.put("Logical record length", "80");
            } else {
                rawProperties.put("Record format", "FB");
                rawProperties.put("Logical record length", binLenValue);
            }
            props = new DataSetProperties(rawProperties);
            return new FMEditSessionProperties(props);
        } else {
            if (!(options.getaResource() instanceof MessageQueue)) return new FMEditSessionProperties(props);
            rawProperties = new HashMap();
            rawProperties.put("Record format", "VB");
            rawProperties.put("Logical record length", "80");
            props = new DataSetProperties(rawProperties);
        }
        return new FMEditSessionProperties(props);
    }

    public static void invokeImsEditor(ImsEditorOptions initialOptions) {
        Objects.requireNonNull(initialOptions, "Must specify a non-null initialOptions.");
        OpenFormatted.invokeImsEditor(initialOptions, null, false);
    }

    public static void invokeImsEditor(ImsEditorOptions initialOptions, final OpenAsFormattedEditor1ActionItem actionItem, boolean suppressDialog) {
        Objects.requireNonNull(initialOptions, "Must specify a non-null initialOptions.");
        if (VersionUtils.isServerNewEnoughForImsEdit((FMHost)initialOptions.getSystem().getFMHostSystem(), initialOptions.getSystem())) {
            ImsEditorOptions finalOptions;
            if (suppressDialog) {
                finalOptions = initialOptions;
            } else {
                ImsEditorOptionsDialog dialog = new ImsEditorOptionsDialog(initialOptions);
                if (dialog.open() != 0) {
                    return;
                }
                finalOptions = dialog.getOptions();
            }
            if (finalOptions.getImsResource() != null && FMUIPlugin.getDefault().dsEditSessionExist(finalOptions.getImsResource())) {
                PDDialogs.openInfoThreadSafe((String)MessageFormat.format(Messages.OpenAsFormatted_DUP_EDIT, finalOptions.getImsResource().getFormattedName()));
                return;
            }
            if (finalOptions.getTemplate() != null && !DummyDataSet.isDummyDataSetOrMember((IZRL)finalOptions.getTemplate())) {
                FMHost.getSystem((IPDHost)finalOptions.getSystem()).addTemplateAssociation(finalOptions.getImsResource(), (IZRL)finalOptions.getTemplate());
            } else {
                FMHost.getSystem((IPDHost)finalOptions.getSystem()).setCurrentTemplateAssociationToNoTemplate(finalOptions.getImsResource());
            }
            FMEditSessionProperties properties = new FMEditSessionProperties();
            final OpenFormattedEditorJob job = new OpenFormattedEditorJob(properties, finalOptions, null, finalOptions.getEncoding(), finalOptions.getDbcsEncoding(), finalOptions.getBidiFormat());
            job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    if (job.editorStartOK()) {
                        if (actionItem == null) {
                            FMTreeContentHolder.getInstance().getActionHistoryContent().getRegistry().add((Object)new OpenAsFormattedEditor1ActionItem(finalOptions));
                        } else {
                            actionItem.setErrorToolTipText(null);
                        }
                    } else if (actionItem == null) {
                        OpenAsFormattedEditor1ActionItem newItem = new OpenAsFormattedEditor1ActionItem(finalOptions);
                        newItem.setErrorToolTipText(job.getDb2ImsOverallResult().getMessagesCombined().toString());
                        FMTreeContentHolder.getInstance().getActionHistoryContent().getRegistry().add((Object)newItem);
                    } else {
                        actionItem.setErrorToolTipText(job.getDb2ImsOverallResult().getMessagesCombined().toString());
                    }
                }
            });
            job.schedule();
        }
    }

    public static void invokeDb2Editor(Db2EditOptions initialOptions) {
        Objects.requireNonNull(initialOptions, "Must specify a non-null initialOptions.");
        OpenFormatted.invokeDb2Editor(initialOptions, null, false);
    }

    public static void invokeDb2Editor(Db2EditOptions initialOptions, final OpenAsFormattedEditor2ActionItem actionItem, boolean suppressDialog) {
        Db2EditOptions finalOptions;
        Objects.requireNonNull(initialOptions, "Must specify a non-null initialOptions.");
        if (suppressDialog) {
            finalOptions = initialOptions;
        } else {
            Db2EditorDialog dialog = new Db2EditorDialog(initialOptions);
            if (dialog.open() != 0) {
                return;
            }
            finalOptions = dialog.getOptions();
        }
        if (finalOptions.getTable() != null && FMUIPlugin.getDefault().dsEditSessionExist((IZRL)finalOptions.getTable())) {
            PDDialogs.openInfoThreadSafe((String)MessageFormat.format(Messages.OpenAsFormatted_DUP_EDIT, finalOptions.getTable().getFormattedName()));
            return;
        }
        if (finalOptions.getTemplate() != null && !DummyDataSet.isDummyDataSetOrMember((IZRL)finalOptions.getTemplate())) {
            FMHost.getSystem((IPDHost)finalOptions.getSystem()).addTemplateAssociation((IZRL)finalOptions.getTable(), finalOptions.getTemplate());
        } else {
            FMHost.getSystem((IPDHost)finalOptions.getSystem()).setCurrentTemplateAssociationToNoTemplate((IZRL)finalOptions.getTable());
        }
        FMEditSessionProperties properties = new FMEditSessionProperties();
        final OpenFormattedEditorJob job = new OpenFormattedEditorJob(properties, finalOptions, null, finalOptions.getEncoding(), finalOptions.getDbcsEncoding(), finalOptions.getBidiFormat());
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (job.editorStartOK()) {
                    if (actionItem == null) {
                        FMTreeContentHolder.getInstance().getActionHistoryContent().getRegistry().add((Object)new OpenAsFormattedEditor2ActionItem(finalOptions));
                    } else {
                        actionItem.setErrorToolTipText(null);
                    }
                } else if (actionItem == null) {
                    OpenAsFormattedEditor2ActionItem newItem = new OpenAsFormattedEditor2ActionItem(finalOptions);
                    newItem.setErrorToolTipText(job.getDb2ImsOverallResult().getMessagesCombined().toString());
                    FMTreeContentHolder.getInstance().getActionHistoryContent().getRegistry().add((Object)newItem);
                } else {
                    actionItem.setErrorToolTipText(job.getDb2ImsOverallResult().getMessagesCombined().toString());
                }
            }
        });
        job.schedule();
    }

    public static void invokeDb2Editor(Db2EditOptions initialOptions, char relType, String whereClause) {
        Objects.requireNonNull(initialOptions, "Must specify a non-null initialOptions.");
        Db2EditorDialog dialog = new Db2EditorDialog(initialOptions);
        Db2EditOptions options = dialog.getOptions();
        options.setTemplate((IZRL)DummyMember.createDummyMember((IPDHost)options.getSystem()));
        options.setWhereClause(relType, whereClause);
        FMEditSessionProperties properties = new FMEditSessionProperties();
        OpenFormattedEditorJob job = new OpenFormattedEditorJob(properties, options, null, options.getEncoding(), options.getDbcsEncoding(), options.getBidiFormat());
        job.schedule();
    }
}

