/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.views.systems.handlers;

import com.ibm.etools.fm.core.model.DataSetQuery;
import com.ibm.etools.fm.core.model.MessageQueueQuery;
import com.ibm.etools.fm.core.model.UssFileQuery;
import com.ibm.etools.fm.core.model.cics.CicsResourceQuery;
import com.ibm.etools.fm.core.model.db2.Db2ObjectQuery;
import com.ibm.etools.fm.core.model.ims.ImsDatabaseQuery;
import com.ibm.etools.fm.core.model.ims.ImsPsbQuery;
import com.ibm.etools.fm.core.model.ims.ImsQuery;
import com.ibm.etools.fm.core.model.ims.ImsRegionSpecificQuery;
import com.ibm.etools.fm.ui.dialog.CicsResourceQueryDialog;
import com.ibm.etools.fm.ui.dialog.DataSetQueryDialog;
import com.ibm.etools.fm.ui.dialog.Db2ObjectQueryDialog;
import com.ibm.etools.fm.ui.dialog.ImsQueryDialogModel;
import com.ibm.etools.fm.ui.dialog.ImsQueryWizard;
import com.ibm.etools.fm.ui.dialog.MessageQueueQueryDialog;
import com.ibm.etools.fm.ui.dialog.UssFileQueryDialog;
import com.ibm.etools.fm.ui.views.systems.FMTreeContentHolder;
import com.ibm.etools.fm.ui.views.systems.model.ImsTreeContent;
import com.ibm.etools.fm.ui.views.systems.nodes.CicsResourceQueryNode;
import com.ibm.etools.fm.ui.views.systems.nodes.DataSetQueryNode;
import com.ibm.etools.fm.ui.views.systems.nodes.Db2ObjectQueryNode;
import com.ibm.etools.fm.ui.views.systems.nodes.ImsDatabaseQueryNode;
import com.ibm.etools.fm.ui.views.systems.nodes.ImsPsbQueryNode;
import com.ibm.etools.fm.ui.views.systems.nodes.MessageQueueQueryNode;
import com.ibm.etools.fm.ui.views.systems.nodes.UssFileQueryNode;
import com.ibm.pdtools.common.component.jhost.registery.EntityRegistry;
import com.ibm.pdtools.common.component.ui.views.systems.PDSystemsView;
import com.ibm.pdtools.common.component.ui.views.systems.handlers.PDTreeHandlerUtil;
import com.ibm.pdtools.common.component.ui.views.systems.handlers.SkeletonHandler;
import com.ibm.pdtools.common.component.ui.views.systems.nodes.SystemsTreeNode;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeViewer;

public class ModifyQuery
extends SkeletonHandler {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";

    protected void handle(ExecutionEvent event) throws ExecutionException {
        PDSystemsView systemsView = PDTreeHandlerUtil.getActiveSystemsViewChecked((ExecutionEvent)event);
        TreeViewer viewer = systemsView.getTreeViewer();
        SystemsTreeNode node = PDTreeHandlerUtil.getFirstSelectedElement((ISelection)viewer.getSelection());
        boolean originalExpanded = systemsView.getTreeViewer().getExpandedState((Object)node);
        ImsRegionSpecificQuery replacementQuery = null;
        if (node instanceof UssFileQueryNode) {
            replacementQuery = ModifyQuery.modifyUssFileQuery((UssFileQuery)((UssFileQueryNode)node).getDataObject());
        } else if (node instanceof DataSetQueryNode) {
            replacementQuery = ModifyQuery.modifyDataSetQuery((DataSetQuery)((DataSetQueryNode)node).getDataObject());
        } else if (node instanceof MessageQueueQueryNode) {
            replacementQuery = ModifyQuery.modifyMessageQueueQuery((MessageQueueQuery)((MessageQueueQueryNode)node).getDataObject());
        } else if (node instanceof CicsResourceQueryNode) {
            replacementQuery = ModifyQuery.modifyCICSResourceQuery((CicsResourceQuery)((CicsResourceQueryNode)node).getDataObject());
        } else if (node instanceof Db2ObjectQueryNode) {
            replacementQuery = ModifyQuery.modifyDb2ObjectQuery((Db2ObjectQuery)((Db2ObjectQueryNode)node).getDataObject());
        } else if (node instanceof ImsPsbQueryNode) {
            replacementQuery = ModifyQuery.modifyImsQuery((ImsRegionSpecificQuery)((ImsPsbQueryNode)node).getDataObject());
        } else if (node instanceof ImsDatabaseQueryNode) {
            replacementQuery = ModifyQuery.modifyImsQuery((ImsRegionSpecificQuery)((ImsDatabaseQueryNode)node).getDataObject());
        }
        if (replacementQuery != null && originalExpanded) {
            systemsView.expandAndSelect(replacementQuery, node.getClass());
        }
    }

    private static DataSetQuery modifyDataSetQuery(DataSetQuery query) {
        DataSetQueryDialog dialog = new DataSetQueryDialog(query.getSystem(), true);
        dialog.setQuery(query);
        if (dialog.open() != 0) {
            return null;
        }
        EntityRegistry<DataSetQuery> registry = FMTreeContentHolder.getInstance().getDataSetContent().getQueryRegistry();
        registry.remove((Object)query);
        return (DataSetQuery)registry.findOrAdd((Object)dialog.getQuery());
    }

    private static MessageQueueQuery modifyMessageQueueQuery(MessageQueueQuery query) {
        MessageQueueQueryDialog dialog = new MessageQueueQueryDialog(query.getSystem(), true);
        dialog.setQuery(query);
        if (dialog.open() != 0) {
            return null;
        }
        EntityRegistry<MessageQueueQuery> registry = FMTreeContentHolder.getInstance().getMqContent().getQueryRegistry();
        registry.remove((Object)query);
        return (MessageQueueQuery)registry.findOrAdd((Object)dialog.getQuery());
    }

    private static UssFileQuery modifyUssFileQuery(UssFileQuery query) {
        UssFileQueryDialog dialog = new UssFileQueryDialog(query.getSystem(), true);
        dialog.setQuery(query);
        if (dialog.open() != 0) {
            return null;
        }
        EntityRegistry<UssFileQuery> registry = FMTreeContentHolder.getInstance().getUssContent().getQueryRegistry();
        registry.remove((Object)query);
        return (UssFileQuery)registry.findOrAdd((Object)dialog.getQuery());
    }

    private static CicsResourceQuery<?> modifyCICSResourceQuery(CicsResourceQuery<?> query) {
        CicsResourceQueryDialog dialog = new CicsResourceQueryDialog(query.getSystem(), true);
        dialog.setQuery(query);
        if (dialog.open() != 0) {
            return null;
        }
        EntityRegistry<CicsResourceQuery<?>> registry = FMTreeContentHolder.getInstance().getCicsContent().getResourceQueryRegistry();
        registry.remove(query);
        return (CicsResourceQuery)registry.findOrAdd(dialog.getQuery());
    }

    private static Db2ObjectQuery<?> modifyDb2ObjectQuery(Db2ObjectQuery<?> query) {
        Db2ObjectQueryDialog dialog = new Db2ObjectQueryDialog(query.getSystem(), true);
        dialog.setQuery(query);
        if (dialog.open() != 0) {
            return null;
        }
        EntityRegistry<Db2ObjectQuery<?>> registry = FMTreeContentHolder.getInstance().getDb2Content().getObjectQueryRegistry();
        registry.remove(query);
        return (Db2ObjectQuery)registry.findOrAdd(dialog.getQuery());
    }

    private static ImsRegionSpecificQuery modifyImsQuery(ImsRegionSpecificQuery query) {
        ImsQueryDialogModel model = new ImsQueryDialogModel(query.getSystem(), true);
        ImsTreeContent imsContent = FMTreeContentHolder.getInstance().getImsContent();
        model.setSubsystemConfig(query.getSubsystem().getCanonicalConfig());
        if (query instanceof ImsQuery) {
            model.setRegionType(((ImsQuery)query).getRegionType());
        }
        model.setAccessMode(query);
        model.setPattern(query.getPattern());
        if (ImsQueryWizard.open(model) != 0) {
            return null;
        }
        if (query instanceof ImsPsbQuery) {
            imsContent.getPsbQueries().remove((Object)((ImsPsbQuery)query));
        } else if (query instanceof ImsDatabaseQuery) {
            imsContent.getDatabaseQueries().remove((Object)((ImsDatabaseQuery)query));
        } else {
            throw new IllegalArgumentException(query.getClass().getCanonicalName());
        }
        ImsRegionSpecificQuery newQuery = model.getQuery();
        if (newQuery instanceof ImsPsbQuery) {
            return (ImsRegionSpecificQuery)imsContent.getPsbQueries().findOrAdd((Object)((ImsPsbQuery)newQuery));
        }
        if (newQuery instanceof ImsDatabaseQuery) {
            return (ImsRegionSpecificQuery)imsContent.getDatabaseQueries().findOrAdd((Object)((ImsDatabaseQuery)newQuery));
        }
        throw new IllegalStateException(newQuery.getClass().getCanonicalName());
    }
}

