/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.views.systems.handlers;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.FMHost;
import com.ibm.etools.fm.core.model.ims.ImsSubsystem;
import com.ibm.etools.fm.core.model.ims.ImsSubsystemConfig;
import com.ibm.etools.fm.core.model.ims.ImsSubsystemConfigDialogModel;
import com.ibm.etools.fm.core.socket.io.ConnPoolManagerFM;
import com.ibm.etools.fm.ui.dialog.ImsSubsystemConfigWizard;
import com.ibm.etools.fm.ui.views.systems.nodes.ImsSubsystemBrowseNode;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.jhost.core.model.IPDConnectEndpoint;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.ui.util.PDDialogs;
import com.ibm.pdtools.common.component.ui.util.PDSafeUIRunner;
import com.ibm.pdtools.common.component.ui.views.systems.PDSystemsView;
import com.ibm.pdtools.common.component.ui.views.systems.PDTreeContentHolder;
import com.ibm.pdtools.common.component.ui.views.systems.handlers.PDTreeHandlerUtil;
import com.ibm.pdtools.common.component.ui.views.systems.handlers.SkeletonHandler;
import com.ibm.pdtools.common.component.ui.views.systems.nodes.SystemsTreeNode;
import java.util.List;
import java.util.Objects;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;

public class ModifyImsSubsystemConfig
extends SkeletonHandler {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final PDLogger logger = PDLogger.get(ModifyImsSubsystemConfig.class);

    protected void handle(ExecutionEvent event) throws ExecutionException {
        ImsSubsystemConfig config;
        Object selected = PDTreeHandlerUtil.getFirstSelectedDataObject((ExecutionEvent)event);
        if (selected instanceof ImsSubsystemConfig) {
            config = ((ImsSubsystemConfig)selected).getSubsystem().getCanonicalConfig();
        } else if (selected instanceof ImsSubsystem) {
            config = ((ImsSubsystem)selected).getCanonicalConfig();
        } else {
            logger.debug((Object)("Aborting - selected item is not an ImsSubsystemConfig or an ImsSubsystem: " + String.valueOf(selected)));
            return;
        }
        ModifyImsSubsystemConfig.editConfigAndSaveIfSuccessful(config);
    }

    public static boolean editConfigAndSaveIfSuccessful(ImsSubsystemConfig config) {
        Objects.requireNonNull(config, "Must provide a non-null config.");
        ImsSubsystemConfigDialogModel model = new ImsSubsystemConfigDialogModel(config);
        ImsSubsystemConfigWizard wizard = new ImsSubsystemConfigWizard(model);
        final WizardDialog dialog = new WizardDialog(null, (IWizard)wizard);
        wizard.setDialogCloser(new Runnable(){

            @Override
            public void run() {
                PDSafeUIRunner.asyncExec((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (!dialog.getShell().isDisposed()) {
                            dialog.close();
                        }
                    }
                });
            }
        });
        if (dialog.open() != 0) {
            return false;
        }
        ConnPoolManagerFM connPoolManager = ConnPoolManagerFM.instance();
        if (connPoolManager.hasConnectionInUse((IPDConnectEndpoint)config.getSubsystem()) && !PDDialogs.openQuestion((String)Messages.CommHost_RISK_DATA_LOSS_TITLE, (String)Messages.CommHost_WARN_UNEXPECTED_BEHAVIOUR_TEXT)) {
            return false;
        }
        connPoolManager.closeAllConnectionsForEndpoint((IPDConnectEndpoint)config.getSubsystem());
        model.saveEditsTo(config);
        ((FMHost)FMHost.getSystem((IPDHost)config.getSystem())).saveImsCanonicalConfig(config);
        List imsNodeList = PDTreeContentHolder.getInstance().getNodesFor((Object)config.getSubsystem());
        for (SystemsTreeNode imsNode : imsNodeList) {
            if (!(imsNode.getParent() instanceof ImsSubsystemBrowseNode)) continue;
            List children = imsNode.getChildren();
            for (SystemsTreeNode aChild : children) {
                aChild.refreshSelf();
            }
        }
        PDSystemsView.tryRefresh();
        return true;
    }
}

