/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.views.systems.handlers;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.DataSet;
import com.ibm.etools.fm.core.model.FMHost;
import com.ibm.etools.fm.core.socket.func.DSMG;
import com.ibm.etools.fm.core.socket.func.UtilityFunctionRunner;
import com.ibm.etools.fm.jhost.core.socket.func.UtilityFunction;
import com.ibm.pdtools.common.component.core.util.PDUtils;
import com.ibm.pdtools.common.component.jhost.core.model.IPDConnectEndpoint;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import com.ibm.pdtools.common.component.ui.views.systems.PDSystemsView;
import com.ibm.pdtools.common.component.ui.views.systems.handlers.PDTreeHandlerUtil;
import com.ibm.pdtools.common.component.ui.views.systems.handlers.SkeletonHandler;
import com.ibm.pdtools.common.component.ui.views.systems.nodes.SystemsTreeNode;
import java.text.MessageFormat;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.handlers.HandlerUtil;

public class MigrateDataset
extends SkeletonHandler {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2020. All rights reserved.";

    protected void handle(final ExecutionEvent event) throws ExecutionException {
        List selectedItems = PDTreeHandlerUtil.getSelectedDataObjects((ExecutionEvent)event);
        if (!selectedItems.isEmpty()) {
            final DataSet ds = (DataSet)selectedItems.get(0);
            final String dsnin = selectedItems.get(0).toString();
            final IPDHost system = PDTreeHandlerUtil.getSystemFrom(selectedItems.get(0));
            if (system != null) {
                Job job = new Job(Messages.MigrateDataset_MigratingDataSet){

                    protected IStatus run(IProgressMonitor monitor) {
                        monitor.beginTask(Messages.MigrateDataset_MigratingNominatedDataSet, 4);
                        monitor.worked(1);
                        DSMG dsmg = new DSMG();
                        dsmg.setDsnIn(dsnin);
                        IHowIsGoing howisgoing = PDUtils.convertIprogressToIHowIsGoing((IProgressMonitor)monitor);
                        monitor.worked(1);
                        try {
                            Result result = UtilityFunctionRunner.execute((IPDHost)system, (IPDConnectEndpoint)FMHost.getSystem((IPDHost)system), (UtilityFunction)dsmg, (IHowIsGoing)howisgoing);
                            monitor.worked(1);
                            if (result.getRC() != 0) {
                                int idx;
                                Pattern pattern;
                                Matcher matcher;
                                String errMsg = MessageFormat.format(Messages.MigrateDataset_MigrateFailed, result.getRC());
                                String fmnmsg = result.dumpOutputAndMessages(false).toString();
                                String details = null;
                                if (fmnmsg != null && (matcher = (pattern = Pattern.compile("(FMN.*|HFM.*)")).matcher(fmnmsg)).find() && (idx = (details = matcher.group(0)).indexOf("\" />")) > 0) {
                                    details = details.substring(0, idx);
                                }
                                if (details != null) {
                                    return new Status(4, "com.ibm.etools.fm.ui", errMsg, new Throwable(details));
                                }
                                return new Status(4, "com.ibm.etools.fm.ui", errMsg);
                            }
                            final boolean hadMembers = ds.getHasMembers();
                            ds.refreshSelf(howisgoing);
                            Display.getDefault().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    if (hadMembers) {
                                        SystemsTreeNode systemsTreeNode = PDTreeHandlerUtil.getFirstSelectedTreeNode((ExecutionEvent)event);
                                        PDSystemsView activeSystemsView = (PDSystemsView)HandlerUtil.getActivePart((ExecutionEvent)event);
                                        TreeViewer tree = activeSystemsView.getTreeViewer();
                                        tree.collapseToLevel((Object)systemsTreeNode, 1);
                                    }
                                    PDSystemsView.refreshPropertyPage();
                                    PDSystemsView.tryRefresh();
                                }
                            });
                        }
                        catch (IllegalArgumentException | InterruptedException e) {
                            String errMsg = Messages.RecallDataset_RecallException;
                            return new Status(4, "com.ibm.etools.fm.ui", errMsg, (Throwable)e);
                        }
                        monitor.done();
                        return Status.OK_STATUS;
                    }
                };
                job.schedule();
            }
        }
    }
}

