/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.views.systems.handlers;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.DataSet;
import com.ibm.etools.fm.core.model.FMHost;
import com.ibm.etools.fm.core.model.Member;
import com.ibm.etools.fm.core.socket.func.NewUtilityFunction;
import com.ibm.etools.fm.core.socket.func.TPLZ;
import com.ibm.etools.fm.core.socket.func.UtilityFunctionRunner;
import com.ibm.etools.fm.jhost.core.socket.func.UtilityFunction;
import com.ibm.pdtools.common.component.core.util.PDUtils;
import com.ibm.pdtools.common.component.jhost.core.model.IPDConnectEndpoint;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import com.ibm.pdtools.common.component.ui.views.systems.PDSystemsView;
import com.ibm.pdtools.common.component.ui.views.systems.handlers.PDTreeHandlerUtil;
import com.ibm.pdtools.common.component.ui.views.systems.handlers.SkeletonHandler;
import com.ibm.pdtools.common.component.ui.views.systems.nodes.SystemsTreeNode;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class LockTemplate
extends SkeletonHandler {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2021. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    public static final int MAX_HOST_VER = 140114;
    private boolean executionStatus;

    protected void handle(final ExecutionEvent event) throws ExecutionException {
        Object selected = PDTreeHandlerUtil.getFirstSelectedDataObject((ExecutionEvent)event);
        final IPDHost host = PDTreeHandlerUtil.getSystemFrom((Object)selected);
        final Member member = (Member)selected;
        DataSet dataSet = member.asDataSet();
        String dsName = dataSet.getName();
        String memberName = member.getName();
        String dsnin = dsName + "(" + memberName + ")";
        final boolean lock = member.getTemplateInfo().isLocked();
        final TPLZ tplz = new TPLZ();
        tplz.setValue((NewUtilityFunction.IUtilFuncParam)TPLZ.DSNIN, (Object)dsnin, host);
        tplz.setValue((NewUtilityFunction.IUtilFuncParam)TPLZ.LOCK, (Object)(!lock ? 1 : 0), host);
        Job job = new Job("Changing Lock Status.."){

            protected IStatus run(IProgressMonitor monitor) {
                IHowIsGoing howIsGoing = PDUtils.convertIprogressToIHowIsGoing((IProgressMonitor)monitor);
                try {
                    Result result = UtilityFunctionRunner.execute((IPDHost)host, (IPDConnectEndpoint)FMHost.getSystem((IPDHost)host), (UtilityFunction)tplz, (IHowIsGoing)howIsGoing);
                    LockTemplate.this.executionStatus = result.isSuccessfulWithoutWarnings();
                    if (LockTemplate.this.executionStatus) {
                        member.getTemplateInfo().setLockStatus(!lock);
                    }
                }
                catch (IllegalArgumentException e) {
                    LockTemplate.this.executionStatus = false;
                    e.printStackTrace();
                }
                catch (InterruptedException e) {
                    LockTemplate.this.executionStatus = false;
                    e.printStackTrace();
                }
                if (LockTemplate.this.executionStatus) {
                    return Status.OK_STATUS;
                }
                return Status.CANCEL_STATUS;
            }
        };
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(final IJobChangeEvent jobChangeEvent) {
                PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (jobChangeEvent.getResult().equals(Status.OK_STATUS)) {
                            String lockMsg = Messages.MSG_Template_Lock;
                            if (lock) {
                                lockMsg = Messages.MSG_Template_Unlock;
                            }
                            MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"SUCCESS", (String)lockMsg);
                            PDSystemsView activeSystemsView = (PDSystemsView)HandlerUtil.getActivePart((ExecutionEvent)event);
                            SystemsTreeNode treeNode = PDTreeHandlerUtil.getFirstSelectedTreeNode((ExecutionEvent)event);
                            activeSystemsView.getTreeViewer().refresh((Object)treeNode);
                            PDSystemsView.refreshPropertyPage();
                        } else {
                            String lockMsg = Messages.MSG_Template_Lock_Fail;
                            if (lock) {
                                lockMsg = Messages.MSG_Template_Unlock_Fail_;
                            }
                            MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"FAILURE", (String)lockMsg);
                        }
                    }
                });
            }
        });
        job.setUser(true);
        job.schedule();
    }
}

