/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.views.systems.handlers;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.DataSet;
import com.ibm.etools.fm.core.model.DataSetType;
import com.ibm.etools.fm.core.model.FMHost;
import com.ibm.etools.fm.core.model.HostVersion;
import com.ibm.etools.fm.core.model.Member;
import com.ibm.etools.fm.core.socket.func.DSC;
import com.ibm.etools.fm.core.socket.func.UtilityFunctionRunner;
import com.ibm.etools.fm.core.socket.io.CommonConnectionFM;
import com.ibm.etools.fm.core.socket.io.ConnPoolManagerFM;
import com.ibm.etools.fm.core.socket.io.ZosConnectionFM;
import com.ibm.etools.fm.jhost.core.socket.func.UtilityFunction;
import com.ibm.etools.fm.jhost.core.version.FMHostVersion;
import com.ibm.etools.fm.ui.dialog.ImportDialog;
import com.ibm.etools.fm.ui.history.ActionType;
import com.ibm.etools.fm.ui.history.action.ImportFileActionItem;
import com.ibm.etools.fm.ui.views.systems.FMTreeContentHolder;
import com.ibm.etools.fm.ui.wizards.CopyModel;
import com.ibm.pdtools.common.component.core.util.PDUtils;
import com.ibm.pdtools.common.component.jhost.comms.CommunicationException;
import com.ibm.pdtools.common.component.jhost.core.model.IPDConnectEndpoint;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.IZRL;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import com.ibm.pdtools.common.component.ui.views.systems.handlers.PDTreeHandlerUtil;
import com.ibm.pdtools.common.component.ui.views.systems.handlers.Refresh;
import com.ibm.pdtools.common.component.ui.views.systems.handlers.SkeletonHandler;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class ImportFile
extends SkeletonHandler {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2025. All rights reserved.";
    private String resource;
    private String template;
    private String filePath;
    private boolean printHeader;
    private boolean includeFillers;
    private boolean includeRedifines;
    private boolean singleQuotes;
    private boolean specifyDoubleBytes;
    private String volume;
    private boolean importStatus;
    private ZosConnectionFM connection;
    private boolean isMember;
    private boolean isReplace;
    private boolean isOverwrite;
    private String errMsg;
    private static final int MAX_HOST_VER = 140115;
    private boolean appendVisibleOnLoad;
    private boolean append;
    private ImportFileActionItem actionItemToUse;
    private boolean actionItemMementoExists;
    private String dataSetName;
    private boolean fromRSE;
    private List<IZRL> selectedIZRL;

    protected void handle(ExecutionEvent event) throws ExecutionException {
        Object selected = PDTreeHandlerUtil.getFirstSelectedDataObject((ExecutionEvent)event);
        this.initializeVars(selected);
        Refresh refreshAction = new Refresh();
        IPDHost host = PDTreeHandlerUtil.getSystemFrom((Object)selected);
        Objects.requireNonNull(host, "Must specify a non-null system.");
        this.doImport(event, refreshAction, host, null, false);
    }

    public void initializeVars(Object selected) {
        this.filePath = "";
        this.resource = "";
        this.template = "";
        this.isMember = false;
        this.append = true;
        this.appendVisibleOnLoad = true;
        this.errMsg = "";
        this.printHeader = true;
        this.specifyDoubleBytes = false;
        this.includeFillers = false;
        this.includeRedifines = false;
        this.singleQuotes = false;
        if (selected instanceof Member) {
            Member member = (Member)selected;
            this.resource = String.valueOf(this.resource) + member.getFormattedName();
            this.isMember = true;
            this.appendVisibleOnLoad = false;
        } else if (selected instanceof DataSet) {
            DataSet ds = (DataSet)selected;
            this.resource = ds.getName();
            if (ds.getType() == DataSetType.LIBRARY) {
                this.appendVisibleOnLoad = false;
            }
        }
    }

    public void doImport(final ExecutionEvent event, final Refresh refreshAction, final IPDHost host, final ImportFileActionItem actionHistoryItem, final boolean runDirectly) {
        int BUFFER_SIZE = 524000;
        ImportDialog dialog = null;
        if (!runDirectly) {
            dialog = new ImportDialog(host, this.isMember, this.appendVisibleOnLoad);
            dialog.setOutputFile(this.filePath);
            dialog.setBaseResourceName(this.resource);
            dialog.setBaseTemplateName(this.template);
            dialog.setAppend(this.append);
            dialog.setPrintHeader(this.printHeader);
            dialog.setSpecifyDoubleBytes(this.specifyDoubleBytes);
            dialog.setIncludeFillers(this.includeFillers);
            dialog.setIncludeRedifines(this.includeRedifines);
            dialog.setSingleQuotes(this.singleQuotes);
        }
        if (dialog != null && dialog.open() == 0 || runDirectly) {
            if (!runDirectly) {
                this.getDSCParams(dialog);
            }
            Job job = new Job("Importing CSV Data"){

                protected IStatus run(IProgressMonitor monitor) {
                    final IHowIsGoing howIsGoing = PDUtils.convertIprogressToIHowIsGoing((IProgressMonitor)monitor);
                    try {
                        CopyModel copyModel = ImportFile.this.buildCopyModel(host);
                        if (runDirectly) {
                            copyModel.setReplaceMembers(true);
                        }
                        DSC dsc = copyModel.toUtilityFunction();
                        if (actionHistoryItem == null && !runDirectly) {
                            ImportFile.this.actionItemToUse = new ImportFileActionItem(ActionType.IMPORT_DESKTOP_BASE, host);
                        } else {
                            ImportFile.this.setActionItemExists(actionHistoryItem);
                        }
                        ImportFile.this.actionItemToUse.setDataSetName(ImportFile.this.dataSetName);
                        ImportFile.this.actionItemToUse.setErrorToolTipText(null);
                        ImportFile.this.actionItemToUse.setFilePath(ImportFile.this.filePath);
                        ImportFile.this.actionItemToUse.setTemplate(ImportFile.this.template);
                        ImportFile.this.actionItemToUse.setPrintHeader(ImportFile.this.printHeader);
                        ImportFile.this.actionItemToUse.setIncludeFillers(ImportFile.this.includeFillers);
                        ImportFile.this.actionItemToUse.setIncludeRedifines(ImportFile.this.includeRedifines);
                        ImportFile.this.actionItemToUse.setSingleQuotes(ImportFile.this.singleQuotes);
                        ImportFile.this.actionItemToUse.setSpecifyDoubleBytes(ImportFile.this.specifyDoubleBytes);
                        ImportFile.this.actionItemToUse.setDestResourceVol(ImportFile.this.volume);
                        ImportFile.this.actionItemToUse.setReplace(ImportFile.this.isReplace);
                        ImportFile.this.actionItemToUse.setAppendVisibleOnLoad(ImportFile.this.appendVisibleOnLoad);
                        ImportFile.this.actionItemToUse.setAppend(ImportFile.this.append);
                        if (ImportFile.this.isReplace) {
                            ImportFile.this.actionItemToUse.setReplace(ImportFile.this.isReplace);
                            ImportFile.this.actionItemToUse.setOverwrite(ImportFile.this.isOverwrite);
                        } else {
                            ImportFile.this.actionItemToUse.setOverwrite(ImportFile.this.isOverwrite);
                        }
                        if (!ImportFile.this.actionItemMementoExists) {
                            FMTreeContentHolder.getInstance().getActionHistoryContent().getRegistry().add((Object)ImportFile.this.actionItemToUse);
                        }
                        ImportFile.this.connection = (ZosConnectionFM)ConnPoolManagerFM.instance().getConnection(host, (IPDConnectEndpoint)FMHost.getSystem((IPDHost)host), howIsGoing);
                        Result result = UtilityFunctionRunner.runCommand((CommonConnectionFM)ImportFile.this.connection, (UtilityFunction)dsc, (IHowIsGoing)howIsGoing);
                        ImportFile.this.importStatus = result.isSuccessfulWithoutWarnings();
                        if (ImportFile.this.importStatus) {
                            Display.getDefault().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    if ((this).ImportFile.this.filePath == null) {
                                        return;
                                    }
                                    try {
                                        String line;
                                        int cmd = 17;
                                        File f = new File((this).ImportFile.this.filePath);
                                        FileInputStream fis = new FileInputStream(f);
                                        InputStreamReader isr = new InputStreamReader((InputStream)fis, StandardCharsets.UTF_8);
                                        BufferedReader br = new BufferedReader(isr);
                                        ByteBuffer bb = ByteBuffer.allocate(524000);
                                        bb.putInt(0);
                                        bb.putInt(cmd);
                                        int totlen = 8;
                                        while ((line = br.readLine()) != null) {
                                            if (line.length() + totlen + 8 > 524000) {
                                                (this).ImportFile.this.importStatus = (this).ImportFile.this.connection.sendBytesToHost(howIsGoing, bb);
                                                bb.clear();
                                                bb.putInt(0);
                                                bb.putInt(cmd);
                                                totlen = 8;
                                            }
                                            totlen += line.length() + 4;
                                            bb.putInt(line.length());
                                            bb.put(line.getBytes(host.getCodePage()));
                                        }
                                        if (totlen > 8) {
                                            bb.putInt(-1);
                                            (this).ImportFile.this.importStatus = (this).ImportFile.this.connection.sendBytesToHost(howIsGoing, bb);
                                        } else {
                                            (this).ImportFile.this.importStatus = false;
                                            (this).ImportFile.this.errMsg = Messages.ImportDialog_EMPTYFILE;
                                        }
                                        br.close();
                                    }
                                    catch (FileNotFoundException e) {
                                        (this).ImportFile.this.importStatus = false;
                                        (this).ImportFile.this.errMsg = e.getMessage();
                                    }
                                    catch (IOException e) {
                                        (this).ImportFile.this.importStatus = false;
                                        (this).ImportFile.this.errMsg = e.getMessage();
                                    }
                                    catch (InterruptedException e) {
                                        (this).ImportFile.this.importStatus = false;
                                        (this).ImportFile.this.errMsg = e.getMessage();
                                    }
                                    catch (CommunicationException e) {
                                        (this).ImportFile.this.importStatus = false;
                                        (this).ImportFile.this.errMsg = e.getMessage();
                                    }
                                    catch (Exception e) {
                                        (this).ImportFile.this.importStatus = false;
                                        (this).ImportFile.this.errMsg = e.getMessage();
                                    }
                                }
                            });
                        }
                    }
                    catch (IllegalArgumentException e) {
                        ImportFile.this.errMsg = e.getMessage();
                        ImportFile.this.importStatus = false;
                    }
                    catch (InterruptedException e) {
                        ImportFile.this.errMsg = e.getMessage();
                        ImportFile.this.importStatus = false;
                    }
                    catch (CommunicationException e) {
                        ImportFile.this.errMsg = e.getMessage();
                        ImportFile.this.importStatus = false;
                    }
                    if (ImportFile.this.importStatus) {
                        return Status.OK_STATUS;
                    }
                    return Status.CANCEL_STATUS;
                }
            };
            job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent jobChangeEvent) {
                    PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            if ((this).ImportFile.this.importStatus) {
                                MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.MSGSuccess, (String)Messages.ImportCSVSuccess);
                                if (event != null) {
                                    try {
                                        refreshAction.execute(event);
                                    }
                                    catch (ExecutionException e) {
                                        e.printStackTrace();
                                    }
                                }
                            } else {
                                MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.MSGFailed, (String)(Messages.ImportCSVFailed + System.lineSeparator() + (this).ImportFile.this.errMsg));
                                if ((this).ImportFile.this.actionItemToUse != null) {
                                    (this).ImportFile.this.actionItemToUse.setErrorToolTipText(Messages.ImportCSVFailed + System.lineSeparator() + (this).ImportFile.this.errMsg);
                                }
                            }
                        }
                    });
                }
            });
            job.setUser(false);
            job.schedule();
        }
    }

    private void setActionItemExists(ImportFileActionItem actionHistoryItem) {
        this.actionItemToUse = actionHistoryItem;
        this.actionItemMementoExists = true;
    }

    private CopyModel buildCopyModel(IPDHost host) {
        CopyModel copyModel = new CopyModel(host);
        copyModel.setImportFromDesktop(true);
        copyModel.setResource(this.resource);
        copyModel.setTemplate(this.template);
        copyModel.setIncludeHeader(this.printHeader);
        copyModel.setFillers(this.includeFillers);
        copyModel.setRedefines(this.includeRedifines);
        copyModel.setSingleQuotes(this.singleQuotes);
        copyModel.setSpecifyDoubleBytes(this.specifyDoubleBytes);
        copyModel.setDestResourceVolume(this.volume);
        if (this.isReplace) {
            copyModel.setReplaceMembers(this.isReplace);
            copyModel.setOverwriteExistingRecords(false);
        } else {
            copyModel.setOverwriteExistingRecords(this.isOverwrite);
        }
        return copyModel;
    }

    private void getDSCParams(ImportDialog dialog) {
        this.dataSetName = dialog.getCachedDsName();
        this.resource = dialog.getBaseResourceName();
        this.template = dialog.getBaseTemplateName();
        this.filePath = dialog.getOutputFile();
        this.printHeader = dialog.isPrintHeader();
        this.includeFillers = dialog.isIncludeFillers();
        this.includeRedifines = dialog.isIncludeRedifines();
        this.singleQuotes = dialog.isSingleQuotes();
        this.specifyDoubleBytes = dialog.isSpecifyDoubleBytes();
        this.isReplace = dialog.isReplace();
        this.isOverwrite = !dialog.isAppend();
        this.volume = dialog.getVolume();
        this.append = dialog.isAppend();
    }

    public boolean isEnabled() {
        ISelection selection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getSelection();
        if (selection != null && selection instanceof StructuredSelection) {
            IPDHost host;
            StructuredSelection structuredSelection = (StructuredSelection)selection;
            Object selected = structuredSelection.getFirstElement();
            if (!this.fromRSE) {
                host = PDTreeHandlerUtil.getSystemFrom((Object)selected);
                boolean isConnected = ImportFile.isConnectedToHost(host);
                if (!isConnected) {
                    return false;
                }
            } else {
                host = this.selectedIZRL.get(0).getSystem();
            }
            HostVersion.getInstance().setHost(host);
            int hostVersion = HostVersion.getInstance().getVersion();
            if (hostVersion >= 140115) {
                return true;
            }
        }
        return false;
    }

    private static boolean isConnectedToHost(IPDHost host) {
        FMHostVersion hostVer = FMHost.getSystem((IPDHost)host).getServerVersion();
        return hostVer != null;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public void setPrintHeader(boolean printHeader) {
        this.printHeader = printHeader;
    }

    public void setIncludeFillers(boolean includeFillers) {
        this.includeFillers = includeFillers;
    }

    public void setIncludeRedifines(boolean includeRedifines) {
        this.includeRedifines = includeRedifines;
    }

    public void setSingleQuotes(boolean singleQuotes) {
        this.singleQuotes = singleQuotes;
    }

    public void setSpecifyDoubleBytes(boolean specifyDoubleBytes) {
        this.specifyDoubleBytes = specifyDoubleBytes;
    }

    public void setVolume(String volume) {
        this.volume = volume;
    }

    public void setImportStatus(boolean importStatus) {
        this.importStatus = importStatus;
    }

    public void setConnection(ZosConnectionFM connection) {
        this.connection = connection;
    }

    public void setMember(boolean isMember) {
        this.isMember = isMember;
    }

    public void setReplace(boolean isReplace) {
        this.isReplace = isReplace;
    }

    public void setOverwrite(boolean isOverwrite) {
        this.isOverwrite = isOverwrite;
    }

    public void setErrMsg(String errMsg) {
        this.errMsg = errMsg;
    }

    public void setAppendVisibleOnLoad(boolean appendVisibleOnLoad) {
        this.appendVisibleOnLoad = appendVisibleOnLoad;
    }

    public void setAppend(boolean append) {
        this.append = append;
    }

    public void setActionItemToUse(ImportFileActionItem actionItemToUse) {
        this.actionItemToUse = actionItemToUse;
    }

    public void setDataSetName(String dataSetName) {
        this.dataSetName = dataSetName;
    }

    public void setFromRSE(boolean fromRSE) {
        this.fromRSE = fromRSE;
    }

    public void setSelectedIZRL(List<IZRL> selectedIZRL) {
        this.selectedIZRL = selectedIZRL;
    }
}

