/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.views.systems.handlers;

import com.ibm.etools.fm.core.model.cics.CicsAppl;
import com.ibm.etools.fm.core.model.db2.Db2SubsystemProvider;
import com.ibm.etools.fm.core.model.db2.Db2SubsystemQuery;
import com.ibm.etools.fm.ui.views.systems.FMTreeContentHolder;
import com.ibm.etools.fm.ui.views.systems.nodes.Db2ObjectRootNode;
import com.ibm.etools.fm.ui.views.systems.nodes.Db2SubsystemBrowseNode;
import com.ibm.etools.fm.ui.wizards.GenerateActionItem;
import com.ibm.etools.fm.ui.wizards.GenerateModel;
import com.ibm.etools.fm.ui.wizards.GenerateWizard;
import com.ibm.etools.fm.ui.wizards.db2.Db2GenerateHandler;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.IZRL;
import com.ibm.pdtools.common.component.ui.dialog.PDScrollableWizardDialog;
import com.ibm.pdtools.common.component.ui.views.systems.handlers.PDTreeHandlerUtil;
import com.ibm.pdtools.common.component.ui.views.systems.handlers.SkeletonHandler;
import com.ibm.pdtools.common.component.ui.views.systems.nodes.SystemsTreeNode;
import java.util.Objects;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.wizard.IWizard;

public class GenerateData
extends SkeletonHandler {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";

    protected void handle(ExecutionEvent event) throws ExecutionException {
        Object selected = PDTreeHandlerUtil.getFirstSelectedDataObject((ExecutionEvent)event);
        IPDHost system = PDTreeHandlerUtil.getSystemFrom((Object)selected);
        if (system == null) {
            return;
        }
        IZRL resource = null;
        if (selected instanceof IZRL) {
            resource = ((IZRL)selected).clone();
        }
        GenerateData.showGenerateDataWizard(system, resource);
    }

    public static void doOpen(SystemsTreeNode selected, IPDHost system) {
        if (system != null) {
            Object item;
            Object object = item = selected == null ? null : selected.getDataObject();
            if (item instanceof Db2SubsystemProvider || item instanceof Db2ObjectRootNode || item instanceof Db2SubsystemBrowseNode || item instanceof Db2SubsystemQuery) {
                Db2GenerateHandler.doOpen(item, system);
            } else {
                GenerateData.showGenerateDataWizard(system, selected.getDataObject() instanceof IZRL ? (IZRL)selected.getDataObject() : null);
            }
        }
    }

    public static void showGenerateDataWizard(IPDHost system, IZRL resource) {
        Objects.requireNonNull(system, "Must specify a non-null system.");
        if (resource != null && !system.equals(resource.getSystem())) {
            throw new IllegalArgumentException();
        }
        GenerateModel allocateParams = new GenerateModel(system);
        if (resource != null && !(resource instanceof CicsAppl)) {
            allocateParams.resource = resource;
        }
        GenerateWizard wizard = new GenerateWizard(allocateParams);
        final GenerateActionItem action = new GenerateActionItem(allocateParams);
        wizard.getRunnable().addCallback(new Runnable(){

            @Override
            public void run() {
                FMTreeContentHolder.getInstance().getActionHistoryContent().getRegistry().add((Object)action);
            }
        });
        wizard.getRunnable().addCallback(action.getUpdateStateCallback(wizard.getRunnable()));
        PDScrollableWizardDialog.openWizard((IWizard)wizard);
    }
}

