/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.views.systems.handlers;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.AbstractSessionFormatted;
import com.ibm.etools.fm.core.model.BaseEditorOptions;
import com.ibm.etools.fm.core.model.DataSet;
import com.ibm.etools.fm.core.model.Member;
import com.ibm.etools.fm.core.model.db2.Db2Database;
import com.ibm.etools.fm.core.model.db2.Db2EditOptions;
import com.ibm.etools.fm.core.model.db2.Db2ObjectQuery;
import com.ibm.etools.fm.core.model.db2.Db2Subsystem;
import com.ibm.etools.fm.core.model.db2.Db2Table;
import com.ibm.etools.fm.core.model.ims.ImsDatabase;
import com.ibm.etools.fm.core.model.ims.ImsPsb;
import com.ibm.etools.fm.core.model.ims.ImsPsbQuery;
import com.ibm.etools.fm.core.model.ims.ImsSubsystemProvider;
import com.ibm.etools.fm.core.model.ims.ImsSubsystemQuery;
import com.ibm.etools.fm.editor.formatted.FMEditSessionProperties;
import com.ibm.etools.fm.editor.formatted.FormattedEditor;
import com.ibm.etools.fm.editor.formatted.contents.DisplayLine;
import com.ibm.etools.fm.editor.formatted.pages.formatted.FormattedPageUtility;
import com.ibm.etools.fm.model.formatted.EditType;
import com.ibm.etools.fm.model.formatted.FieldType;
import com.ibm.etools.fm.model.formatted.HdrType;
import com.ibm.etools.fm.model.formatted.HdrfldType;
import com.ibm.etools.fm.model.formatted.RecType;
import com.ibm.etools.fm.model.template.CreateType;
import com.ibm.etools.fm.model.template.Symboltype;
import com.ibm.etools.fm.model.template.TemplateType;
import com.ibm.etools.fm.model.template.util.TemplateSerializeUtils;
import com.ibm.etools.fm.ui.FMUIPlugin;
import com.ibm.etools.fm.ui.dialog.Export2DesktopData;
import com.ibm.etools.fm.ui.dialog.ExportAbstractDialog;
import com.ibm.etools.fm.ui.dialog.ExportDialog;
import com.ibm.etools.fm.ui.dialog.ExportDialog2;
import com.ibm.etools.fm.ui.history.ActionItem;
import com.ibm.etools.fm.ui.history.action.ExportBaseResourceActionItem;
import com.ibm.etools.fm.ui.history.action.ExportDb2ResourceActionItem;
import com.ibm.etools.fm.ui.prefs.FormattedEditorPreferencePage;
import com.ibm.etools.fm.ui.views.systems.FMTreeContentHolder;
import com.ibm.etools.fm.ui.views.systems.nodes.Db2ObjectRootNode;
import com.ibm.etools.fm.ui.views.systems.nodes.Db2SubsystemBrowseNode;
import com.ibm.etools.fm.ui.views.systems.nodes.ImsRootNode;
import com.ibm.etools.fm.ui.views.systems.nodes.ImsSubsystemBrowseNode;
import com.ibm.etools.fm.ui.wizards.ims.ImsExtractHandler;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.jhost.comms.PDContext;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.IZRL;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import com.ibm.pdtools.common.component.ui.util.PDDialogs;
import com.ibm.pdtools.common.component.ui.util.PDPlatformUIUtils;
import com.ibm.pdtools.common.component.ui.util.PDSafeUIRunner;
import com.ibm.pdtools.common.component.ui.views.systems.handlers.PDTreeHandlerUtil;
import com.ibm.pdtools.common.component.ui.views.systems.handlers.SkeletonHandler;
import com.ibm.pdtools.common.component.ui.views.systems.nodes.SystemsTreeNode;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.Objects;
import org.apache.commons.lang3.StringEscapeUtils;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.statushandlers.StatusManager;

public class ExportData
extends SkeletonHandler {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2025. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static PDLogger logger = PDLogger.get(ExportData.class);
    private static final String newLineCharacter = System.getProperty("line.separator");

    protected void handle(ExecutionEvent event) throws ExecutionException {
        SystemsTreeNode selected = PDTreeHandlerUtil.getFirstSelectedTreeNode((ExecutionEvent)event);
        IPDHost host = PDTreeHandlerUtil.getSystemFrom((Object)selected);
        ExportData.exportIt(selected, host);
    }

    public static void exportIt(SystemsTreeNode selected, IPDHost host) {
        if (host != null) {
            boolean forceDb2Export = false;
            Db2Subsystem subsystem = null;
            Db2Table table = null;
            Object item = selected.getDataObject();
            if (item instanceof Db2ObjectQuery) {
                Db2ObjectQuery query = (Db2ObjectQuery)item;
                subsystem = query.getSubsystem();
            } else if (item instanceof Db2Database) {
                Db2Database db = (Db2Database)item;
                subsystem = db.getSubsystem();
            } else if (item instanceof Db2Subsystem) {
                subsystem = (Db2Subsystem)item;
            } else if (item instanceof Db2Table) {
                table = (Db2Table)item;
            } else if (selected instanceof Db2ObjectRootNode || selected instanceof Db2SubsystemBrowseNode) {
                forceDb2Export = true;
            }
            if (forceDb2Export || table != null || subsystem != null) {
                if (table != null) {
                    subsystem = table.getSubsystem();
                }
                if (subsystem != null) {
                    host = subsystem.getSystem();
                }
                ExportData.showExportDialog2(host, subsystem, table);
            } else if (item instanceof ImsSubsystemProvider || item instanceof ImsRootNode || item instanceof ImsPsb || item instanceof ImsDatabase || item instanceof ImsSubsystemBrowseNode || item instanceof ImsPsbQuery || item instanceof ImsSubsystemQuery) {
                ImsExtractHandler.doOpen(item, host);
            } else {
                IZRL resource = null;
                if (selected.getDataObject() instanceof IZRL) {
                    resource = ((IZRL)selected.getDataObject()).clone();
                }
                ExportData.showExportDialog(host, resource);
            }
        }
    }

    public static void showExportDialog(IPDHost system, IZRL resource) {
        Objects.requireNonNull(system, "Must specify a non-null system.");
        ExportDialog dialog = new ExportDialog(system);
        if (resource != null) {
            dialog.initValues(new BaseEditorOptions(resource, null, false), new Export2DesktopData());
        }
        if (dialog.open() == 0) {
            ExportBaseResourceActionItem actionItemToUse = new ExportBaseResourceActionItem(dialog.getOptions(), dialog.getExportData());
            FMTreeContentHolder.getInstance().getActionHistoryContent().getRegistry().add((Object)actionItemToUse);
            String outputFileName = dialog.getOutputFileName();
            ExportAbstractDialog.ExportOutputType outputType = dialog.getExportType();
            BaseEditorOptions options = dialog.getOptions();
            options.getaResource().setPersistentProperty("encoding", options.getEncodingForSession());
            options.getaResource().setPersistentProperty("dbcsEncoding", options.getDbcsEncodingForSession());
            ExportData.exportFromBase(outputFileName, outputType, options, dialog.printHeader(), actionItemToUse, dialog.getDelimiter(), dialog.includeFillers(), dialog.includeRedefines(), dialog.includeLeadingBlanks(), dialog.includeTrailingBlanks(), dialog.encapsulate(), dialog.singleQuotes(), dialog.asisEncapsulation(), dialog.isUnmaskCharacters());
            FormattedPageUtility.clearEncodingErrors(options.getaResource());
        }
    }

    public static void showExportDialog(ExportBaseResourceActionItem actionItemHist, boolean showDialog) {
        Objects.requireNonNull(actionItemHist, "Must provide a non-null actionItemHist.");
        ExportDialog dialog = new ExportDialog(actionItemHist.getSystem());
        dialog.initValues(actionItemHist.getOptions(), actionItemHist.getExportData());
        if (showDialog ? dialog.open() != 0 : !ExportAbstractDialog.checkFileOverwrite(dialog.getOutputFileName()) && dialog.open() != 0) {
            return;
        }
        String outputFileName = dialog.getOutputFileName();
        ExportAbstractDialog.ExportOutputType outputType = dialog.getExportType();
        BaseEditorOptions options = dialog.getOptions();
        options.getaResource().setPersistentProperty("encoding", options.getEncodingForSession());
        options.getaResource().setPersistentProperty("dbcsEncoding", options.getDbcsEncodingForSession());
        actionItemHist.setOptions(options, dialog.getExportData());
        ExportData.exportFromBase(outputFileName, outputType, options, dialog.printHeader(), actionItemHist, dialog.getDelimiter(), dialog.includeFillers(), dialog.includeRedefines(), dialog.includeLeadingBlanks(), dialog.includeTrailingBlanks(), dialog.encapsulate(), dialog.singleQuotes(), dialog.asisEncapsulation(), dialog.isUnmaskCharacters());
        FormattedPageUtility.clearEncodingErrors(options.getaResource());
    }

    public static void showExportDialog2(IPDHost host, Db2Subsystem subsystem, Db2Table table) {
        Objects.requireNonNull(host, "Must specify a non-null host.");
        ExportDialog2 dialog = new ExportDialog2(host, subsystem, table);
        if (dialog.open() == 0) {
            ExportDb2ResourceActionItem actionItemToUse = new ExportDb2ResourceActionItem(dialog.getOptions(), dialog.getExportData());
            FMTreeContentHolder.getInstance().getActionHistoryContent().getRegistry().add((Object)actionItemToUse);
            String outputFileName = dialog.getOutputFileName();
            ExportAbstractDialog.ExportOutputType outputType = dialog.getExportType();
            Db2EditOptions editOpts = dialog.getOptions();
            editOpts.getTable().setPersistentProperty("encoding", editOpts.getEncoding());
            ExportData.exportFromDb2(outputFileName, outputType, editOpts, dialog.printHeader(), actionItemToUse, dialog.getDelimiter(), dialog.includeLeadingBlanks(), dialog.includeTrailingBlanks(), dialog.encapsulate(), dialog.singleQuotes(), dialog.asisEncapsulation());
            FormattedPageUtility.clearEncodingErrors((IZRL)editOpts.getTable());
        }
    }

    public static void showExportDialog2(ExportDb2ResourceActionItem actionItemHist, boolean showDialog) {
        ExportDialog2 dialog = new ExportDialog2(actionItemHist.getOptions());
        dialog.initValues(actionItemHist.getExportData());
        if (showDialog ? dialog.open() != 0 : !ExportAbstractDialog.checkFileOverwrite(dialog.getOutputFileName()) && dialog.open() != 0) {
            return;
        }
        String outputFileName = dialog.getOutputFileName();
        ExportAbstractDialog.ExportOutputType outputType = dialog.getExportType();
        Db2EditOptions editOpts = dialog.getOptions();
        Export2DesktopData exportData = dialog.getExportData();
        editOpts.getTable().setPersistentProperty("encoding", editOpts.getEncoding());
        actionItemHist.setOptions(editOpts, exportData);
        ExportData.exportFromDb2(outputFileName, outputType, editOpts, dialog.printHeader(), actionItemHist, dialog.getDelimiter(), dialog.includeLeadingBlanks(), dialog.includeTrailingBlanks(), dialog.encapsulate(), dialog.singleQuotes(), dialog.asisEncapsulation());
        FormattedPageUtility.clearEncodingErrors((IZRL)editOpts.getTable());
    }

    private static Writer prepareWriter(String outputFileName) {
        try {
            return new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outputFileName), StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            PDDialogs.openErrorThreadSafe((String)MessageFormat.format(Messages.ExportData_0, outputFileName), (Throwable)e);
            return null;
        }
    }

    @Deprecated
    public static void exportWithNoDialog(PDContext pdContext, String target, String srcName, String templateDataSet, String templateName) {
        ExportData.exportWithNoDialog(pdContext, target, srcName, templateDataSet, templateName, null);
    }

    @Deprecated
    public static void exportWithNoDialog(PDContext pdContext, String target, String srcName, String templateDataSet, String templateName, String encoding) {
        BaseEditorOptions options = new BaseEditorOptions((IZRL)DataSet.create((IPDHost)pdContext.getPDHost(), (String)srcName), (IZRL)Member.create((DataSet)DataSet.create((IPDHost)pdContext.getPDHost(), (String)templateDataSet), (String)templateName), false);
        options.setStartType(BaseEditorOptions.BaseStartPosType.NONE);
        options.setPDContext(pdContext);
        options.getaResource().setPersistentProperty("encoding", encoding != null ? encoding : options.getaResource().getSystem().getHostType().getDefaultEncoding());
        options.getaResource().setPersistentProperty("dbcsEncoding", "cp930");
        Export2DesktopData export2DesktopData = new Export2DesktopData();
        ExportBaseResourceActionItem exportAction = new ExportBaseResourceActionItem(options, export2DesktopData);
        ExportData.exportFromBase(target, ExportAbstractDialog.ExportOutputType.CSV, options, true, exportAction, ",", false, false, false, false, false, false, false, false);
    }

    private static void exportFromBase(final String outputFileName, final ExportAbstractDialog.ExportOutputType type, final BaseEditorOptions options, final boolean printHeader, final ExportBaseResourceActionItem actionItemHist, final String delimiter, final boolean includeFillers, final boolean includeRedefines, final boolean includeLeadingBlanks, final boolean includeTrailingBlanks, final boolean encapsulate, final boolean singleQuotes, final boolean asisEncapsulation, final boolean unmaskCharacters) {
        actionItemHist.setErrorToolTipText(null);
        try {
            Throwable throwable = null;
            Object var15_17 = null;
            try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outputFileName), StandardCharsets.UTF_8));){
                final int stepSize = FormattedEditorPreferencePage.getRecordCacheSize();
                final FMUIPlugin fmuiPlugin = FMUIPlugin.getDefault();
                if (fmuiPlugin != null) {
                    fmuiPlugin.addNewDSEditSession(options.getaResource());
                    final String jobName = MessageFormat.format(Messages.ExportData_1, options.getaResource().getFormattedName());
                    Job aJob = new Job(jobName){

                        protected IStatus run(IProgressMonitor monitor) {
                            try {
                                monitor.beginTask(jobName, 1000);
                                IStatus iStatus = ExportData.exportFromBaseImp(type, options, printHeader, actionItemHist, stepSize, outputFileName, monitor, delimiter, includeFillers, includeRedefines, includeLeadingBlanks, includeTrailingBlanks, encapsulate, singleQuotes, asisEncapsulation, unmaskCharacters);
                                return iStatus;
                            }
                            finally {
                                monitor.done();
                            }
                        }
                    };
                    aJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                        public void done(IJobChangeEvent event) {
                            ExportData.reportResult(event.getResult(), outputFileName);
                            fmuiPlugin.removeDSEditSession(options.getaResource());
                        }
                    });
                    aJob.setUser(true);
                    aJob.schedule();
                } else {
                    ExportData.reportResult(ExportData.exportFromBaseImp(type, options, printHeader, actionItemHist, stepSize, outputFileName, (IProgressMonitor)new NullProgressMonitor(), delimiter, includeFillers, includeRedefines, includeLeadingBlanks, includeTrailingBlanks, encapsulate, singleQuotes, asisEncapsulation, unmaskCharacters), outputFileName);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            PDDialogs.openErrorThreadSafe((String)MessageFormat.format(Messages.ExportData_0, outputFileName));
        }
    }

    private static void reportResult(final IStatus result, final String fileName) {
        PDSafeUIRunner.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                File file;
                if (result.getSeverity() == 4) {
                    StatusManager.getManager().handle(result, 4);
                    new File(fileName).delete();
                } else if ((result.getSeverity() == 8 || result.getSeverity() == 0) && ExportData.showResponse(fileName, result.getMessage()) && (file = new File(fileName)).exists() && file.isFile()) {
                    IFileStore fileStore = EFS.getLocalFileSystem().getStore(file.toURI());
                    IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    try {
                        IDE.openInternalEditorOnFileStore((IWorkbenchPage)page, (IFileStore)fileStore);
                    }
                    catch (PartInitException e) {
                        logger.debug((Object)("Failed to display: " + fileName), (Throwable)e);
                    }
                }
            }
        });
    }

    private static boolean showResponse(String filePath, String message) {
        MessageDialog dlg = new MessageDialog(PDPlatformUIUtils.getActivePartShell(), Messages.Information, null, message + System.lineSeparator() + MessageFormat.format(Messages.ExportAbstractDialog_finsished, filePath), 2, new String[]{Messages.ExportData_ShowFile, IDialogConstants.OK_LABEL}, 0);
        return dlg.open() == 0;
    }

    /*
     * Exception decompiling
     */
    private static IStatus exportFromBaseImp(ExportAbstractDialog.ExportOutputType type, BaseEditorOptions options, boolean printHeader, ExportBaseResourceActionItem actionItemHist, int stepSize, String outputFileName, IProgressMonitor monitor, String delimiter, boolean includeFillers, boolean includeRedefines, boolean includeLeadingBlanks, boolean includeTrailingBlanks, boolean encapsulate, boolean singleQuotes, boolean asisEncapsulation, boolean unmaskCharacters) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [43[TRYBLOCK]], but top level block is 115[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static IStatus canceled(int processedRecords) {
        return new Status(8, "com.ibm.etools.fm.ui", MessageFormat.format(Messages.ExportData_ExportResultN, processedRecords, Messages._JOB_WAS_CANCELLED));
    }

    private static IStatus error(ActionItem actionItemHist, int processedRecords, String errMsg) {
        return ExportData.error(actionItemHist, processedRecords, errMsg, null);
    }

    private static IStatus error(ActionItem actionItemHist, int processedRecords, String errMsg, String longMsg) {
        logger.error(new Object[]{errMsg, " ", longMsg == null ? "" : longMsg});
        actionItemHist.setErrorToolTipText(errMsg);
        return new Status(4, "com.ibm.etools.fm.ui", errMsg, (Throwable)new RuntimeException(longMsg == null ? "" : MessageFormat.format(Messages.ExportData_ExportedRecords, longMsg, Integer.toString(processedRecords))));
    }

    private static void exportFromDb2(final String outputFileName, final ExportAbstractDialog.ExportOutputType type, final Db2EditOptions db2EditOpts, final boolean printHeader, final ExportDb2ResourceActionItem actionItemToUse, final String delimiter, final boolean includeLeadingBlanks, final boolean includeTrailingBlanks, final boolean encapsulate, final boolean singleQuotes, final boolean asisEncapsulation) {
        actionItemToUse.setErrorToolTipText(null);
        final int stepSize = FormattedEditorPreferencePage.getRecordCacheSize();
        FMUIPlugin.getDefault().addNewDSEditSession((IZRL)db2EditOpts.getTable());
        final String jobName = MessageFormat.format(Messages.ExportData_11, db2EditOpts.getTable().getFormattedName());
        Job aJob = new Job(jobName){

            /*
             * Exception decompiling
             */
            protected IStatus run(IProgressMonitor monitor) {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [21[TRYBLOCK]], but top level block is 50[DOLOOP]
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        };
        aJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                ExportData.reportResult(event.getResult(), outputFileName);
                FMUIPlugin.getDefault().removeDSEditSession((IZRL)db2EditOpts.getTable());
            }
        });
        aJob.setUser(true);
        aJob.schedule();
    }

    private static String getXmlHeader() {
        return "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>" + newLineCharacter + "<table>" + newLineCharacter;
    }

    private static String getXmlTailer() {
        return "</table>" + newLineCharacter;
    }

    private static void printCsvHeader(EditType currentContents, RecType aRecord, TemplateType aTemplate, Writer writer, IZRL aResource, String delimiter, boolean includeFiller, boolean encapsulate, boolean singleQuotes, boolean includeLeadingBlanks, boolean includeTrailingBlanks, boolean asisEncapsulation) throws IOException {
        DisplayLine currentLine = FormattedEditor.prepareDisplayLine(aRecord, aResource, currentContents.getId());
        HdrType aHdr = FormattedEditor.getCurrentTableHeader(currentContents, aRecord.getId());
        EList columnInfos = aHdr.getHdrfld();
        int i = 0;
        while (i < columnInfos.size()) {
            HdrfldType aColumnInfo = (HdrfldType)columnInfos.get(i);
            Symboltype aSymbol = FormattedPageUtility.getSymbol(currentLine.getRecord(), aColumnInfo, aTemplate);
            if (includeFiller || !aSymbol.getName(aResource.getSystem()).equalsIgnoreCase("FILLER") && !aSymbol.getName(aResource.getSystem()).equalsIgnoreCase("*")) {
                ExportData.writeField(writer, aSymbol.getName(aResource.getSystem()), aSymbol.getName(aResource.getSystem()), ExportAbstractDialog.ExportOutputType.CSV, i == 0, delimiter, asisEncapsulation, encapsulate, singleQuotes, includeLeadingBlanks, includeTrailingBlanks);
            }
            ++i;
        }
        ExportData.writeRecordTailer(writer, ExportAbstractDialog.ExportOutputType.CSV);
    }

    private static int processRecordsBase(EditType currentContents, TemplateType aTemplate, Writer writer, ExportAbstractDialog.ExportOutputType type, IZRL aResource, FMEditSessionProperties properties, int activeLayoutID, boolean printHeader, BaseEditorOptions options, String delimiter, boolean includeFillers, boolean includeRedefines, boolean includeLeadingBlanks, boolean includeTrailingBlanks, boolean encapsulate, boolean singleQuotes, boolean asisEncapsulation, boolean unmaskCharacters) throws IOException {
        EList records = currentContents.getRec();
        boolean[] isFiller = null;
        for (RecType aRecord : records) {
            ExportData.writeRecordHeader(writer, type);
            DisplayLine currentLine = FormattedEditor.prepareDisplayLine(aRecord, aResource, currentContents.getId());
            HdrType aHdr = FormattedEditor.getCurrentTableHeader(currentContents, aRecord.getId());
            EList columnInfos = aHdr.getHdrfld();
            if (!includeFillers) {
                isFiller = ExportData.removeFillers(currentContents, aRecord, aTemplate, options.getaResource());
            }
            if (aRecord.getId() != activeLayoutID && type == ExportAbstractDialog.ExportOutputType.CSV && printHeader) {
                ExportData.printCsvHeader(currentContents, aRecord, aTemplate, writer, options.getaResource(), delimiter, includeFillers, encapsulate, singleQuotes, includeLeadingBlanks, includeTrailingBlanks, asisEncapsulation);
            }
            if (isFiller == null) {
                isFiller = new boolean[columnInfos.size()];
            }
            int i = 0;
            while (i < columnInfos.size()) {
                if (includeFillers || !isFiller[i]) {
                    HdrfldType aColumnInfo = (HdrfldType)columnInfos.get(i);
                    Symboltype aSymbol = FormattedPageUtility.getSymbol(currentLine.getRecord(), aColumnInfo, aTemplate);
                    FieldType aField = FormattedPageUtility.getField(currentLine.getRecord(), i + 1);
                    String value = null;
                    value = aField != null ? (FormattedPageUtility.performLocalStrProc(aSymbol) ? FormattedPageUtility.getANValue(properties, currentLine.getRecord(), aSymbol, aField, aColumnInfo, unmaskCharacters, aResource) : (FormattedPageUtility.performAnVcStrProc(aSymbol) ? FormattedPageUtility.getPliVCValue(properties, currentLine.getRecord(), aSymbol, aField, aColumnInfo, aResource, true) : aField.getValue())) : "";
                    ExportData.writeField(writer, aSymbol.getName(options.getaResource().getSystem()), value, type, i == 0, delimiter, asisEncapsulation, encapsulate, singleQuotes, includeLeadingBlanks, includeTrailingBlanks);
                }
                ++i;
            }
            ExportData.writeRecordTailer(writer, type);
            activeLayoutID = aRecord.getId();
        }
        return activeLayoutID;
    }

    private static boolean[] removeFillers(EditType currentContents, RecType aRecord, TemplateType aTemplate, IZRL aResource) {
        DisplayLine currentLine = FormattedEditor.prepareDisplayLine(aRecord, aResource, currentContents.getId());
        HdrType aHdr = FormattedEditor.getCurrentTableHeader(currentContents, aRecord.getId());
        EList columnInfos = aHdr.getHdrfld();
        boolean[] isFiller = new boolean[columnInfos.size()];
        int i = 0;
        while (i < columnInfos.size()) {
            HdrfldType aColumnInfo = (HdrfldType)columnInfos.get(i);
            Symboltype aSymbol = FormattedPageUtility.getSymbol(currentLine.getRecord(), aColumnInfo, aTemplate);
            if (aSymbol.getName(aResource.getSystem()).equalsIgnoreCase("FILLER") || aSymbol.getName(aResource.getSystem()).equalsIgnoreCase("*")) {
                isFiller[i] = true;
            }
            ++i;
        }
        return isFiller;
    }

    private static int processRecordsDb2(EditType currentContents, TemplateType aTemplate, Writer writer, ExportAbstractDialog.ExportOutputType type, IZRL aResource, Db2EditOptions db2EditOpts, FMEditSessionProperties properties, String delimiter, boolean includeLeadingBlanks, boolean includeTrailingBlanks, boolean encapsulate, boolean singleQuotes, boolean asisEncapsulation) throws IOException {
        EList records = currentContents.getRec();
        int recordCount = 0;
        for (RecType aRecord : records) {
            ExportData.writeRecordHeader(writer, type);
            DisplayLine currentLine = FormattedEditor.prepareDisplayLine(aRecord, aResource, currentContents.getId());
            HdrType aHdr = FormattedEditor.getCurrentTableHeader(currentContents, currentContents.getId());
            EList columnInfos = aHdr.getHdrfld();
            int i = 0;
            while (i < columnInfos.size()) {
                HdrfldType aColumnInfo = (HdrfldType)columnInfos.get(i);
                Symboltype aSymbol = FormattedPageUtility.getSymbol(currentLine.getRecord(), aColumnInfo, aTemplate);
                FieldType aField = FormattedPageUtility.getField(currentLine.getRecord(), i + 1);
                String value = null;
                value = FormattedPageUtility.isDb2Nullfield(AbstractSessionFormatted.SessionType.DB2, currentLine.getRecord(), aSymbol, aField, aColumnInfo) ? db2EditOpts.getEditorOptions().getDNULLIND() : (aSymbol.getCreate() == CreateType.VC ? FormattedPageUtility.getVCValue(properties, db2EditOpts.getEditorOptions(), currentLine.getRecord(), aSymbol, aField, aColumnInfo, aResource, false) : (FormattedPageUtility.performLocalStrProc(aSymbol) ? FormattedPageUtility.getANValue(properties, currentLine.getRecord(), aSymbol, aField, aColumnInfo, false, aResource) : aField.getValue()));
                ExportData.writeField(writer, aSymbol.getName(db2EditOpts.getSystem()), value, type, i == 0, delimiter, asisEncapsulation, encapsulate, singleQuotes, includeLeadingBlanks, includeTrailingBlanks);
                ++i;
            }
            ExportData.writeRecordTailer(writer, type);
            ++recordCount;
        }
        return recordCount;
    }

    private static void writeRecordHeader(Writer writer, ExportAbstractDialog.ExportOutputType type) throws IOException {
        if (type == ExportAbstractDialog.ExportOutputType.XML) {
            writer.write("<row>");
        }
    }

    private static void writeRecordTailer(Writer writer, ExportAbstractDialog.ExportOutputType type) throws IOException {
        if (type == ExportAbstractDialog.ExportOutputType.XML) {
            writer.write("</row>" + newLineCharacter);
        } else {
            writer.write(newLineCharacter);
        }
    }

    private static void writeField(Writer writer, String symbolName, String aValue, ExportAbstractDialog.ExportOutputType type, boolean firstItem, String delimiter, boolean asisEncapsulation, boolean encapsulate, boolean singleQuotes, boolean includeLeadingBlanks, boolean includeTrailingBlanks) throws IOException {
        if (type == ExportAbstractDialog.ExportOutputType.XML) {
            writer.write("<" + symbolName + ">" + ExportData.escapeValueForXml(aValue) + "</" + symbolName + ">");
        } else if (firstItem) {
            writer.write(ExportData.escapeValueForCsv(aValue, delimiter, asisEncapsulation, encapsulate, singleQuotes, includeLeadingBlanks, includeTrailingBlanks));
        } else {
            writer.write(delimiter + ExportData.escapeValueForCsv(aValue, delimiter, asisEncapsulation, encapsulate, singleQuotes, includeLeadingBlanks, includeTrailingBlanks));
        }
    }

    private static String escapeValueForXml(String aValue) {
        return StringEscapeUtils.escapeXml((String)aValue);
    }

    private static String escapeValueForCsv(String aValue, String delimiter, boolean asisEncapsulation, boolean encapsulate, boolean singleQuotes, boolean includeLeadingBlanks, boolean includeTrailingBlanks) {
        if (!includeLeadingBlanks) {
            aValue = ((String)aValue).replaceAll("^\\s+", "");
        }
        if (!includeTrailingBlanks) {
            aValue = ((String)aValue).replaceFirst("\\s++$", "");
        }
        String encChar = "\"";
        if (singleQuotes) {
            encChar = "'";
        }
        if (asisEncapsulation && ((String)aValue).startsWith(encChar) && ((String)aValue).endsWith(encChar)) {
            encChar = null;
        }
        if (encChar != null) {
            boolean encap = false;
            if (encapsulate || ((String)aValue).indexOf(delimiter) != -1 || ((String)aValue).indexOf(encChar) != -1) {
                encap = true;
            }
            if (encap) {
                aValue = ((String)aValue).replace(encChar, encChar + encChar);
                aValue = encChar + (String)aValue + encChar;
            }
        }
        return aValue;
    }

    private static TemplateType loadTemplate(IHowIsGoing monitor, AbstractSessionFormatted aSession, IZRL aTemplate, IFile aTemplateFile) {
        try {
            aTemplateFile.refreshLocal(1, (IProgressMonitor)monitor.getMonitor());
            return TemplateSerializeUtils.load((IFile)aTemplateFile, (IZRL)aTemplate);
        }
        catch (Exception e) {
            String errMsg = MessageFormat.format(Messages.ExportData_22, aTemplate.getFormattedName());
            PDDialogs.openErrorThreadSafe((String)errMsg);
            return null;
        }
    }
}

