/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.views.systems.handlers;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.ims.ImsSubsystem;
import com.ibm.etools.fm.core.model.ims.ImsSubsystemConfig;
import com.ibm.etools.fm.core.socket.func.UtilityFunctionRunner;
import com.ibm.etools.fm.core.util.XmlUtil;
import com.ibm.etools.fm.jhost.core.socket.func.UtilityFunction;
import com.ibm.etools.fm.ui.FMUIPlugin;
import com.ibm.pdtools.common.component.core.util.BaseTitleAreaDialog;
import com.ibm.pdtools.common.component.core.util.GUI;
import com.ibm.pdtools.common.component.core.util.PDFileSystemUtil;
import com.ibm.pdtools.common.component.core.util.PDUtils;
import com.ibm.pdtools.common.component.jhost.core.model.IPDConnectEndpoint;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.logging.ThrowableRenderer;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import com.ibm.pdtools.common.component.ui.util.PDEditorManagement;
import com.ibm.pdtools.common.component.ui.views.systems.handlers.PDTreeHandlerUtil;
import com.ibm.pdtools.common.component.ui.views.systems.handlers.SkeletonHandler;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.Objects;
import java.util.StringTokenizer;
import javax.xml.transform.TransformerException;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ExecuteFMImsCommandHandler
extends SkeletonHandler {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";

    protected void handle(ExecutionEvent event) throws ExecutionException {
        Object selected = PDTreeHandlerUtil.getFirstSelectedDataObject((ExecutionEvent)event);
        ImsSubsystemConfig config = null;
        if (selected instanceof ImsSubsystemConfig) {
            config = (ImsSubsystemConfig)selected;
        } else if (selected instanceof ImsSubsystem) {
            config = ((ImsSubsystem)selected).getCanonicalConfig();
        }
        if (config != null) {
            ExecuteFMImsCommandHandler.showBatchImsCommandDialog(config);
        }
    }

    public static void showBatchImsCommandDialog(final ImsSubsystemConfig config) {
        Objects.requireNonNull(config, "Must provide a non-null config");
        BatchCommandDialog dialog = new BatchCommandDialog();
        if (dialog.open() != 0) {
            return;
        }
        final String command = dialog.getCommand();
        Job job = new Job(MessageFormat.format(Messages.EXECUTING_X, command)){

            protected IStatus run(IProgressMonitor monitor) {
                IHowIsGoing howIsGoing = PDUtils.convertIprogressToIHowIsGoing((IProgressMonitor)monitor);
                try {
                    monitor.beginTask(this.getName(), 5);
                    IFile tmpFile = PDFileSystemUtil.getTempFile((String)"FM");
                    monitor.worked(1);
                    UtilityFunction func = new UtilityFunction(command);
                    Result result = UtilityFunctionRunner.execute((IPDHost)config.getSubsystem().getSystem(), (IPDConnectEndpoint)config.getSubsystem(), (UtilityFunction)func, (IHowIsGoing)howIsGoing);
                    monitor.worked(3);
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    pw.println(MessageFormat.format(Messages.ExecuteFMImsCommandHandler_REPORT_SYSTEM_X, config.getSystem().getConnectionName()));
                    pw.println(MessageFormat.format(Messages.ExecuteFMImsCommandHandler_REPORT_SUBSYSTEM_X, config.getSubsystem().getSubsystemID()));
                    pw.println(Messages.ExecuteFMImsCommandHandler_REPORT_COMMAND_RUN);
                    pw.println("\n");
                    pw.println(command);
                    pw.println("\n\n");
                    if (!ExecuteFMImsCommandHandler.printPossibleXmlOutput((StringBuffer)result.getOutput(), pw)) {
                        pw.println(result.dumpOutputAndMessages(false));
                    }
                    tmpFile.create((InputStream)new ByteArrayInputStream(sw.getBuffer().toString().getBytes(StandardCharsets.UTF_8)), true, monitor);
                    PDEditorManagement.openEditorFromWorkerThread((IFile)tmpFile, (IHowIsGoing)howIsGoing);
                    return Status.OK_STATUS;
                }
                catch (Exception e) {
                    return new Status(4, "com.ibm.etools.fm.ui", MessageFormat.format(Messages.BatchCommand_BATCH_COMMAND_FAILED_X, command), (Throwable)e);
                }
            }
        };
        job.setUser(true);
        job.schedule();
    }

    /*
     * Unable to fully structure code
     */
    public static boolean printPossibleXmlOutput(StringBuffer output, PrintWriter pw) {
        if (output != null && output.length() >= 6 && "<?xml".equals(output.substring(0, 5))) {
            block4: {
                strOutput = output.toString();
                try {
                    pw.println(XmlUtil.prettyPrintXmlString((String)strOutput));
                    break block4;
                }
                catch (TransformerException e) {
                    pw.println("Failed to parse apparent XML output due to exception:");
                    ThrowableRenderer.doRender((PrintWriter)pw, (Throwable)e);
                    pw.println("\n\n");
                    pw.println(Messages.ExecuteFMBaseCommandHandler_ALT_RENDER_FALLBACK);
                    tokenizer = new StringTokenizer(strOutput, ">");
                    ** while (tokenizer.hasMoreTokens())
                }
lbl-1000:
                // 1 sources

                {
                    token = tokenizer.nextToken();
                    pw.println(token + ">");
                    continue;
                }
            }
            pw.println("\n\n");
            pw.println(Messages.ExecuteFMBaseCommandHandler_RAW_OUTPUT);
            pw.println(output);
            return true;
        }
        return false;
    }

    public static class BatchCommandDialog
    extends BaseTitleAreaDialog {
        public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
        private Text wCommandEntry;
        private Combo wHistory;
        private String historyComboKey = BatchCommandDialog.class.getCanonicalName() + "historyCombo";
        private Text wPreview;
        private String command = "";

        protected Control createDialogArea(Composite parent) {
            this.setTitle(Messages.ExecuteFMImsCommandHandler_TITLE_FM_IMS_BATCH_COMMAND);
            this.setMessage(Messages.ExecuteFMImsCommandHandler_MESSAGE_ENTER_FM_IMS_BATCH_COMMAND);
            Composite composite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)2, (boolean)false), (Object)GUI.grid.d.fillAll());
            GridData layoutData = new GridData(4, 4, true, true, 2, 1);
            layoutData.heightHint = 200;
            layoutData.widthHint = 600;
            this.wCommandEntry = GUI.text.area((Composite)composite, (Object)layoutData);
            this.wCommandEntry.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    this.setComplete(wCommandEntry.getText().replaceAll("\n", " ").trim().length() > 0);
                }
            });
            this.wCommandEntry.addKeyListener(new KeyListener(){

                public void keyReleased(KeyEvent e) {
                }

                public void keyPressed(KeyEvent e) {
                    if ((e.stateMask & 0x40000) != 0) {
                        if (e.keyCode == 13) {
                            if (this.isComplete()) {
                                e.doit = false;
                                this.okPressed();
                            }
                        } else if (wHistory.getItemCount() > 0) {
                            boolean shiftPressed;
                            boolean bl = shiftPressed = (e.stateMask & 0x20000) != 0;
                            if (e.keyCode == 0x1000001 && !shiftPressed) {
                                if (wHistory.getSelectionIndex() < wHistory.getItemCount()) {
                                    wHistory.select(wHistory.getSelectionIndex() + 1);
                                } else {
                                    wHistory.deselectAll();
                                }
                                this.restoreFromHistory();
                                e.doit = false;
                            } else if (e.keyCode == 0x1000002 && !shiftPressed) {
                                if (wHistory.getSelectionIndex() > 0) {
                                    wHistory.select(wHistory.getSelectionIndex() - 1);
                                } else {
                                    wHistory.deselectAll();
                                }
                                this.restoreFromHistory();
                                e.doit = false;
                            }
                        }
                    }
                }
            });
            this.wCommandEntry.setFocus();
            GUI.label.left((Composite)composite, (String)Messages.PREVIEW, (Object)GUI.grid.d.left1());
            this.wPreview = GUI.text.fieldReadOnly((Composite)composite, (Object)GUI.grid.d.fillH((int)1));
            GUI.label.left((Composite)composite, (String)Messages.HISTORY, (Object)GUI.grid.d.left1());
            Object[] historyItems = FMUIPlugin.getDefault().getDialogValues(this.historyComboKey);
            this.wHistory = GUI.combo.readOnly((Composite)composite, (Object)GUI.grid.d.fillH((int)1), (Object[])historyItems);
            this.wHistory.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    this.restoreFromHistory();
                }
            });
            this.wHistory.setVisibleItemCount(25);
            if (historyItems.length == 0) {
                this.wHistory.setEnabled(false);
            }
            return composite;
        }

        private void restoreFromHistory() {
            this.wCommandEntry.setText(this.wHistory.getText());
        }

        protected void setComplete(boolean complete) {
            if (this.wCommandEntry != null) {
                this.command = this.wCommandEntry.getText().trim();
            }
            if (this.wPreview != null) {
                this.wPreview.setText(this.command.replaceAll("\n", " "));
            }
            super.setComplete(complete);
        }

        public String getCommand() {
            return this.command.replaceAll("\r", "").replaceAll("\n", " ");
        }

        public boolean close() {
            if (this.getReturnCode() == 0) {
                FMUIPlugin.getDefault().renewDialogValue(this.historyComboKey, this.command);
            }
            return super.close();
        }
    }
}

