/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.views.systems.handlers;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.db2.Db2Subsystem;
import com.ibm.etools.fm.core.socket.func.UtilityFunctionRunner;
import com.ibm.etools.fm.core.socket.func.db2.XCMD;
import com.ibm.etools.fm.core.socket.func.db2.XCMDParser;
import com.ibm.etools.fm.core.socket.func.db2.XSQL;
import com.ibm.etools.fm.core.socket.func.db2.XSQLParser;
import com.ibm.etools.fm.jhost.core.socket.func.UtilityFunction;
import com.ibm.etools.fm.jhost.core.socket.func.UtilityFunctionParser;
import com.ibm.etools.fm.ui.FMUIPlugin;
import com.ibm.etools.fm.ui.console.Db2SqlConsole;
import com.ibm.etools.fm.ui.views.systems.handlers.ExecuteFMBaseCommandHandler;
import com.ibm.pdtools.common.component.core.util.BaseTitleAreaDialog;
import com.ibm.pdtools.common.component.core.util.GUI;
import com.ibm.pdtools.common.component.core.util.PDFileSystemUtil;
import com.ibm.pdtools.common.component.core.util.PDUtils;
import com.ibm.pdtools.common.component.jhost.core.model.IPDConnectEndpoint;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import com.ibm.pdtools.common.component.ui.util.PDEditorManagement;
import com.ibm.pdtools.common.component.ui.views.systems.handlers.PDTreeHandlerUtil;
import com.ibm.pdtools.common.component.ui.views.systems.handlers.SkeletonHandler;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.Objects;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ExecuteDb2CommandHandler
extends SkeletonHandler {
    protected void handle(ExecutionEvent event) throws ExecutionException {
        Object selected = PDTreeHandlerUtil.getFirstSelectedDataObject((ExecutionEvent)event);
        Db2Subsystem db2S = null;
        if (selected instanceof Db2Subsystem) {
            db2S = (Db2Subsystem)selected;
        }
        if (db2S != null) {
            ExecuteDb2CommandHandler.showRunSqlDialog(db2S);
        }
    }

    public static void showRunSqlDialog(final Db2Subsystem db2Subsystem) {
        Objects.requireNonNull(db2Subsystem, "Must provide a non-null db2Subsystem");
        RunSqlDialog dialog = new RunSqlDialog();
        if (dialog.open() != 0) {
            return;
        }
        final String command = dialog.getCommand();
        final RunSqlDialog.CommandType commandType = dialog.getCommandType();
        if (commandType != RunSqlDialog.CommandType.NONE) {
            Job job = new Job(MessageFormat.format(Messages.EXECUTING_X, command)){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        monitor.beginTask(this.getName(), 5);
                        IHowIsGoing howIsGoing = PDUtils.convertIprogressToIHowIsGoing((IProgressMonitor)monitor);
                        IFile tmpFile = PDFileSystemUtil.getTempFile((String)"FM");
                        monitor.worked(1);
                        StringWriter sw = new StringWriter();
                        PrintWriter pw = new PrintWriter(sw);
                        pw.append(Messages.Db2BatchCommand_SYSTEM + String.valueOf(db2Subsystem.getSystem()));
                        pw.append("\n" + Messages.Db2BatchCommand_SUBSYSTEM + db2Subsystem.getNameWithDescription());
                        if (commandType == RunSqlDialog.CommandType.FM) {
                            pw.append("\nFM DB2 Command:\n" + command + "\n\nOutput:\n");
                            UtilityFunction func = new UtilityFunction(command);
                            Result result = UtilityFunctionRunner.execute((IPDHost)db2Subsystem.getSystem(), (IPDConnectEndpoint)db2Subsystem, (UtilityFunction)func, (IHowIsGoing)howIsGoing);
                            monitor.worked(3);
                            if (!ExecuteFMBaseCommandHandler.printPossibleXmlOutput((StringBuffer)result.getOutput(), pw)) {
                                pw.println(result.dumpOutputAndMessages(false));
                            }
                            monitor.worked(1);
                        } else if (commandType == RunSqlDialog.CommandType.SQL) {
                            pw.append(Messages.Db2BatchCommand_XSQL_CMD_FOUND);
                            pw.append("\nSQL:\n" + command + "\n\nOutput:\n");
                            XSQL xsql = new XSQL();
                            xsql.setSql(command);
                            Result result = UtilityFunctionRunner.executeAndParse((IPDHost)db2Subsystem.getSystem(), (IPDConnectEndpoint)db2Subsystem, (UtilityFunction)xsql, (UtilityFunctionParser)new XSQLParser(db2Subsystem.getSystem()), (IHowIsGoing)howIsGoing);
                            monitor.worked(3);
                            pw.append("RC of XSQL: ");
                            pw.append(Integer.toString(result.getRC()));
                            pw.append("\n");
                            Db2SqlConsole.dumpTableToWriter((Result<String[][]>)result, pw);
                            monitor.worked(1);
                        } else if (commandType == RunSqlDialog.CommandType.DB2) {
                            pw.append("\nDB2 Command:\n" + command + "\n\nOutput:\n");
                            XCMD xcmd = new XCMD();
                            xcmd.setDb2Command(command);
                            Result result = UtilityFunctionRunner.executeAndParse((IPDHost)db2Subsystem.getSystem(), (IPDConnectEndpoint)db2Subsystem, (UtilityFunction)xcmd, (UtilityFunctionParser)new XCMDParser(db2Subsystem.getSystem()), (IHowIsGoing)howIsGoing);
                            monitor.worked(3);
                            pw.println(result.dumpOutputAndMessages(false));
                            monitor.worked(1);
                        }
                        tmpFile.create((InputStream)new ByteArrayInputStream(sw.getBuffer().toString().getBytes(StandardCharsets.UTF_8)), true, monitor);
                        PDEditorManagement.openEditorFromWorkerThread((IFile)tmpFile, (IHowIsGoing)howIsGoing);
                        return Status.OK_STATUS;
                    }
                    catch (Exception e) {
                        return new Status(4, "com.ibm.etools.fm.ui", MessageFormat.format(Messages.ExecuteDb2CommandHandler_CMD_EXECUTION_FAILED, command), (Throwable)e);
                    }
                }
            };
            job.setUser(true);
            job.schedule();
        }
    }

    public static class RunSqlDialog
    extends BaseTitleAreaDialog {
        public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2020. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
        private Text wCommandEntry;
        private Combo wHistory;
        private String historyComboKey = RunSqlDialog.class.getCanonicalName() + "historyCombo";
        private Text wPreview;
        private String command = "";
        private CommandType commandType = CommandType.NONE;

        protected Control createDialogArea(Composite parent) {
            this.setTitle(Messages.Db2BatchCommand_TITLE);
            this.setMessage(Messages.Db2BatchCommand_DEFAULT_MSG);
            Composite composite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)2, (boolean)false), (Object)GUI.grid.d.fillAll());
            GridData layoutData = new GridData(4, 4, true, true, 2, 1);
            layoutData.heightHint = 200;
            layoutData.widthHint = 600;
            this.wCommandEntry = GUI.text.area((Composite)composite, (Object)layoutData);
            this.wCommandEntry.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    this.setComplete(wCommandEntry.getText().replaceAll("\n", " ").trim().length() > 0);
                }
            });
            this.wCommandEntry.addKeyListener(new KeyListener(){

                public void keyReleased(KeyEvent e) {
                }

                public void keyPressed(KeyEvent e) {
                    if ((e.stateMask & 0x40000) != 0) {
                        if (e.keyCode == 49) {
                            if (this.isComplete()) {
                                e.doit = false;
                                this.buttonPressed(CommandType.FM.ordinal());
                            }
                        } else if (e.keyCode == 50) {
                            if (this.isComplete()) {
                                e.doit = false;
                                this.buttonPressed(CommandType.SQL.ordinal());
                            }
                        } else if (e.keyCode == 51) {
                            if (this.isComplete()) {
                                e.doit = false;
                                this.buttonPressed(CommandType.DB2.ordinal());
                            }
                        } else if (e.keyCode == 52) {
                            e.doit = false;
                            this.buttonPressed(CommandType.NONE.ordinal());
                        } else if (wHistory.getItemCount() > 0) {
                            boolean shiftPressed;
                            boolean bl = shiftPressed = (e.stateMask & 0x20000) != 0;
                            if (e.keyCode == 0x1000001 && !shiftPressed) {
                                if (wHistory.getSelectionIndex() < wHistory.getItemCount()) {
                                    wHistory.select(wHistory.getSelectionIndex() + 1);
                                } else {
                                    wHistory.deselectAll();
                                }
                                this.restoreFromHistory();
                                e.doit = false;
                            } else if (e.keyCode == 0x1000002 && !shiftPressed) {
                                if (wHistory.getSelectionIndex() > 0) {
                                    wHistory.select(wHistory.getSelectionIndex() - 1);
                                } else {
                                    wHistory.deselectAll();
                                }
                                this.restoreFromHistory();
                                e.doit = false;
                            }
                        }
                    }
                }
            });
            this.wCommandEntry.setFocus();
            GUI.label.left((Composite)composite, (String)Messages.PREVIEW, (Object)GUI.grid.d.left1());
            this.wPreview = GUI.text.fieldReadOnly((Composite)composite, (Object)GUI.grid.d.fillH((int)1));
            GUI.label.left((Composite)composite, (String)Messages.HISTORY, (Object)GUI.grid.d.left1());
            Object[] historyItems = FMUIPlugin.getDefault().getDialogValues(this.historyComboKey);
            this.wHistory = GUI.combo.readOnly((Composite)composite, (Object)GUI.grid.d.fillH((int)1), (Object[])historyItems);
            this.wHistory.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    this.restoreFromHistory();
                }
            });
            this.wHistory.setVisibleItemCount(25);
            if (historyItems.length == 0) {
                this.wHistory.setEnabled(false);
            }
            return composite;
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.createButton(parent, CommandType.FM.ordinal(), Messages.ExecuteDb2CommandHandler_EXECUTE_FM_DB2_CMD, true);
            this.createButton(parent, CommandType.SQL.ordinal(), Messages.ExecuteDb2CommandHandler_EXECUTE_SQL, false);
            this.createButton(parent, CommandType.DB2.ordinal(), Messages.ExecuteDb2CommandHandler_EXECUTE_DB2_CMD, false);
            this.createButton(parent, CommandType.NONE.ordinal(), Messages.ExecuteDb2CommandHandler_CANCEL, false);
        }

        protected void buttonPressed(int buttonId) {
            if (buttonId == CommandType.FM.ordinal()) {
                this.commandType = CommandType.FM;
                this.okPressed();
            } else if (buttonId == CommandType.SQL.ordinal()) {
                this.commandType = CommandType.SQL;
                this.okPressed();
            } else if (buttonId == CommandType.DB2.ordinal()) {
                this.commandType = CommandType.DB2;
                this.okPressed();
            } else if (buttonId == CommandType.NONE.ordinal()) {
                this.commandType = CommandType.NONE;
                this.cancelPressed();
            }
        }

        private void restoreFromHistory() {
            this.wCommandEntry.setText(this.wHistory.getText());
        }

        protected void setComplete(boolean complete) {
            if (this.wCommandEntry != null) {
                this.command = this.wCommandEntry.getText().trim();
            }
            if (this.wPreview != null) {
                this.wPreview.setText(this.command.replaceAll("\n", " "));
            }
            this.getButton(CommandType.FM.ordinal()).setEnabled(complete);
            this.getButton(CommandType.SQL.ordinal()).setEnabled(complete);
            this.getButton(CommandType.DB2.ordinal()).setEnabled(complete);
            super.setComplete(complete);
        }

        public String getCommand() {
            return this.command.replaceAll("\r", "").replaceAll("\n", " ");
        }

        public boolean close() {
            if (this.getReturnCode() == 0) {
                FMUIPlugin.getDefault().renewDialogValue(this.historyComboKey, this.command);
            }
            return super.close();
        }

        public CommandType getCommandType() {
            return this.commandType;
        }

        public static enum CommandType {
            FM,
            SQL,
            DB2,
            NONE;

        }
    }
}

