/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.views.systems.handlers;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.FMHost;
import com.ibm.etools.fm.core.socket.io.CommonConnectionFM;
import com.ibm.etools.fm.core.socket.io.ConnPoolManagerFM;
import com.ibm.pdtools.common.component.core.util.PDUtils;
import com.ibm.pdtools.common.component.jhost.comms.CommunicationException;
import com.ibm.pdtools.common.component.jhost.core.model.IPDConnectEndpoint;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import com.ibm.pdtools.common.component.ui.util.PDDialogs;
import com.ibm.pdtools.common.component.ui.views.systems.handlers.PDTreeHandlerUtil;
import com.ibm.pdtools.common.component.ui.views.systems.handlers.SkeletonHandler;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.Map;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;

public class DisplayHostVersion
extends SkeletonHandler {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";

    protected void handle(ExecutionEvent event) {
        Object o = PDTreeHandlerUtil.getFirstSelectedDataObject((ExecutionEvent)event);
        if (o instanceof IPDHost) {
            final IPDHost host = (IPDHost)o;
            final StringWriter writer = new StringWriter();
            Job loader = new Job(Messages.DisplayHostVersion_LoadingHostVersion){

                protected IStatus run(IProgressMonitor monitor) {
                    monitor.beginTask(Messages.DisplayHostVersion_0, 3);
                    IHowIsGoing IHowIsGoing2 = PDUtils.convertIprogressToIHowIsGoing((IProgressMonitor)monitor);
                    monitor.worked(1);
                    try {
                        ((CommonConnectionFM)ConnPoolManagerFM.instance().getConnection(host, (IPDConnectEndpoint)FMHost.getSystem((IPDHost)host), IHowIsGoing2)).pingServer(writer, IHowIsGoing2).isSuccessfulWithoutWarnings();
                        monitor.worked(1);
                        IStatus iStatus = Status.OK_STATUS;
                        return iStatus;
                    }
                    catch (CommunicationException | IllegalArgumentException e) {
                        String errMsg = Messages.DisplayHostVersion_1;
                        Status status = new Status(4, "com.ibm.etools.fm.ui", errMsg, e);
                        return status;
                    }
                    catch (InterruptedException e) {
                        IStatus iStatus = Status.CANCEL_STATUS;
                        return iStatus;
                    }
                    finally {
                        monitor.done();
                    }
                }
            };
            loader.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    if (event.getResult().equals(Status.OK_STATUS)) {
                        Map ipvProps = host.getIPVServerProperties();
                        String ipvPtf = (String)ipvProps.get("PTF");
                        String ipvRelease = (String)ipvProps.get("RELEASE");
                        PDDialogs.openInfoThreadSafe((String)Messages.Information, (String)Messages.DisplayHostVersion_2, (String)(writer.toString() + "\n" + MessageFormat.format(Messages.DisplayHostVersion_4, ipvRelease == null ? Messages.Label__UNKNOWN : ipvRelease, ipvPtf == null ? Messages.Label__UNKNOWN : ipvPtf)));
                    }
                }
            });
            loader.setUser(true);
            loader.schedule();
        }
    }
}

