/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.views.systems.handlers;

import com.ibm.etools.fm.core.model.IDeletable;
import com.ibm.etools.fm.ui.views.systems.FMTreeContentHolder;
import com.ibm.etools.fm.ui.wizards.DeleteActionItem;
import com.ibm.etools.fm.ui.wizards.DeleteWizard;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.ui.dialog.PDScrollableWizardDialog;
import com.ibm.pdtools.common.component.ui.views.systems.handlers.PDTreeHandlerUtil;
import com.ibm.pdtools.common.component.ui.views.systems.handlers.SkeletonHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.wizard.IWizard;

public class Delete
extends SkeletonHandler {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final PDLogger logger = PDLogger.get(Delete.class);
    public static String ID = "com.ibm.etools.fm.ui.model.commands.delete";

    protected void handle(ExecutionEvent event) throws ExecutionException {
        ArrayList<IDeletable> itemsToDelete = new ArrayList<IDeletable>();
        for (Object item : PDTreeHandlerUtil.getSelectedDataObjects((ExecutionEvent)event)) {
            if (item instanceof IDeletable) {
                itemsToDelete.add((IDeletable)item);
                continue;
            }
            logger.debug(new Object[]{"ignoring ", item});
        }
        Delete.showDeleteWizard(itemsToDelete);
    }

    public static void showDeleteWizard(List<IDeletable> itemsToDelete) {
        Objects.requireNonNull(itemsToDelete, "Must specify a non-null itemsToDelete.");
        if (!itemsToDelete.isEmpty()) {
            DeleteWizard wizard = new DeleteWizard(itemsToDelete);
            final DeleteActionItem action = new DeleteActionItem(new ArrayList<IDeletable>(itemsToDelete));
            wizard.getRunnable().addCallback(new Runnable(){

                @Override
                public void run() {
                    FMTreeContentHolder.getInstance().getActionHistoryContent().getRegistry().add((Object)action);
                }
            });
            wizard.getRunnable().addCallback(action.getUpdateStateCallback(wizard.getRunnable()));
            PDScrollableWizardDialog.openWizard((IWizard)wizard);
        }
    }
}

