/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.views.systems.handlers;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.AbstractSessionTemplate;
import com.ibm.etools.fm.editor.template.FMTemplateEditorInput;
import com.ibm.etools.fm.editor.template.TemplateEditorUtilities;
import com.ibm.etools.fm.editor.template.dialogs.NewDynamicTemplateDialog;
import com.ibm.etools.fm.model.template.TemplateType;
import com.ibm.etools.fm.model.template.util.TemplateSerializeUtils;
import com.ibm.etools.fm.ui.FMUIPlugin;
import com.ibm.etools.fm.ui.util.EditorManagement;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.model.ISessionEdit;
import com.ibm.pdtools.common.component.core.util.PDUtils;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.IZRL;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import com.ibm.pdtools.common.component.ui.util.PDDialogs;
import com.ibm.pdtools.common.component.ui.views.systems.PDSystemsTreeUpdater;
import com.ibm.pdtools.common.component.ui.views.systems.handlers.PDTreeHandlerUtil;
import com.ibm.pdtools.common.component.ui.views.systems.handlers.SkeletonHandler;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.Objects;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.PlatformUI;

public class CreateTemplate
extends SkeletonHandler {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2021. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final PDLogger logger = PDLogger.get(CreateTemplate.class);

    protected void handle(ExecutionEvent event) throws ExecutionException {
        Object selected = PDTreeHandlerUtil.getFirstSelectedDataObject((ExecutionEvent)event);
        IPDHost system = PDTreeHandlerUtil.getSystemFrom((Object)selected);
        if (system == null) {
            return;
        }
        NewDynamicTemplateDialog dialog = null;
        dialog = selected instanceof IZRL ? new NewDynamicTemplateDialog(system, (IZRL)selected) : new NewDynamicTemplateDialog(system, null);
        if (dialog.open() != 0) {
            return;
        }
        TemplateType newDynamicTemplate = dialog.getNewTemplateContents();
        IZRL newTemplateResource = dialog.getNewTemplateName();
        CreateTemplate.createNewTemplate(newTemplateResource, newDynamicTemplate);
    }

    public static boolean createNewTemplate(IZRL newTemplateResource, TemplateType newTemplateContents) {
        return CreateTemplate.createNewTemplate(newTemplateResource, newTemplateContents, null);
    }

    public static boolean createNewTemplate(final IZRL newTemplateResource, final TemplateType newTemplateContents, final Object notifier) {
        Objects.requireNonNull(newTemplateResource, "Must specify a non-null newTemplateResource.");
        if (FMUIPlugin.getDefault().templateEditSessionExist(newTemplateResource)) {
            PDDialogs.openInfoThreadSafe((String)MessageFormat.format(Messages.CreateTemplateWizard_DUP_EDIT, newTemplateResource.getFormattedName()));
            return false;
        }
        final AbstractSessionTemplate session = AbstractSessionTemplate.createTemplateEditSession((IZRL)newTemplateResource);
        final Result overallResult = new Result((Object)new StringBuffer());
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask(MessageFormat.format(Messages.CreateTemplateDynamicPage_CHECK_EXIST, newTemplateResource.getFormattedName()), 3);
                    IHowIsGoing howIsGoing = PDUtils.convertIprogressToIHowIsGoing((IProgressMonitor)monitor);
                    try {
                        Result result = session.startNew(howIsGoing, TemplateSerializeUtils.save((TemplateType)newTemplateContents, (IZRL)newTemplateResource));
                        if (result.getRC() >= 8 || session.getFromCacheFile() == null) {
                            String errMsg = MessageFormat.format(Messages.OpenAsTemplate_START_ERR_MSG, newTemplateResource.getFormattedName());
                            overallResult.addSubResult(result);
                            overallResult.add(errMsg);
                            monitor.done();
                            return;
                        }
                        monitor.worked(1);
                        PDSystemsTreeUpdater.refreshAllRelatedTo((Object)newTemplateResource);
                        FMTemplateEditorInput fmiInput = new FMTemplateEditorInput(session.getFromCacheFile(), newTemplateResource, (ISessionEdit)session, true, null, -1);
                        fmiInput.setDirty(true);
                        fmiInput.setFmix(newTemplateContents.isFmix());
                        if (notifier != null) {
                            EditorManagement.openTemplateEditorFromWorkerThread(session.getFromCacheFile(), fmiInput, monitor, notifier, true);
                        } else {
                            EditorManagement.openTemplateEditorFromWorkerThread(session.getFromCacheFile(), fmiInput, monitor, true);
                        }
                        monitor.worked(1);
                        FMUIPlugin.getDefault().addNewTemplateEditSession(newTemplateResource);
                        monitor.done();
                    }
                    catch (InterruptedException ie) {
                        throw ie;
                    }
                    catch (Exception e) {
                        String errString = MessageFormat.format(Messages.CreateTemplateWizard_CREATE_EXC, newTemplateResource.getFormattedName());
                        overallResult.add((Throwable)e);
                        overallResult.add(errString);
                        logger.error((Object)errString, (Throwable)e);
                    }
                }
            });
        }
        catch (InvocationTargetException e1) {
            PDDialogs.openErrorThreadSafe((String)MessageFormat.format(Messages.CreateTemplateWizard_CREATE_EXC, newTemplateResource.getFormattedName()));
            TemplateEditorUtilities.end(session);
            return false;
        }
        catch (InterruptedException e1) {
            TemplateEditorUtilities.end(session);
            return false;
        }
        if (!overallResult.isSuccessfulWithoutWarnings()) {
            NewDynamicTemplateDialog.displayCreateTemplateErrCompilerListing(session, newTemplateResource, (Result<StringBuffer>)overallResult, true);
            return false;
        }
        return true;
    }
}

