/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.views.systems.handlers;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.DataSetOrMember;
import com.ibm.etools.fm.core.socket.func.DSG;
import com.ibm.etools.fm.ui.dialog.NewMemberDialog;
import com.ibm.etools.fm.ui.views.systems.FMTreeContentHolder;
import com.ibm.etools.fm.ui.wizards.CreateMemberActionItem;
import com.ibm.etools.fm.ui.wizards.GenerateModel;
import com.ibm.etools.fm.ui.wizards.GenerateRunnable;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.ui.util.PDDialogs;
import com.ibm.pdtools.common.component.ui.views.systems.PDSystemsView;
import com.ibm.pdtools.common.component.ui.views.systems.handlers.PDTreeHandlerUtil;
import com.ibm.pdtools.common.component.ui.views.systems.handlers.SkeletonHandler;
import java.text.MessageFormat;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;

public class CreateMember
extends SkeletonHandler {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";

    protected void handle(ExecutionEvent event) throws ExecutionException {
        Object selected = PDTreeHandlerUtil.getFirstSelectedDataObject((ExecutionEvent)event);
        IPDHost system = PDTreeHandlerUtil.getSystemFrom((Object)selected);
        if (system != null) {
            NewMemberDialog dialog;
            DataSetOrMember dataSetOrMember = null;
            if (selected instanceof DataSetOrMember) {
                dataSetOrMember = (DataSetOrMember)selected;
            }
            if ((dialog = new NewMemberDialog(system, dataSetOrMember)).open() == 0) {
                GenerateModel genModel = new GenerateModel(system);
                genModel.resource = dialog.getNewMember();
                genModel.numberOfRecords = "0";
                genModel.disposition = DSG.DsgDisp.OLD;
                GenerateRunnable aRunnable = CreateMember.getCustomCreateMemberRunnable(genModel);
                final CreateMemberActionItem action = new CreateMemberActionItem(genModel);
                aRunnable.addCallback(new Runnable(){

                    @Override
                    public void run() {
                        FMTreeContentHolder.getInstance().getActionHistoryContent().getRegistry().add((Object)action);
                    }
                });
                aRunnable.addCallback(action.getUpdateStateCallback(aRunnable));
                aRunnable.run();
            }
        }
    }

    public static GenerateRunnable getCustomCreateMemberRunnable(final GenerateModel genModel) {
        return new GenerateRunnable(genModel){

            @Override
            public void showResult() {
                if (!this.isCompletedSuccessfully()) {
                    Result<StringBuffer> result = this.getResult();
                    String out = null;
                    if (result != null) {
                        out = result.dumpOutputAndMessages(false).toString();
                    }
                    PDDialogs.openErrorThreadSafe((String)MessageFormat.format(Messages.CreateMember_0, genModel.resource.getFormattedName()), (String)out);
                } else {
                    PDSystemsView.tryRefresh();
                }
            }
        };
    }
}

