/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.views.systems.handlers;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.CopybookPrintOptions;
import com.ibm.etools.fm.core.model.FMHost;
import com.ibm.etools.fm.core.socket.func.PBK;
import com.ibm.etools.fm.core.socket.func.SET;
import com.ibm.etools.fm.core.socket.func.UtilityFunctionRunner;
import com.ibm.etools.fm.jhost.core.socket.func.UtilityFunction;
import com.ibm.etools.fm.ui.dialog.CopybookPrintDialog;
import com.ibm.etools.fm.ui.history.action.CopybookPrintActionItem;
import com.ibm.etools.fm.ui.views.systems.FMTreeContentHolder;
import com.ibm.etools.fm.ui.wizards.FMWizardResultHelper;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.util.PDUtils;
import com.ibm.pdtools.common.component.jhost.core.model.IPDConnectEndpoint;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.IZRL;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import com.ibm.pdtools.common.component.ui.views.systems.handlers.PDTreeHandlerUtil;
import com.ibm.pdtools.common.component.ui.views.systems.handlers.SkeletonHandler;
import java.text.MessageFormat;
import java.util.Objects;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.prefs.Preferences;

public class CopybookPrint
extends SkeletonHandler {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2023. All rights reserved.";

    protected void handle(ExecutionEvent event) throws ExecutionException {
        Object selected = PDTreeHandlerUtil.getFirstSelectedDataObject((ExecutionEvent)event);
        IPDHost system = PDTreeHandlerUtil.getSystemFrom((Object)selected);
        if (system == null) {
            return;
        }
        IZRL resource = null;
        if (selected instanceof IZRL) {
            resource = (IZRL)selected;
        }
        CopybookPrint.showCopybookViewPrintDialog(system, resource);
    }

    public static void showCopybookViewPrintDialog(IPDHost system, IZRL resource) {
        Objects.requireNonNull(system, "Must specify a non-null system.");
        if (resource != null && !resource.getSystem().equals(system)) {
            throw new IllegalArgumentException();
        }
        Shell activeShell = Display.getCurrent().getActiveShell();
        CopybookPrintDialog dialog = new CopybookPrintDialog(activeShell, system, resource);
        if (dialog.open() != 0) {
            PDLogger.get(CopybookPrint.class).trace((Object)"Cancel CopybookPrintDialog.");
            return;
        }
        CopybookPrint.invokeCopybookViewPrint(system, dialog.getCopybookPrintOptions(), null);
    }

    public static void invokeCopybookViewPrint(final IPDHost system, final CopybookPrintOptions options, final CopybookPrintActionItem actionItem) {
        CopybookPrintActionItem actionItemToUse;
        Objects.requireNonNull(options, "Must specify a non-null options.");
        if (actionItem == null) {
            actionItemToUse = new CopybookPrintActionItem(options);
            FMTreeContentHolder.getInstance().getActionHistoryContent().getRegistry().add((Object)actionItemToUse);
        } else {
            actionItemToUse = actionItem;
        }
        Job job = new Job(Messages.CopybookPrinting){

            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask(Messages.CopybookPrinting, 4);
                PBK pbk = new PBK();
                pbk.setDsnIn(options.getResource().getFormattedName());
                pbk.setArray(options.getShowArrayElements());
                pbk.setHexLoc(options.getShowHexOffsets());
                pbk.setHexLen(options.getShowLengthInHex());
                pbk.setCriteria(options.getShowTemplateCriteria());
                IHowIsGoing howisgoing = PDUtils.convertIprogressToIHowIsGoing((IProgressMonitor)monitor);
                monitor.worked(1);
                try {
                    IEclipsePreferences systemOptsPrefs = InstanceScope.INSTANCE.getNode("com.ibm.etools.fm.ui.prefs.prtopts");
                    Preferences node = systemOptsPrefs.node(system.getDescription());
                    String pageSkipVal = node.get("pageskip", "YES");
                    String dumpVal = node.get("dump", "UPDOWN");
                    String dataHdrVal = node.get("datahdr", "YES");
                    String recLimitVal = node.get("reclimit", "(1,*)");
                    String printLenVal = node.get("reclength", "80");
                    String printTransVal = node.get("pagetrans", "ON");
                    String headerPagVal = node.get("headerpage", "YES");
                    SET set = new SET();
                    set.setPageSkip(pageSkipVal);
                    set.setPrintLen(Integer.parseInt(printLenVal));
                    set.setDumpVal(dumpVal);
                    set.setDataHdr(dataHdrVal);
                    set.setRecLimit(recLimitVal);
                    set.setPrintTrans(printTransVal);
                    set.setHeaderPage(headerPagVal);
                    Result result = UtilityFunctionRunner.execute((IPDHost)system, (IPDConnectEndpoint)FMHost.getSystem((IPDHost)system), (UtilityFunction)set, (IHowIsGoing)howisgoing);
                    if (result.getRC() != 0) {
                        if (actionItem == null) {
                            FMTreeContentHolder.getInstance().getActionHistoryContent().getRegistry().remove((Object)actionItemToUse);
                        }
                        String errMsg = MessageFormat.format(Messages.CopybookPrintFailedToSetPrintOptions, result.getRC());
                        return new Status(4, "com.ibm.etools.fm.ui", errMsg);
                    }
                    monitor.worked(1);
                    result = UtilityFunctionRunner.execute((IPDHost)system, (IPDConnectEndpoint)FMHost.getSystem((IPDHost)system), (UtilityFunction)pbk, (IHowIsGoing)howisgoing);
                    monitor.worked(1);
                    if (result.getRC() != 0) {
                        String errMsg = MessageFormat.format(Messages.CopybookPrintFailed, result.getRC());
                        return new Status(4, "com.ibm.etools.fm.ui", errMsg);
                    }
                    result.reformatOutput();
                    FMWizardResultHelper.displayResult((Result<StringBuffer>)result, Messages.CopybookPrintFailedToDisplayResult, howisgoing);
                    monitor.done();
                }
                catch (IllegalArgumentException | InterruptedException e) {
                    String errMsg = MessageFormat.format(Messages.CopybookPrintFailed, e.getMessage());
                    return new Status(4, "com.ibm.etools.fm.ui", errMsg, (Throwable)e);
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }
}

