/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.views.systems.handlers;

import com.ibm.etools.fm.core.model.DataSet;
import com.ibm.etools.fm.core.model.cics.CicsAppl;
import com.ibm.etools.fm.ui.views.systems.FMTreeContentHolder;
import com.ibm.etools.fm.ui.wizards.CopyActionItem;
import com.ibm.etools.fm.ui.wizards.CopyModel;
import com.ibm.etools.fm.ui.wizards.CopyWizard;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.IZRL;
import com.ibm.pdtools.common.component.ui.dialog.PDScrollableWizardDialog;
import com.ibm.pdtools.common.component.ui.views.systems.handlers.PDTreeHandlerUtil;
import com.ibm.pdtools.common.component.ui.views.systems.handlers.SkeletonHandler;
import java.util.List;
import java.util.Objects;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.wizard.IWizard;

public class Copy
extends SkeletonHandler {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2020. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";

    protected void handle(ExecutionEvent event) throws ExecutionException {
        IPDHost system;
        List selectedItems = PDTreeHandlerUtil.getSelectedDataObjects((ExecutionEvent)event);
        if (!selectedItems.isEmpty() && (system = PDTreeHandlerUtil.getSystemFrom(selectedItems.get(0))) != null) {
            CopyModel model = new CopyModel(system);
            boolean sourceGuessed = false;
            for (Object selected : selectedItems) {
                if (!(selected instanceof IZRL)) continue;
                IZRL resource = (IZRL)selected;
                if (!sourceGuessed) {
                    sourceGuessed = true;
                    if (selected instanceof CicsAppl) continue;
                    model.setSourceResource(resource);
                    if (!(resource instanceof DataSet)) continue;
                    model.setDestResource(resource.getFormattedName() + ".NEW");
                    continue;
                }
                if (selected instanceof CicsAppl) continue;
                model.setDestResource(resource.getFormattedName());
            }
            Copy.showCopyWizard(model);
        }
    }

    public static int showCopyWizard(CopyModel model) {
        Objects.requireNonNull(model, "Must specify a non-null model.");
        CopyWizard wizard = new CopyWizard(model);
        final CopyActionItem action = new CopyActionItem(model);
        wizard.getRunnable().addCallback(new Runnable(){

            @Override
            public void run() {
                FMTreeContentHolder.getInstance().getActionHistoryContent().getRegistry().add((Object)action);
            }
        });
        wizard.getRunnable().addCallback(action.getUpdateStateCallback(wizard.getRunnable()));
        return PDScrollableWizardDialog.openWizard((IWizard)wizard);
    }

    public static void showCopyWizard(IPDHost system, IZRL srcResource, IZRL destResource) {
        CopyModel model = new CopyModel(system);
        if (srcResource != null) {
            model.setSourceResource(srcResource);
            if (destResource != null && srcResource.getSystem().equals(destResource.getSystem())) {
                model.setDestResource(destResource.getFormattedName());
                model.setDestSystem(destResource.getSystem());
            }
        }
        Copy.showCopyWizard(model);
    }
}

