/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.views.systems.handlers;

import com.ibm.etools.fm.core.model.cics.CicsAppl;
import com.ibm.etools.fm.ui.history.IActionItem;
import com.ibm.etools.fm.ui.views.systems.FMTreeContentHolder;
import com.ibm.etools.fm.ui.views.systems.tree.action.LoadHostQueriesFromFile;
import com.ibm.etools.fm.ui.wizards.CompareActionItem;
import com.ibm.etools.fm.ui.wizards.CompareModel;
import com.ibm.etools.fm.ui.wizards.CompareWizard;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.IZRL;
import com.ibm.pdtools.common.component.ui.dialog.PDScrollableWizardDialog;
import com.ibm.pdtools.common.component.ui.views.systems.handlers.PDTreeHandlerUtil;
import com.ibm.pdtools.common.component.ui.views.systems.handlers.SkeletonHandler;
import java.io.File;
import java.util.List;
import java.util.Objects;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.wizard.IWizard;

public class Compare
extends SkeletonHandler {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2021. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";

    protected void handle(ExecutionEvent event) throws ExecutionException {
        List selectedItems = PDTreeHandlerUtil.getSelectedDataObjects((ExecutionEvent)event);
        IPDHost system = PDTreeHandlerUtil.getSystemFrom(selectedItems.get(0));
        if (system != null) {
            CompareModel temp;
            IActionItem action;
            CompareModel model = new CompareModel(system);
            File fromLocalFile = null;
            try {
                fromLocalFile = LoadHostQueriesFromFile.getCacheFile(system);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (fromLocalFile != null && (action = LoadHostQueriesFromFile.getActionItem(system, fromLocalFile)) instanceof CompareActionItem && (temp = ((CompareActionItem)action).getModel()) != null) {
                model = temp;
            }
            boolean oldGuessed = false;
            for (Object selected : selectedItems) {
                if (!(selected instanceof IZRL)) continue;
                IZRL resource = (IZRL)selected;
                if (!oldGuessed) {
                    oldGuessed = true;
                    if (selected instanceof CicsAppl) continue;
                    model.setOldResource(resource);
                    continue;
                }
                if (selected instanceof CicsAppl) continue;
                model.setNewResource(resource.getFormattedName());
            }
            Compare.showCompareWizard(model);
        }
    }

    public static void showCompareWizard(CompareModel model) {
        Objects.requireNonNull(model, "Must specify a non-null model.");
        CompareWizard wizard = new CompareWizard(model);
        final CompareActionItem action = new CompareActionItem(model);
        wizard.getRunnable().addCallback(new Runnable(){

            @Override
            public void run() {
                FMTreeContentHolder.getInstance().getActionHistoryContent().getRegistry().add((Object)action);
            }
        });
        wizard.getRunnable().addCallback(action.getUpdateStateCallback(wizard.getRunnable()));
        PDScrollableWizardDialog.openWizard((IWizard)wizard);
    }

    public static void showCompareWizard(IPDHost system, IZRL oldResource, IZRL newResource) {
        CompareModel model = new CompareModel(system);
        if (oldResource != null) {
            model.setOldResource(oldResource);
            if (newResource != null && newResource.getSystem().equals(oldResource.getSystem())) {
                model.setNewResource(newResource);
            }
        }
        Compare.showCompareWizard(model);
    }
}

