/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.views.systems.handlers;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.db2.Db2Subsystem;
import com.ibm.etools.fm.core.model.ims.ImsSubsystem;
import com.ibm.etools.fm.core.model.ims.ImsSubsystemConfig;
import com.ibm.etools.fm.core.socket.io.ConnPoolManagerFM;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.jhost.core.model.IPDConnectEndpoint;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.ui.util.PDDialogs;
import com.ibm.pdtools.common.component.ui.views.systems.handlers.PDTreeHandlerUtil;
import com.ibm.pdtools.common.component.ui.views.systems.handlers.SkeletonHandler;
import java.text.MessageFormat;
import java.util.Objects;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;

public class CloseConnections
extends SkeletonHandler {
    private static final PDLogger logger = PDLogger.get(CloseConnections.class);
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";

    protected void handle(ExecutionEvent event) throws ExecutionException {
        Object selected = PDTreeHandlerUtil.getFirstSelectedDataObject((ExecutionEvent)event);
        IPDHost system = PDTreeHandlerUtil.getSystemFrom((Object)selected);
        if (system == null) {
            return;
        }
        if (selected instanceof Db2Subsystem) {
            CloseConnections.closeConnectionsForEndpoint((IPDConnectEndpoint)((Db2Subsystem)selected));
        } else if (selected instanceof ImsSubsystem) {
            CloseConnections.closeConnectionsForEndpoint((IPDConnectEndpoint)((ImsSubsystem)selected));
        } else if (selected instanceof ImsSubsystemConfig) {
            CloseConnections.closeConnectionsForEndpoint((IPDConnectEndpoint)((ImsSubsystemConfig)selected).getSubsystem());
        } else {
            CloseConnections.closeConnections(system);
        }
    }

    public static boolean closeConnectionsForEndpoint(IPDConnectEndpoint endpoint) {
        Objects.requireNonNull(endpoint, "Must specify a non-null endpoint.");
        logger.trace((Object)MessageFormat.format("User opted to close connections for {0} endpoint {1}", endpoint.getComponentName(), endpoint));
        ConnPoolManagerFM connPoolManager = ConnPoolManagerFM.instance();
        if (connPoolManager.hasConnectionInUse(endpoint)) {
            logger.trace((Object)"Detected connection in use while trying to close connections; popping dialog to get user to confirm close");
            if (!PDDialogs.openQuestion((String)Messages.CommHost_RISK_DATA_LOSS_TITLE, (String)Messages.CommHost_WARN_UNEXPECTED_BEHAVIOUR_TEXT)) {
                return false;
            }
        }
        connPoolManager.closeAllConnectionsForEndpoint(endpoint);
        return true;
    }

    public static boolean closeConnections(IPDHost system) {
        Objects.requireNonNull(system, "Must specify a non-null IPDHost.");
        logger.trace((Object)("User opted to close connections for system " + system.getConnectionName()));
        ConnPoolManagerFM connPoolManager = ConnPoolManagerFM.instance();
        if (connPoolManager.hasConnectionInUse(system) && system.getDelegatingHost() == null) {
            logger.trace((Object)"Detected connection in use while trying to close connections; popping dialog to get user to confirm close");
            if (!PDDialogs.openQuestion((String)Messages.CommHost_RISK_DATA_LOSS_TITLE, (String)Messages.CommHost_WARN_UNEXPECTED_BEHAVIOUR_TEXT)) {
                return false;
            }
        }
        connPoolManager.closeAllConnections(system);
        return true;
    }
}

