/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.views.systems.handlers;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.DataSet;
import com.ibm.etools.fm.core.model.DataSetQuery;
import com.ibm.etools.fm.ui.history.ActionItem;
import com.ibm.etools.fm.ui.history.ActionType;
import com.ibm.etools.fm.ui.history.IActionItem;
import com.ibm.etools.fm.ui.views.systems.handlers.AlterDataSet;
import com.ibm.etools.fm.ui.views.systems.nodes.ActionItemNode;
import com.ibm.etools.fm.ui.views.systems.properties.DataSetPropertySource;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.util.HowIsGoing;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import com.ibm.pdtools.common.component.ui.views.systems.handlers.PDTreeHandlerUtil;
import java.util.List;
import java.util.Objects;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.properties.IPropertySource;

public class AlterDataSetActionItem
extends ActionItem {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2021. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private String dataSetName;
    private static final String KEY_DATASET_NAME = "dataSetName";

    protected AlterDataSetActionItem(ActionType actionType, IPDHost provider) {
        super(actionType, provider);
    }

    @Override
    public void execute() {
    }

    @Override
    public void modify() {
        ISelection selection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getSelection();
        if (selection != null && selection instanceof StructuredSelection) {
            StructuredSelection structuredSel = (StructuredSelection)selection;
            Object object = structuredSel.getFirstElement();
            IPDHost host = PDTreeHandlerUtil.getSystemFrom((Object)object);
            AlterDataSet alterDs = new AlterDataSet();
            alterDs.setActionItemToUse((AlterDataSetActionItem)((ActionItemNode)((Object)object)).getDataObject());
            alterDs.showAlterDataSetWizard(host);
        }
    }

    @Override
    public void saveTo(IMemento memento) {
        memento.putString(KEY_DATASET_NAME, this.dataSetName);
    }

    @Override
    public String getDefaultLabel() {
        return Messages.ActionHistoryFactory_ALTER_DATA_SET + "(" + this.dataSetName + ")";
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof AlterDataSetActionItem) {
            AlterDataSetActionItem action = (AlterDataSetActionItem)other;
            return this.dataSetName.equals(action.dataSetName);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return 0;
    }

    public static IActionItem loadFrom(IMemento memento, IPDHost system) {
        Objects.requireNonNull(memento, "Must specify a non-null memento.");
        String dsName = memento.getString(KEY_DATASET_NAME);
        AlterDataSetActionItem actionItem = new AlterDataSetActionItem(ActionType.ALTER_DS, system);
        actionItem.setDataSetName(dsName);
        return actionItem;
    }

    @Override
    public ActionItem clone() {
        AlterDataSetActionItem clone = new AlterDataSetActionItem(this.getActionType(), this.getSystem());
        this.syncState(clone);
        return clone;
    }

    public void setDataSetName(String dataSetName) {
        this.dataSetName = dataSetName;
    }

    public String getDataSetName() {
        return this.dataSetName;
    }

    @Override
    public IPropertySource getPropertySource() {
        DataSetQuery query = DataSetQuery.create((IPDHost)this.getSystem(), (String)this.dataSetName);
        try {
            query.loadDataSets((IHowIsGoing)new HowIsGoing((Object)new NullProgressMonitor()));
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        List dataSets = query.getDataSets();
        DataSet ds = null;
        if (dataSets.size() > 0) {
            int i = 0;
            while (i < dataSets.size()) {
                DataSet dataSet = (DataSet)dataSets.get(i);
                if (dataSet.getName().equalsIgnoreCase(this.dataSetName)) {
                    ds = dataSet;
                    break;
                }
                ++i;
            }
        }
        return new DataSetPropertySource(ds);
    }
}

