/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.views.systems.handlers;

import com.ibm.etools.fm.ui.history.ActionType;
import com.ibm.etools.fm.ui.views.systems.FMTreeContentHolder;
import com.ibm.etools.fm.ui.views.systems.handlers.AlterDataSetActionItem;
import com.ibm.etools.fm.ui.wizards.AlterDataSetWizard;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.ui.views.systems.handlers.PDTreeHandlerUtil;
import com.ibm.pdtools.common.component.ui.views.systems.handlers.SkeletonHandler;
import java.util.Objects;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ui.PlatformUI;

public class AlterDataSet
extends SkeletonHandler {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2021. All rights reserved.";
    private AlterDataSetActionItem actionItemToUse;

    protected void handle(ExecutionEvent event) throws ExecutionException {
        Object selected = PDTreeHandlerUtil.getFirstSelectedDataObject((ExecutionEvent)event);
        IPDHost system = PDTreeHandlerUtil.getSystemFrom((Object)selected);
        if (system != null) {
            this.showAlterDataSetWizard(system);
        }
    }

    public void showAlterDataSetWizard(IPDHost system) {
        Objects.requireNonNull(system, "Must provide a non-null system.");
        AlterDataSetWizard alterDataSetWizard = new AlterDataSetWizard(system);
        WizardDialog dialog = new WizardDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)alterDataSetWizard);
        dialog.setHelpAvailable(false);
        if (dialog.open() == 0) {
            if (this.actionItemToUse == null) {
                AlterDataSetActionItem item = new AlterDataSetActionItem(ActionType.ALTER_DS, system);
                item.setDataSetName(alterDataSetWizard.getCachedDsName());
                FMTreeContentHolder.getInstance().getActionHistoryContent().getRegistry().add((Object)item);
            } else {
                AlterDataSetActionItem item = this.actionItemToUse;
                item.setDataSetName(alterDataSetWizard.getCachedDsName());
            }
        }
    }

    public void setActionItemToUse(AlterDataSetActionItem actionItemToUse) {
        this.actionItemToUse = actionItemToUse;
    }
}

