/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.views.systems.handlers;

import com.ibm.etools.fm.core.model.UssFile;
import com.ibm.etools.fm.core.model.UssFileQuery;
import com.ibm.etools.fm.core.model.UssFileType;
import com.ibm.etools.fm.ui.views.systems.FMTreeContentHolder;
import com.ibm.etools.fm.ui.wizards.AllocateHFSActionItem;
import com.ibm.etools.fm.ui.wizards.AllocateHFSModel;
import com.ibm.etools.fm.ui.wizards.AllocateHFSWizard;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.util.StringUtils;
import com.ibm.pdtools.common.component.ui.dialog.PDScrollableWizardDialog;
import com.ibm.pdtools.common.component.ui.views.systems.handlers.PDTreeHandlerUtil;
import com.ibm.pdtools.common.component.ui.views.systems.handlers.SkeletonHandler;
import java.util.Objects;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.wizard.IWizard;

public class AllocateHFSFile
extends SkeletonHandler {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";

    protected void handle(ExecutionEvent event) throws ExecutionException {
        Object selected = PDTreeHandlerUtil.getFirstSelectedDataObject((ExecutionEvent)event);
        IPDHost system = PDTreeHandlerUtil.getSystemFrom((Object)selected);
        if (system == null) {
            return;
        }
        Object newFileName = null;
        if (selected instanceof UssFile) {
            UssFile file = (UssFile)selected;
            newFileName = file.getType() == UssFileType.Dir ? file.getFormattedName() + "new" : file.getFormattedName() + "_new";
        } else if (selected instanceof UssFileQuery) {
            newFileName = ((UssFileQuery)selected).getQuery().replaceAll(StringUtils.escapeRegex((String)"*"), "new");
            newFileName = ((String)newFileName).replaceAll(StringUtils.escapeRegex((String)"%"), "");
        }
        AllocateHFSFile.showAllocateHFSFileWizard(system, newFileName);
    }

    public static boolean showAllocateHFSFileWizard(IPDHost system, String newFileName) {
        AllocateHFSModel model = new AllocateHFSModel(Objects.requireNonNull(system, "Must provide a non-null system."), newFileName);
        AllocateHFSWizard wizard = new AllocateHFSWizard(model);
        final AllocateHFSActionItem action = new AllocateHFSActionItem(model);
        wizard.getRunnable().addCallback(new Runnable(){

            @Override
            public void run() {
                FMTreeContentHolder.getInstance().getActionHistoryContent().getRegistry().add((Object)action);
            }
        });
        wizard.getRunnable().addCallback(action.getUpdateStateCallback(wizard.getRunnable()));
        return PDScrollableWizardDialog.openWizard((IWizard)wizard) == 0 && wizard.getRunnable().isCompletedSuccessfully();
    }
}

