/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.views.systems.handlers;

import com.ibm.etools.fm.core.model.DataSet;
import com.ibm.etools.fm.core.model.DataSetOrMember;
import com.ibm.etools.fm.core.model.DataSetQuery;
import com.ibm.etools.fm.ui.util.ZrlLoaderDialogUtils;
import com.ibm.etools.fm.ui.views.systems.FMTreeContentHolder;
import com.ibm.etools.fm.ui.wizards.AllocateDataSetActionItem;
import com.ibm.etools.fm.ui.wizards.AllocateDataSetModel;
import com.ibm.etools.fm.ui.wizards.AllocateDataSetWizard;
import com.ibm.pdtools.common.component.jhost.core.model.IHostProvider;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.util.ArrayUtils;
import com.ibm.pdtools.common.component.ui.dialog.PDScrollableWizardDialog;
import com.ibm.pdtools.common.component.ui.views.systems.handlers.PDTreeHandlerUtil;
import com.ibm.pdtools.common.component.ui.views.systems.handlers.SkeletonHandler;
import java.util.Objects;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.wizard.IWizard;

public class AllocateDataSet
extends SkeletonHandler {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";

    protected void handle(ExecutionEvent event) throws ExecutionException {
        Object selected = PDTreeHandlerUtil.getFirstSelectedDataObject((ExecutionEvent)event);
        IPDHost system = PDTreeHandlerUtil.getSystemFrom((Object)selected);
        if (system != null) {
            AllocateDataSet.showAllocateDataSetWizard(system, selected);
        }
    }

    public static void showAllocateDataSetWizard(IPDHost system, Object allocateLike) {
        Object[] qualifiers;
        Objects.requireNonNull(system, "Must provide a non-null system.");
        if (allocateLike != null && allocateLike instanceof IHostProvider && !((IHostProvider)allocateLike).getSystem().equals(system)) {
            throw new IllegalArgumentException();
        }
        AllocateDataSetModel allocateParams = new AllocateDataSetModel();
        if (allocateLike instanceof DataSetOrMember) {
            DataSet dataSet = ((DataSetOrMember)allocateLike).asDataSet();
            if (dataSet.getProperties() == null || dataSet.getProperties().getPropertyCount() == 0) {
                try {
                    ZrlLoaderDialogUtils.refreshDataSetProperties((DataSetOrMember)dataSet);
                }
                catch (InterruptedException e) {
                    return;
                }
            }
            allocateParams.setAllocateLike(dataSet);
            allocateParams.setAllocateLikeSystem(dataSet.getSystem());
            allocateParams.setDataSetName(dataSet.getFormattedName() + ".NEW");
        } else if (allocateLike instanceof DataSetQuery && (qualifiers = ((DataSetQuery)allocateLike).getQualifiers()).length > 1) {
            int i = 0;
            while (i < qualifiers.length) {
                qualifiers[i] = qualifiers[i].replaceAll("\\*", "").replaceAll("%", "");
                ++i;
            }
            allocateParams.setDataSetName(String.valueOf(ArrayUtils.join((Object[])ArrayUtils.slice((Object[])qualifiers, (int)(qualifiers.length - 1)), (String)".")) + ".NEW");
        }
        allocateParams.setHost(system);
        AllocateDataSetWizard wizard = AllocateDataSetWizard.create(allocateParams);
        final AllocateDataSetActionItem action = new AllocateDataSetActionItem(allocateParams, system);
        wizard.getRunnable().addCallback(new Runnable(){

            @Override
            public void run() {
                FMTreeContentHolder.getInstance().getActionHistoryContent().getRegistry().add((Object)action);
            }
        });
        wizard.getRunnable().addCallback(action.getUpdateStateCallback(wizard.getRunnable()));
        PDScrollableWizardDialog.openWizard((IWizard)wizard);
    }
}

