/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.views.systems.handlers;

import com.ibm.etools.fm.core.model.ims.ImsAccessMode;
import com.ibm.etools.fm.core.model.ims.ImsDatabase;
import com.ibm.etools.fm.core.model.ims.ImsDatabaseQuery;
import com.ibm.etools.fm.core.model.ims.ImsPsb;
import com.ibm.etools.fm.core.model.ims.ImsPsbQuery;
import com.ibm.etools.fm.core.model.ims.ImsQuery;
import com.ibm.etools.fm.core.model.ims.ImsRegionConfig;
import com.ibm.etools.fm.core.model.ims.ImsRegionSpecificQuery;
import com.ibm.etools.fm.core.model.ims.ImsSubsystem;
import com.ibm.etools.fm.core.model.ims.ImsSubsystemConfig;
import com.ibm.etools.fm.core.model.ims.ImsSubsystemProvider;
import com.ibm.etools.fm.ui.dialog.ImsQueryDialogModel;
import com.ibm.etools.fm.ui.dialog.ImsQueryWizard;
import com.ibm.etools.fm.ui.dialog.lookup.ImsSubsystemLookupDialog;
import com.ibm.etools.fm.ui.views.systems.FMTreeContentHolder;
import com.ibm.etools.fm.ui.views.systems.model.ImsTreeContent;
import com.ibm.etools.fm.ui.views.systems.nodes.ImsDatabaseQueryNode;
import com.ibm.etools.fm.ui.views.systems.nodes.ImsPsbQueryNode;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.ui.views.systems.handlers.PDTreeHandlerUtil;
import com.ibm.pdtools.common.component.ui.views.systems.handlers.SkeletonHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;

public class AddQueryIms
extends SkeletonHandler {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2021. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";

    protected void handle(ExecutionEvent event) throws ExecutionException {
        Object selected = PDTreeHandlerUtil.getFirstSelectedDataObject((ExecutionEvent)event);
        IPDHost system = PDTreeHandlerUtil.getSystemFrom((Object)selected);
        ImsRegionSpecificQuery aQuery = AddQueryIms.doOpen(selected, system, false);
        ImsTreeContent imsContent = FMTreeContentHolder.getInstance().getImsContent();
        if (aQuery instanceof ImsPsbQuery) {
            imsContent.getPsbQueries().findOrAdd((Object)((ImsPsbQuery)aQuery));
            PDTreeHandlerUtil.getActiveSystemsViewChecked((ExecutionEvent)event).expandAndSelect((Object)aQuery, ImsPsbQueryNode.class);
        } else if (aQuery instanceof ImsDatabaseQuery) {
            imsContent.getDatabaseQueries().findOrAdd((Object)((ImsDatabaseQuery)aQuery));
            PDTreeHandlerUtil.getActiveSystemsViewChecked((ExecutionEvent)event).expandAndSelect((Object)aQuery, ImsDatabaseQueryNode.class);
        }
    }

    public static ImsRegionSpecificQuery doOpen(Object selected, IPDHost system, boolean modify) {
        if (system == null) {
            return null;
        }
        ImsQueryDialogModel model = new ImsQueryDialogModel(system, modify);
        if (selected instanceof ImsSubsystem) {
            ImsSubsystem subsystem = (ImsSubsystem)selected;
            model.setSubsystemConfig(subsystem.getCanonicalConfig());
        } else if (selected instanceof ImsSubsystemConfig && ((ImsSubsystemConfig)selected).isConnectable()) {
            model.setSubsystemConfig(((ImsSubsystemConfig)selected).getSubsystem().getCanonicalConfig());
        } else if (selected instanceof ImsRegionConfig) {
            ImsRegionConfig regionConfig = (ImsRegionConfig)selected;
            model.setSubsystemConfig(regionConfig.getSubsystemConfig().getSubsystem().getCanonicalConfig());
        } else if (selected instanceof ImsRegionSpecificQuery) {
            ImsRegionSpecificQuery query = (ImsRegionSpecificQuery)selected;
            ImsSubsystemConfig config = query.getSubsystem().getCanonicalConfig();
            model.setSubsystemConfig(config);
            if (query instanceof ImsQuery) {
                model.setRegionType(((ImsQuery)query).getRegionType());
            }
            model.setAccessMode(query);
            model.setPattern(query.getPattern());
        } else if (selected instanceof ImsDatabase) {
            ImsDatabase db = (ImsDatabase)selected;
            ImsSubsystemConfig config = db.getSubsystem().getCanonicalConfig();
            model.setSubsystemConfig(config);
            model.setRegionType(config);
            model.setAccessMode(ImsAccessMode.DYNAMIC);
            model.setPattern(db.getName());
        } else if (selected instanceof ImsPsb) {
            ImsPsb psb = (ImsPsb)selected;
            ImsSubsystemConfig config = psb.getSubsystem().getCanonicalConfig();
            model.setSubsystemConfig(config);
            model.setRegionType(config);
            model.setAccessMode(ImsAccessMode.STATIC);
            model.setPattern(psb.getName());
        } else if (selected instanceof ImsSubsystemProvider) {
            model.setSubsystemConfig(((ImsSubsystemProvider)selected).getSubsystem().getCanonicalConfig());
        } else {
            ImsSubsystemConfig config = ImsSubsystemLookupDialog.promptForValidConfig(system, null);
            if (config == null) {
                return null;
            }
            model.setSubsystemConfig(config);
        }
        if (model.getPattern().isEmpty()) {
            model.setPattern("*");
        }
        if (ImsQueryWizard.open(model) != 0) {
            return null;
        }
        return model.getQuery();
    }
}

