/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.views.systems.handlers;

import com.ibm.etools.fm.core.model.db2.Db2Database;
import com.ibm.etools.fm.core.model.db2.Db2ObjectQuery;
import com.ibm.etools.fm.core.model.db2.Db2Subsystem;
import com.ibm.etools.fm.core.model.db2.Db2Table;
import com.ibm.etools.fm.ui.dialog.Db2ObjectQueryDialog;
import com.ibm.etools.fm.ui.views.systems.FMTreeContentHolder;
import com.ibm.etools.fm.ui.views.systems.nodes.Db2ObjectQueryNode;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.ui.views.systems.handlers.PDTreeHandlerUtil;
import com.ibm.pdtools.common.component.ui.views.systems.handlers.SkeletonHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;

public class AddQueryDb2
extends SkeletonHandler {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2021. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";

    protected void handle(ExecutionEvent event) throws ExecutionException {
        IPDHost system;
        Object selected = PDTreeHandlerUtil.getFirstSelectedDataObject((ExecutionEvent)event);
        Db2ObjectQuery<?> aQuery = AddQueryDb2.doOpen(selected, system = PDTreeHandlerUtil.getSystemFrom((Object)selected), false);
        if (aQuery != null) {
            FMTreeContentHolder.getInstance().getDb2Content().getObjectQueryRegistry().findOrAdd(aQuery);
            PDTreeHandlerUtil.getActiveSystemsViewChecked((ExecutionEvent)event).expandAndSelect(aQuery, Db2ObjectQueryNode.class);
        }
    }

    public static Db2ObjectQuery<?> doOpen(Object selected, IPDHost system, boolean modify) {
        if (system == null) {
            return null;
        }
        Class typeHint = Db2Table.class;
        Db2Subsystem initialDb2Subsystem = null;
        String initialOwnerPattern = null;
        String initialNamePattern = null;
        String initialDatabasePattern = null;
        if (selected instanceof Db2Subsystem) {
            initialDb2Subsystem = (Db2Subsystem)selected;
        } else if (selected instanceof Db2Database) {
            typeHint = Db2Database.class;
            Db2Database db = (Db2Database)selected;
            initialDb2Subsystem = db.getSubsystem();
            initialOwnerPattern = db.getCreator();
            initialNamePattern = db.getName();
        } else if (selected instanceof Db2Table) {
            typeHint = Db2Table.class;
            Db2Table table = (Db2Table)selected;
            initialDb2Subsystem = table.getSubsystem();
            initialOwnerPattern = table.getOwner();
            initialNamePattern = table.getName();
            initialDatabasePattern = table.getDatabaseName();
        } else if (selected instanceof Db2ObjectQuery) {
            Db2ObjectQuery query = (Db2ObjectQuery)selected;
            typeHint = query.getType();
            initialDb2Subsystem = query.getSubsystem();
            initialOwnerPattern = query.getOwnerPattern();
            initialNamePattern = query.getNamePattern();
            initialDatabasePattern = query.getDatabasePattern();
        }
        Db2ObjectQueryDialog dialog = new Db2ObjectQueryDialog(system, modify);
        dialog.setInitialDb2Subsystem(initialDb2Subsystem);
        dialog.setInitialOwnerPattern(initialOwnerPattern);
        dialog.setInitialNamePattern(initialNamePattern);
        dialog.setInitialDatabasePattern(initialDatabasePattern);
        dialog.setInitialObjectType(typeHint);
        if (dialog.open() != 0) {
            return null;
        }
        return dialog.getQuery();
    }
}

