/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.views.systems.handlers;

import com.ibm.etools.fm.core.model.cics.CicsAppl;
import com.ibm.etools.fm.core.model.cics.CicsResource;
import com.ibm.etools.fm.core.model.cics.CicsResourceQuery;
import com.ibm.etools.fm.ui.dialog.CicsResourceQueryDialog;
import com.ibm.etools.fm.ui.views.systems.FMTreeContentHolder;
import com.ibm.etools.fm.ui.views.systems.nodes.CicsResourceQueryNode;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.ui.views.systems.handlers.PDTreeHandlerUtil;
import com.ibm.pdtools.common.component.ui.views.systems.handlers.SkeletonHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;

public class AddQueryCics
extends SkeletonHandler {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2021. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";

    protected void handle(ExecutionEvent event) throws ExecutionException {
        IPDHost system;
        Object selected = PDTreeHandlerUtil.getFirstSelectedDataObject((ExecutionEvent)event);
        CicsResourceQuery<?> aQuery = AddQueryCics.doOpen(selected, system = PDTreeHandlerUtil.getSystemFrom((Object)selected), false);
        if (aQuery != null) {
            FMTreeContentHolder.getInstance().getCicsContent().getResourceQueryRegistry().findOrAdd(aQuery);
            PDTreeHandlerUtil.getActiveSystemsViewChecked((ExecutionEvent)event).expandAndSelect(aQuery, CicsResourceQueryNode.class);
        }
    }

    public static CicsResourceQuery<?> doOpen(Object selected, IPDHost system, boolean modify) {
        if (system == null) {
            return null;
        }
        CicsAppl initialCicsAppl = null;
        CicsResourceQueryDialog.CICS_RESOURCE_TYPE initialResourceType = CicsResourceQueryDialog.CICS_RESOURCE_TYPE.fromResourceOrQuery(selected);
        String initialQuery = null;
        if (selected instanceof CicsAppl) {
            initialCicsAppl = (CicsAppl)selected;
        } else if (selected instanceof CicsResource) {
            CicsResource cicsResource = (CicsResource)selected;
            initialCicsAppl = cicsResource.getCICSAppl();
            initialQuery = cicsResource.getName();
        } else if (selected instanceof CicsResourceQuery) {
            CicsResourceQuery query = (CicsResourceQuery)selected;
            initialCicsAppl = query.getCICSAppl();
            initialQuery = query.getQuery();
        }
        CicsResourceQueryDialog dialog = new CicsResourceQueryDialog(system, modify);
        dialog.setInitialCICSAppl(initialCicsAppl);
        dialog.setInitialResourceType(initialResourceType);
        dialog.setInitialQuery(initialQuery);
        if (dialog.open() != 0) {
            return null;
        }
        return dialog.getQuery();
    }
}

