/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.views.systems;

import com.ibm.etools.fm.core.model.DataSet;
import com.ibm.etools.fm.core.model.HostVersion;
import com.ibm.etools.fm.core.model.Member;
import com.ibm.etools.fm.core.model.UssFile;
import com.ibm.etools.fm.core.model.db2.Db2Subsystem;
import com.ibm.etools.fm.core.model.db2.Db2SubsystemProvider;
import com.ibm.etools.fm.core.model.db2.Db2Table;
import com.ibm.etools.fm.core.model.ims.ImsDatabase;
import com.ibm.etools.fm.core.model.ims.ImsDatabaseQuery;
import com.ibm.etools.fm.core.model.ims.ImsPsb;
import com.ibm.etools.fm.core.model.ims.ImsPsbQuery;
import com.ibm.etools.fm.core.model.ims.ImsRegionType;
import com.ibm.etools.fm.core.model.ims.ImsSubsystem;
import com.ibm.etools.fm.core.model.ims.ImsSubsystemConfig;
import com.ibm.etools.fm.jhost.core.version.FMFeature;
import com.ibm.etools.fm.ui.history.IActionItem;
import com.ibm.etools.fm.ui.views.systems.nodes.ActionItemNode;
import com.ibm.etools.fm.ui.views.systems.nodes.DataSetNode;
import com.ibm.etools.fm.ui.views.systems.nodes.Db2SubsystemNode;
import com.ibm.etools.fm.ui.views.systems.nodes.Db2TableNode;
import com.ibm.etools.fm.ui.views.systems.nodes.ImsDatabaseNode;
import com.ibm.etools.fm.ui.views.systems.nodes.ImsDatabaseQueryNode;
import com.ibm.etools.fm.ui.views.systems.nodes.ImsPsbNode;
import com.ibm.etools.fm.ui.views.systems.nodes.ImsPsbQueryNode;
import com.ibm.etools.fm.ui.views.systems.nodes.ImsRootNode;
import com.ibm.etools.fm.ui.views.systems.nodes.ImsSubsystemConfigNode;
import com.ibm.etools.fm.ui.views.systems.nodes.ImsSubsystemNode;
import com.ibm.etools.fm.ui.views.systems.nodes.MemberNode;
import com.ibm.etools.fm.ui.views.systems.nodes.UssFileNode;
import com.ibm.pdtools.common.component.core.model.PDPlatformObject;
import com.ibm.pdtools.common.component.jhost.comms.HostType;
import com.ibm.pdtools.common.component.jhost.core.model.IHostProvider;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.version.PDFeature;
import com.ibm.pdtools.common.component.ui.views.systems.handlers.PDTreeHandlerUtil;
import com.ibm.pdtools.common.component.ui.views.systems.nodes.SystemsDataNode;
import com.ibm.pdtools.common.component.ui.views.systems.nodes.SystemsTreeNode;
import java.util.Iterator;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeSelection;

public class SystemsViewPropertyTester
extends PropertyTester {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2021. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    public static final String NAMESPACE = "com.ibm.etools.fm.ui.tree";
    public static final String PROPERTY_USS_FILE_TYPE = "isUssFileType";
    public static final String PROPERTY_DATA_SET_TYPE = "isDataSetType";
    public static final String PROPERTY_FAVORITE_ACTION_ITEM = "favoriteActionItem";
    public static final String PROPERTY_CAN_MODIFY_ACTION_ITEM = "canModifyActionItem";
    public static final String PROPERTY_CAN_EXECUTE_ACTION_ITEM = "canExecuteActionItem";
    public static final String PROPERTY_CONNECTABLE_DB2_SUBSYSTEM = "connectableDb2Subsystem";
    public static final String PROPERTY_IMS_EDIT_SUPPORTED = "imsEditSupported";
    public static final String PROPERTY_CONNECTABLE_IMS_SUBSYSTEM_COMPONENT = "connectableImsSubsystemComponent";
    public static final String PROPERTY_USS_TEMPLATE_ALLOWED = "ussTemplateAllowed";
    public static final String PROPERTY_TEMPLATE_LOCK = "lockTemplate";
    public static final String PROPERTY_TEMPLATE_UNLOCK = "unlockTemplate";
    public static final String PROPERTY_TEMPLATE_LEAD_ZEROS_ON = "leadZeroOn";
    public static final String PROPERTY_TEMPLATE_LEAD_ZEROS_OFF = "leadZeroOff";
    public static final String PROPERTY_IS_DB2_TABLE_TYPE = "isDb2TableType";
    public static final String PROPERTY_FROM_SAME_ENDPOINT = "fromSameEndpoint";
    public static final String PROPERTY_IS_ZOS_SYSTEM = "isZosSystem";
    public static final String PROPERTY_IS_LOCAL_HOST_SYSTEM = "isLocalSystem";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if (PROPERTY_USS_FILE_TYPE.equals(property)) {
            return SystemsViewPropertyTester.isUssFileType(receiver, args);
        }
        if (PROPERTY_DATA_SET_TYPE.equals(property)) {
            return SystemsViewPropertyTester.isDataSetType(receiver, args);
        }
        if (PROPERTY_CONNECTABLE_DB2_SUBSYSTEM.equals(property)) {
            return SystemsViewPropertyTester.connectableDb2Subsystem(receiver);
        }
        if (PROPERTY_IMS_EDIT_SUPPORTED.equals(property)) {
            return SystemsViewPropertyTester.imsEditSupported(receiver);
        }
        if (PROPERTY_CONNECTABLE_IMS_SUBSYSTEM_COMPONENT.equals(property)) {
            return SystemsViewPropertyTester.connectableImsSubsystemComponent(receiver);
        }
        if (PROPERTY_FROM_SAME_ENDPOINT.equals(property)) {
            return SystemsViewPropertyTester.fromSameEndpoint(receiver);
        }
        if (PROPERTY_FAVORITE_ACTION_ITEM.equals(property)) {
            return SystemsViewPropertyTester.favoriteActionItem(receiver);
        }
        if (PROPERTY_CAN_MODIFY_ACTION_ITEM.equals(property)) {
            return SystemsViewPropertyTester.canModifyActionItem(receiver);
        }
        if (PROPERTY_CAN_EXECUTE_ACTION_ITEM.equals(property)) {
            return SystemsViewPropertyTester.canExecuteActionItem(receiver);
        }
        if (PROPERTY_USS_TEMPLATE_ALLOWED.equals(property)) {
            return SystemsViewPropertyTester.ussTemplateAllowed(receiver, args);
        }
        if (PROPERTY_IS_DB2_TABLE_TYPE.equals(property)) {
            return SystemsViewPropertyTester.isDb2TableType(receiver, args);
        }
        if (PROPERTY_IS_ZOS_SYSTEM.equals(property)) {
            return SystemsViewPropertyTester.isZosSystem(receiver);
        }
        if (PROPERTY_IS_LOCAL_HOST_SYSTEM.equals(property)) {
            return SystemsViewPropertyTester.isLocalSystem(receiver);
        }
        if (PROPERTY_TEMPLATE_LOCK.equals(property)) {
            return SystemsViewPropertyTester.lockTemplate(receiver);
        }
        if (PROPERTY_TEMPLATE_UNLOCK.equals(property)) {
            return SystemsViewPropertyTester.unlockTemplate(receiver);
        }
        if (PROPERTY_TEMPLATE_LEAD_ZEROS_ON.equals(property)) {
            return SystemsViewPropertyTester.leadZeroOn(receiver);
        }
        if (PROPERTY_TEMPLATE_LEAD_ZEROS_OFF.equals(property)) {
            return SystemsViewPropertyTester.leadZeroOff(receiver);
        }
        return false;
    }

    private static boolean ussTemplateAllowed(Object receiver, Object[] args) {
        if (receiver instanceof TreeSelection) {
            receiver = ((TreeSelection)receiver).getFirstElement();
        }
        if (!(receiver instanceof SystemsTreeNode)) {
            return false;
        }
        SystemsTreeNode stn = (SystemsTreeNode)receiver;
        if (!(stn.getDataObject() instanceof IHostProvider)) {
            return false;
        }
        IPDHost host = ((IHostProvider)stn.getDataObject()).getSystem();
        if (host.getHostType() == HostType.ZOS) {
            return !(receiver instanceof UssFileNode);
        }
        if (receiver instanceof UssFileNode) {
            UssFileNode aFile = (UssFileNode)((Object)receiver);
            if (args.length == 0) {
                if (((UssFile)aFile.getDataObject()).isDirectory()) {
                    return false;
                }
            } else {
                if (Boolean.TRUE.toString().equalsIgnoreCase(args[0].toString())) {
                    return true;
                }
                if (((UssFile)aFile.getDataObject()).isDirectory()) {
                    return false;
                }
            }
        }
        return true;
    }

    private static boolean isUssFileType(Object receiver, Object[] types) {
        if (!(receiver instanceof UssFileNode)) {
            return false;
        }
        UssFileNode node = (UssFileNode)((Object)receiver);
        UssFile file = (UssFile)node.getDataObject();
        String type = file.getType().toString().toLowerCase();
        Object[] objectArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (object.toString().toLowerCase().equals(type)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static boolean isDataSetType(Object receiver, Object[] types) {
        if (!(receiver instanceof DataSetNode)) {
            return false;
        }
        DataSetNode node = (DataSetNode)((Object)receiver);
        DataSet dataSet = (DataSet)node.getDataObject();
        String type = dataSet.getType().toString().toLowerCase();
        Object[] objectArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (object.toString().toLowerCase().equals(type)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static boolean connectableDb2Subsystem(Object receiver) {
        if (!(receiver instanceof Db2SubsystemNode)) {
            return false;
        }
        Db2SubsystemNode subSysNode = (Db2SubsystemNode)((Object)receiver);
        return ((Db2Subsystem)subSysNode.getDataObject()).getCanConnect();
    }

    private static boolean imsEditSupported(Object receiver) {
        IPDHost pdHost = null;
        if (receiver instanceof SystemsDataNode) {
            Object dataObj = ((SystemsDataNode)receiver).getDataObject();
            if (dataObj instanceof PDPlatformObject) {
                pdHost = ((PDPlatformObject)dataObj).getSystem();
            }
        } else if (receiver instanceof ImsRootNode) {
            pdHost = ((ImsRootNode)((Object)receiver)).getSystem();
        }
        if (pdHost != null) {
            if (!pdHost.isAparInfoLoaded()) {
                return true;
            }
            return pdHost.supports((PDFeature)FMFeature.IMS_EDIT);
        }
        return false;
    }

    private static boolean connectableImsSubsystemComponent(Object receiver) {
        if (receiver instanceof ImsSubsystemNode) {
            return ((ImsSubsystem)((ImsSubsystemNode)((Object)receiver)).getDataObject()).getCanonicalConfig().isConnectable();
        }
        if (receiver instanceof ImsSubsystemConfigNode) {
            return ((ImsSubsystemConfig)((ImsSubsystemConfigNode)((Object)receiver)).getDataObject()).getSubsystem().getCanonicalConfig().isConnectable();
        }
        if (receiver instanceof ImsPsbQueryNode) {
            ImsPsbQueryNode imsPsbBrowseNode = (ImsPsbQueryNode)((Object)receiver);
            ImsPsbQuery psbQuery = (ImsPsbQuery)imsPsbBrowseNode.getDataObject();
            ImsSubsystemConfig imsConfig = psbQuery.getSubsystem().getCanonicalConfig();
            return imsConfig.isStaticAccessSupported(ImsRegionType.BMP) || imsConfig.isStaticAccessSupported(ImsRegionType.DLI);
        }
        if (receiver instanceof ImsPsbNode) {
            ImsPsbNode imsPsbNode = (ImsPsbNode)((Object)receiver);
            ImsSubsystemConfig imsConfig = ((ImsPsb)imsPsbNode.getDataObject()).getSubsystem().getCanonicalConfig();
            return imsConfig.isStaticAccessSupported(ImsRegionType.BMP) || imsConfig.isStaticAccessSupported(ImsRegionType.DLI);
        }
        if (receiver instanceof ImsDatabaseQueryNode) {
            ImsDatabaseQueryNode imsDbBrowseNode = (ImsDatabaseQueryNode)((Object)receiver);
            ImsDatabaseQuery dbQuery = (ImsDatabaseQuery)imsDbBrowseNode.getDataObject();
            ImsSubsystemConfig imsConfig = dbQuery.getSubsystem().getCanonicalConfig();
            return imsConfig.isDynamicAccessSupported(ImsRegionType.BMP) || imsConfig.isDynamicAccessSupported(ImsRegionType.DLI);
        }
        if (receiver instanceof ImsDatabaseNode) {
            ImsDatabaseNode imsDbNode = (ImsDatabaseNode)((Object)receiver);
            ImsSubsystemConfig imsConfig = ((ImsDatabase)imsDbNode.getDataObject()).getSubsystem().getCanonicalConfig();
            return imsConfig.isDynamicAccessSupported(ImsRegionType.BMP) || imsConfig.isDynamicAccessSupported(ImsRegionType.DLI);
        }
        return false;
    }

    private static boolean isDb2TableType(Object receiver, Object[] args) {
        if (!(receiver instanceof Db2TableNode)) {
            return false;
        }
        Db2TableNode tableNode = (Db2TableNode)((Object)receiver);
        String type = ((Db2Table)tableNode.getDataObject()).getType().name().toLowerCase();
        Object[] objectArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (object.toString().toLowerCase().equals(type)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static boolean fromSameEndpoint(Object receiver) {
        if (!(receiver instanceof IStructuredSelection)) {
            return false;
        }
        IStructuredSelection selection = (IStructuredSelection)receiver;
        Iterator iterator = selection.iterator();
        IPDHost firstEndpoint = null;
        while (iterator.hasNext()) {
            Object current = iterator.next();
            if (!(current instanceof SystemsTreeNode)) continue;
            SystemsTreeNode stn = (SystemsTreeNode)current;
            IPDHost currentEndpoint = null;
            if (stn instanceof Db2SubsystemProvider) {
                currentEndpoint = ((Db2SubsystemProvider)stn).getSubsystem().getSystem();
            } else if (stn.getDataObject() instanceof Db2SubsystemProvider) {
                currentEndpoint = ((Db2SubsystemProvider)stn.getDataObject()).getSubsystem().getSystem();
            } else if (stn instanceof IHostProvider) {
                currentEndpoint = ((IHostProvider)stn).getSystem();
            } else if (stn.getDataObject() instanceof IHostProvider) {
                currentEndpoint = ((IHostProvider)stn.getDataObject()).getSystem();
            } else {
                return false;
            }
            if (firstEndpoint == null) {
                firstEndpoint = currentEndpoint;
                continue;
            }
            if (firstEndpoint.equals(currentEndpoint)) continue;
            return false;
        }
        return true;
    }

    private static boolean favoriteActionItem(Object receiver) {
        if (!(receiver instanceof ActionItemNode)) {
            return false;
        }
        ActionItemNode ain = (ActionItemNode)((Object)receiver);
        IActionItem actionItem = (IActionItem)ain.getDataObject();
        return actionItem.isFavorite();
    }

    private static boolean canModifyActionItem(Object receiver) {
        if (!(receiver instanceof ActionItemNode)) {
            return false;
        }
        ActionItemNode ain = (ActionItemNode)((Object)receiver);
        IActionItem actionItem = (IActionItem)ain.getDataObject();
        return actionItem.isModifiable() && !actionItem.isExecuting();
    }

    private static boolean canExecuteActionItem(Object receiver) {
        if (!(receiver instanceof ActionItemNode)) {
            return false;
        }
        ActionItemNode ain = (ActionItemNode)((Object)receiver);
        IActionItem actionItem = (IActionItem)ain.getDataObject();
        return !actionItem.isExecuting();
    }

    private static boolean isZosSystem(Object receiver) {
        if (receiver instanceof TreeSelection) {
            receiver = ((TreeSelection)receiver).getFirstElement();
        }
        if (!(receiver instanceof SystemsTreeNode)) {
            return false;
        }
        SystemsTreeNode stn = (SystemsTreeNode)receiver;
        if (!(stn.getDataObject() instanceof IHostProvider)) {
            return false;
        }
        IPDHost host = ((IHostProvider)stn.getDataObject()).getSystem();
        return host.getHostType() == HostType.ZOS;
    }

    private static boolean isLocalSystem(Object receiver) {
        if (receiver instanceof TreeSelection) {
            receiver = ((TreeSelection)receiver).getFirstElement();
        }
        if (!(receiver instanceof SystemsTreeNode)) {
            return false;
        }
        SystemsTreeNode stn = (SystemsTreeNode)receiver;
        if (!(stn.getDataObject() instanceof IHostProvider)) {
            return false;
        }
        IPDHost host = ((IHostProvider)stn.getDataObject()).getSystem();
        return host.getHostType() == HostType.LOCAL_HOST;
    }

    private static boolean lockTemplate(Object receiver) {
        if (receiver instanceof StructuredSelection) {
            StructuredSelection structuredSelection = (StructuredSelection)receiver;
            Object selected = structuredSelection.getFirstElement();
            IPDHost host = PDTreeHandlerUtil.getSystemFrom((Object)selected);
            HostVersion.getInstance().setHost(host);
            int hostVersion = HostVersion.getInstance().getVersion();
            if (selected instanceof MemberNode && hostVersion >= 140114) {
                MemberNode memberNode = (MemberNode)((Object)selected);
                Member member = (Member)memberNode.getDataObject();
                Member.TemplateInfo templateInfo = member.getTemplateInfo();
                if (templateInfo == null) {
                    return false;
                }
                return !templateInfo.isLocked();
            }
        }
        return false;
    }

    private static boolean unlockTemplate(Object receiver) {
        if (receiver instanceof StructuredSelection) {
            StructuredSelection structuredSelection = (StructuredSelection)receiver;
            Object selected = structuredSelection.getFirstElement();
            IPDHost host = PDTreeHandlerUtil.getSystemFrom((Object)selected);
            HostVersion.getInstance().setHost(host);
            int hostVersion = HostVersion.getInstance().getVersion();
            if (selected instanceof MemberNode && hostVersion >= 140114) {
                MemberNode memberNode = (MemberNode)((Object)selected);
                Member member = (Member)memberNode.getDataObject();
                Member.TemplateInfo templateInfo = member.getTemplateInfo();
                if (templateInfo == null) {
                    return false;
                }
                return templateInfo.isLocked();
            }
        }
        return false;
    }

    private static boolean leadZeroOn(Object receiver) {
        if (receiver instanceof StructuredSelection) {
            StructuredSelection structuredSelection = (StructuredSelection)receiver;
            Object selected = structuredSelection.getFirstElement();
            IPDHost host = PDTreeHandlerUtil.getSystemFrom((Object)selected);
            HostVersion.getInstance().setHost(host);
            int hostVersion = HostVersion.getInstance().getVersion();
            if (selected instanceof MemberNode && hostVersion >= 140114) {
                MemberNode memberNode = (MemberNode)((Object)selected);
                Member member = (Member)memberNode.getDataObject();
                Member.TemplateInfo templateInfo = member.getTemplateInfo();
                if (templateInfo == null) {
                    return false;
                }
                return !templateInfo.isLocked() && !templateInfo.isLeadingZero();
            }
        }
        return false;
    }

    private static boolean leadZeroOff(Object receiver) {
        if (receiver instanceof StructuredSelection) {
            StructuredSelection structuredSelection = (StructuredSelection)receiver;
            Object selected = structuredSelection.getFirstElement();
            IPDHost host = PDTreeHandlerUtil.getSystemFrom((Object)selected);
            HostVersion.getInstance().setHost(host);
            int hostVersion = HostVersion.getInstance().getVersion();
            if (selected instanceof MemberNode && hostVersion >= 140114) {
                MemberNode memberNode = (MemberNode)((Object)selected);
                Member member = (Member)memberNode.getDataObject();
                Member.TemplateInfo templateInfo = member.getTemplateInfo();
                if (templateInfo == null) {
                    return false;
                }
                return !templateInfo.isLocked() && templateInfo.isLeadingZero();
            }
        }
        return false;
    }
}

