/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.views.systems;

import com.ibm.etools.fm.core.model.DataSetQuery;
import com.ibm.etools.fm.core.model.FMHost;
import com.ibm.etools.fm.core.model.MessageQueueQuery;
import com.ibm.etools.fm.core.model.UssFileQuery;
import com.ibm.etools.fm.core.model.cics.CicsResourceQuery;
import com.ibm.etools.fm.core.model.db2.Db2ObjectQuery;
import com.ibm.etools.fm.core.model.ims.ImsDatabaseQuery;
import com.ibm.etools.fm.core.model.ims.ImsPsbQuery;
import com.ibm.etools.fm.core.model.ims.ImsSubsystem;
import com.ibm.etools.fm.core.model.ims.ImsSubsystemConfig;
import com.ibm.etools.fm.ui.history.IActionItem;
import com.ibm.etools.fm.ui.memento.CicsResourceQuerySaver;
import com.ibm.etools.fm.ui.memento.DataSetQuerySaver;
import com.ibm.etools.fm.ui.memento.Db2ObjectQuerySaver;
import com.ibm.etools.fm.ui.memento.HostSaver;
import com.ibm.etools.fm.ui.memento.IActionItemSaver;
import com.ibm.etools.fm.ui.memento.ImsDatabaseQuerySaver;
import com.ibm.etools.fm.ui.memento.ImsPsbQuerySaver;
import com.ibm.etools.fm.ui.memento.ImsSubsystemConfigSaver;
import com.ibm.etools.fm.ui.memento.MessageQueueQuerySaver;
import com.ibm.etools.fm.ui.memento.UssFileQuerySaver;
import com.ibm.etools.fm.ui.views.systems.FMNaiveTreeUpdater;
import com.ibm.etools.fm.ui.views.systems.FMSystemsTreeUpdater;
import com.ibm.etools.fm.ui.views.systems.model.ActionHistoryContent;
import com.ibm.etools.fm.ui.views.systems.model.CicsTreeContent;
import com.ibm.etools.fm.ui.views.systems.model.DataSetTreeContent;
import com.ibm.etools.fm.ui.views.systems.model.Db2TreeContent;
import com.ibm.etools.fm.ui.views.systems.model.ImsTreeContent;
import com.ibm.etools.fm.ui.views.systems.model.MqTreeContent;
import com.ibm.etools.fm.ui.views.systems.model.UssTreeContent;
import com.ibm.pdtools.common.component.core.comms.ConnectionUtilities;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.model.INaiveTreeUpdater;
import com.ibm.pdtools.common.component.core.model.ITreeContentHolder;
import com.ibm.pdtools.common.component.jhost.comms.HostDetails;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.registery.RegistryLocator;
import com.ibm.pdtools.common.component.jhost.util.PDSafeRunner;
import com.ibm.pdtools.common.component.ui.views.systems.PDTreeContentHolder;
import com.ibm.pdtools.common.component.ui.views.systems.nodes.HostNode;
import com.ibm.pdtools.common.component.ui.views.systems.nodes.SystemsTreeNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.eclipse.ui.IMemento;

public class FMTreeContentHolder
implements ITreeContentHolder {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2021. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static FMTreeContentHolder instance = new FMTreeContentHolder();
    private final UssTreeContent ussContent = new UssTreeContent();
    private final DataSetTreeContent dataSetContent = new DataSetTreeContent();
    private final MqTreeContent mqContent = new MqTreeContent();
    private final CicsTreeContent cicsContent = new CicsTreeContent();
    private final Db2TreeContent db2Content = new Db2TreeContent();
    private final ImsTreeContent imsContent = new ImsTreeContent(this.dataSetContent);
    private final ActionHistoryContent actionHistoryContent = new ActionHistoryContent();
    private boolean savingImsConfig = false;

    public static FMTreeContentHolder getInstance() {
        return instance;
    }

    public UssTreeContent getUssContent() {
        return this.ussContent;
    }

    public DataSetTreeContent getDataSetContent() {
        return this.dataSetContent;
    }

    public MqTreeContent getMqContent() {
        return this.mqContent;
    }

    public CicsTreeContent getCicsContent() {
        return this.cicsContent;
    }

    public Db2TreeContent getDb2Content() {
        return this.db2Content;
    }

    public ImsTreeContent getImsContent() {
        return this.imsContent;
    }

    public ActionHistoryContent getActionHistoryContent() {
        return this.actionHistoryContent;
    }

    public void saveTreeStateToMemento(ITreeContentHolder pdTreeContentHolder, IMemento rootMemento) {
        Objects.requireNonNull(rootMemento, "Must provide a non-null rootMemento IMemento.");
        List allHosts = RegistryLocator.instance().getHostRegistry().all();
        HostSaver hSaver = new HostSaver();
        for (IPDHost system : allHosts) {
            IMemento hostMemento = rootMemento.createChild(hSaver.getTypeName());
            hSaver.saveTo(hostMemento, system);
            List matchingHostNodes = ((PDTreeContentHolder)pdTreeContentHolder).getNodesFor((Object)system);
            HostNode hostNode = null;
            for (SystemsTreeNode matchingHostNode : matchingHostNodes) {
                if (!(matchingHostNode instanceof HostNode)) continue;
                hostNode = (HostNode)matchingHostNode;
                break;
            }
            if (hostNode == null) continue;
            this.saveHostDetailsToMemento(system, hostMemento);
        }
    }

    public void saveQueries() {
        List allHosts = RegistryLocator.instance().getHostRegistry().all();
        for (IPDHost system : allHosts) {
            List matchingHostNodes = PDTreeContentHolder.getInstance().getNodesFor((Object)system);
            HostNode hostNode = null;
            for (SystemsTreeNode matchingHostNode : matchingHostNodes) {
                if (!(matchingHostNode instanceof HostNode)) continue;
                hostNode = (HostNode)matchingHostNode;
                break;
            }
            if (hostNode == null) continue;
            this.saveHostDetailsToDialogSetting(system);
        }
    }

    public void saveHostDetailsToDialogSetting(IPDHost system) {
        this.saveCicsQueries(system);
        this.saveDb2Queries(system);
        this.saveImsQueries(system);
        this.saveMqQueries(system);
    }

    public void saveCicsQueries(IPDHost system) {
        CicsResourceQuerySaver cicsResourceQuerySaver = new CicsResourceQuerySaver(system);
        cicsResourceQuerySaver.removeQuerySection();
        cicsResourceQuerySaver.saveTo(this.cicsContent);
    }

    public void saveDb2Queries(IPDHost system) {
        Db2ObjectQuerySaver db2ObjectQuerySaver = new Db2ObjectQuerySaver(system);
        db2ObjectQuerySaver.removeQuerySection();
        db2ObjectQuerySaver.saveTo(this.db2Content);
    }

    public void saveImsQueries(IPDHost system) {
        ImsSubsystemConfigSaver imsSubsystemConfigSaver = new ImsSubsystemConfigSaver(system);
        imsSubsystemConfigSaver.removeQuerySection();
        imsSubsystemConfigSaver.saveTo(this.imsContent);
    }

    public void saveMqQueries(IPDHost system) {
        MessageQueueQuerySaver messageQueueQuerySaver = new MessageQueueQuerySaver(system);
        messageQueueQuerySaver.removeQuerySection();
        messageQueueQuerySaver.saveTo(this.mqContent);
    }

    public void saveHostDetailsToMemento(IPDHost system, IMemento hostMemento) {
        DataSetQuerySaver dsqSaver = new DataSetQuerySaver(system);
        for (DataSetQuery dataSetQuery : this.dataSetContent.getQueriesForHost(system)) {
            if (!dsqSaver.canSave(dataSetQuery)) continue;
            IMemento dsqMemento = hostMemento.createChild(dsqSaver.getTypeName());
            dsqSaver.saveTo(dsqMemento, dataSetQuery);
        }
        MessageQueueQuerySaver mqqSaver = new MessageQueueQuerySaver(system);
        for (MessageQueueQuery mqQuery : this.mqContent.getQueriesForHost(system)) {
            IMemento iMemento = hostMemento.createChild(mqqSaver.getTypeName());
            mqqSaver.saveTo(iMemento, mqQuery);
        }
        UssFileQuerySaver ufqSaver = new UssFileQuerySaver(system);
        for (UssFileQuery ufQuery : this.ussContent.getQueriesForHost(system)) {
            IMemento iMemento = hostMemento.createChild(ufqSaver.getTypeName());
            ufqSaver.saveTo(iMemento, ufQuery);
        }
        CicsResourceQuerySaver crqSaver = new CicsResourceQuerySaver(system);
        for (CicsResourceQuery<?> cicsResourceQuery : this.cicsContent.getQueriesForHost(system)) {
            IMemento crqMemento = hostMemento.createChild(crqSaver.getTypeName());
            crqSaver.saveTo(crqMemento, cicsResourceQuery);
        }
        Db2ObjectQuerySaver db2ObjectQuerySaver = new Db2ObjectQuerySaver(system);
        for (Db2ObjectQuery db2ObjectQuery : this.db2Content.getQueriesForHost(system)) {
            IMemento db2dbqMemento = hostMemento.createChild(db2ObjectQuerySaver.getTypeName());
            db2ObjectQuerySaver.saveTo(db2dbqMemento, db2ObjectQuery);
        }
        ImsSubsystemConfigSaver imsSubsystemConfigSaver = new ImsSubsystemConfigSaver(system);
        for (ImsSubsystem subsystem : this.imsContent.getSubsystemsWithQueriesOrCustomConfigsForHost(system)) {
            IMemento imsConfigMemento = hostMemento.createChild(imsSubsystemConfigSaver.getTypeName());
            imsSubsystemConfigSaver.saveTo(imsConfigMemento, subsystem.getCanonicalConfig());
            ImsPsbQuerySaver imsPsbQuerySaver = new ImsPsbQuerySaver(subsystem);
            for (ImsPsbQuery imsPsbQuery : this.imsContent.getPsbQueriesForSubsystem(subsystem)) {
                IMemento imsPsbQueryMemento = imsConfigMemento.createChild(imsPsbQuerySaver.getTypeName());
                imsPsbQuerySaver.saveTo(imsPsbQueryMemento, imsPsbQuery);
            }
            ImsDatabaseQuerySaver imsDatabaseQuerySaver = new ImsDatabaseQuerySaver(subsystem);
            for (ImsDatabaseQuery imsDatabaseQuery : this.imsContent.getDatabaseQueriesForSubsystem(subsystem)) {
                IMemento imsDatabaseQueryMemento = imsConfigMemento.createChild(imsDatabaseQuerySaver.getTypeName());
                imsDatabaseQuerySaver.saveTo(imsDatabaseQueryMemento, imsDatabaseQuery);
            }
        }
        IActionItemSaver aiSaver = new IActionItemSaver(system);
        for (IActionItem action : this.actionHistoryContent.getActionsForHost(system)) {
            IMemento aiMemento = hostMemento.createChild(aiSaver.getTypeName());
            aiSaver.saveTo(aiMemento, action);
        }
    }

    public void saveIActionItemToMemento(IPDHost system, IMemento hostMemento, IActionItem action) {
        IActionItemSaver aiSaver = new IActionItemSaver(system);
        IMemento aiMemento = hostMemento.createChild(aiSaver.getTypeName());
        aiSaver.saveTo(aiMemento, action);
    }

    public void loadTreeStateFromMemento(final IMemento mementoRoot) {
        Objects.requireNonNull(mementoRoot, "Must provide a non-null mementoRoot to load tree state from.");
        PDSafeRunner.run((Runnable)new Runnable(){

            @Override
            public void run() {
                IMemento[] hostMementos;
                HostSaver hSaver = new HostSaver();
                IMemento[] iMementoArray = hostMementos = mementoRoot.getChildren(hSaver.getTypeName());
                int n = hostMementos.length;
                int n2 = 0;
                while (n2 < n) {
                    IMemento hostMemento = iMementoArray[n2];
                    IPDHost system = hSaver.loadFrom(hostMemento);
                    if (system != null) {
                        if (!ConnectionUtilities.connectionExists((String)system.getHostID())) {
                            PDLogger.get(this.getClass()).trace((Object)("Ignoring connection because cics explorer profile does not exist. ID: " + system.getHostID()));
                        } else {
                            IPDHost registrySystem = (IPDHost)RegistryLocator.instance().getHostRegistry().findOrAdd((Object)system);
                            if (registrySystem != system) {
                                registrySystem.updateFrom(system);
                            }
                            system = registrySystem;
                            HostDetails latestHostInfo = ConnectionUtilities.getHostDetails((String)system.getHostID());
                            system.setCodePage(latestHostInfo.getHostDefaultEncoding());
                            system.setHostName(latestHostInfo.getHostname());
                            system.setPort(latestHostInfo.getPortNumber());
                            system.setDescription(latestHostInfo.getDescription());
                            system.setHostType(latestHostInfo.getHostType());
                            system.setBidiFormat(latestHostInfo.getBidiFormat());
                            FMTreeContentHolder.this.loadHostQueries(system, hostMemento);
                        }
                    }
                    ++n2;
                }
            }
        });
    }

    public void loadCicsQFromDialogSetting(IPDHost pdHost) {
        CicsResourceQuerySaver cicsqSaver = new CicsResourceQuerySaver(pdHost);
        ArrayList<CicsResourceQuery<?>> queries = cicsqSaver.loadFrom();
        if (queries != null && queries.size() > 0) {
            for (CicsResourceQuery<?> query : queries) {
                this.cicsContent.getResourceQueryRegistry().findOrAdd(query);
            }
        }
    }

    public void loadDb2QFromDialogSetting(IPDHost pdHost) {
        Db2ObjectQuerySaver db2qSaver = new Db2ObjectQuerySaver(pdHost);
        ArrayList<Db2ObjectQuery<?>> queries = db2qSaver.loadFrom();
        if (queries != null && queries.size() > 0) {
            for (Db2ObjectQuery<?> query : queries) {
                this.db2Content.getObjectQueryRegistry().findOrAdd(query);
            }
        }
    }

    public void loadImsQFromDialogSetting(IPDHost pdHost) {
        ImsSubsystemConfigSaver imsConfigSaver = new ImsSubsystemConfigSaver(pdHost);
        ArrayList<ImsSubsystemConfig> imsSubsystemConfigs = imsConfigSaver.loadFrom();
        if (imsSubsystemConfigs.size() > 0) {
            for (ImsSubsystemConfig imsSubsystemConfig : imsSubsystemConfigs) {
                ImsDatabaseQuerySaver imsDatabaseQuerySaver;
                ArrayList imsDatabaseQueries;
                if (imsSubsystemConfig == null) continue;
                ImsPsbQuerySaver imsPsbQuerySaver = new ImsPsbQuerySaver(imsSubsystemConfig.getSubsystem());
                ArrayList imsPsbQueries = imsPsbQuerySaver.loadFrom();
                if (imsPsbQueries != null && imsPsbQueries.size() > 0) {
                    for (ImsPsbQuery query : imsPsbQueries) {
                        if (query == null) continue;
                        this.imsContent.getPsbQueries().findOrAdd((Object)query);
                    }
                }
                if ((imsDatabaseQueries = (imsDatabaseQuerySaver = new ImsDatabaseQuerySaver(imsSubsystemConfig.getSubsystem())).loadFrom()) == null || imsDatabaseQueries.size() <= 0) continue;
                for (ImsDatabaseQuery query : imsDatabaseQueries) {
                    if (query == null) continue;
                    this.imsContent.getDatabaseQueries().findOrAdd((Object)query);
                }
            }
        }
    }

    public void loadMQQFromDialogSetting(IPDHost pdHost) {
        MessageQueueQuerySaver mqqSaver = new MessageQueueQuerySaver(pdHost);
        ArrayList<MessageQueueQuery> queries = mqqSaver.loadFrom();
        if (queries != null && queries.size() > 0) {
            for (MessageQueueQuery query : queries) {
                this.mqContent.getQueryRegistry().findOrAdd((Object)query);
            }
        }
    }

    public IActionItem loadCompareFromSetting(IPDHost pdHost, IMemento hostMemento) {
        IMemento[] aiMementos;
        IActionItemSaver aiSaver = new IActionItemSaver(pdHost);
        IMemento[] iMementoArray = aiMementos = hostMemento.getChildren(aiSaver.getTypeName());
        if (aiMementos.length != 0) {
            IMemento aiMemento = iMementoArray[0];
            return aiSaver.loadFrom(aiMemento);
        }
        return null;
    }

    public void loadHostQueries(IPDHost system, IMemento hostMemento) {
        IMemento[] aiMementos;
        IMemento[] imsSubsystemMementos;
        IMemento[] mqqMementos;
        IMemento[] crqMementos;
        IMemento[] db2oqMementos;
        IMemento[] ufqMementos;
        IMemento[] dsqMementos;
        DataSetQuerySaver dsqSaver = new DataSetQuerySaver(system);
        IMemento[] iMementoArray = dsqMementos = hostMemento.getChildren(dsqSaver.getTypeName());
        int n = dsqMementos.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento dsqMemento = iMementoArray[n2];
            DataSetQuery query = dsqSaver.loadFrom(dsqMemento);
            if (query != null) {
                this.dataSetContent.getQueryRegistry().findOrAdd((Object)query);
            }
            ++n2;
        }
        UssFileQuerySaver ufqSaver = new UssFileQuerySaver(system);
        IMemento[] iMementoArray2 = ufqMementos = hostMemento.getChildren(ufqSaver.getTypeName());
        int query = ufqMementos.length;
        int n3 = 0;
        while (n3 < query) {
            IMemento ufqMemento = iMementoArray2[n3];
            UssFileQuery query2 = ufqSaver.loadFrom(ufqMemento);
            if (query2 != null) {
                this.ussContent.getQueryRegistry().findOrAdd((Object)query2);
            }
            ++n3;
        }
        Db2ObjectQuerySaver db2oqSaver = new Db2ObjectQuerySaver(system);
        IMemento[] iMementoArray3 = db2oqMementos = hostMemento.getChildren(db2oqSaver.getTypeName());
        int query2 = db2oqMementos.length;
        int n4 = 0;
        while (n4 < query2) {
            IMemento db2oqMemento = iMementoArray3[n4];
            Db2ObjectQuery<?> query3 = db2oqSaver.loadFrom(db2oqMemento);
            if (query3 != null) {
                this.db2Content.getObjectQueryRegistry().findOrAdd(query3);
            }
            ++n4;
        }
        CicsResourceQuerySaver crqSaver = new CicsResourceQuerySaver(system);
        IMemento[] iMementoArray4 = crqMementos = hostMemento.getChildren(crqSaver.getTypeName());
        int query3 = crqMementos.length;
        int n5 = 0;
        while (n5 < query3) {
            IMemento crqMemento = iMementoArray4[n5];
            CicsResourceQuery<?> query4 = crqSaver.loadFrom(crqMemento);
            if (query4 != null) {
                this.cicsContent.getResourceQueryRegistry().findOrAdd(query4);
            }
            ++n5;
        }
        MessageQueueQuerySaver mqqSaver = new MessageQueueQuerySaver(system);
        IMemento[] iMementoArray5 = mqqMementos = hostMemento.getChildren(mqqSaver.getTypeName());
        int query4 = mqqMementos.length;
        int n6 = 0;
        while (n6 < query4) {
            IMemento mqqMemento = iMementoArray5[n6];
            MessageQueueQuery query5 = mqqSaver.loadFrom(mqqMemento);
            if (query5 != null) {
                this.mqContent.getQueryRegistry().findOrAdd((Object)query5);
            }
            ++n6;
        }
        ImsSubsystemConfigSaver imsConfigSaver = new ImsSubsystemConfigSaver(system);
        IMemento[] iMementoArray6 = imsSubsystemMementos = hostMemento.getChildren(imsConfigSaver.getTypeName());
        int query5 = imsSubsystemMementos.length;
        int n7 = 0;
        while (n7 < query5) {
            IMemento imsConfigMemento = iMementoArray6[n7];
            ImsSubsystemConfig config = imsConfigSaver.loadFrom(imsConfigMemento);
            if (config != null) {
                IMemento[] imsDatabaseQueryMementos;
                IMemento[] imsPsbQueryMementos;
                ((FMHost)FMHost.getSystem((IPDHost)config.getSystem())).saveImsCanonicalConfig(config);
                ImsPsbQuerySaver imsPsbQuerySaver = new ImsPsbQuerySaver(config.getSubsystem());
                IMemento[] iMementoArray7 = imsPsbQueryMementos = imsConfigMemento.getChildren(imsPsbQuerySaver.getTypeName());
                int n8 = imsPsbQueryMementos.length;
                int n9 = 0;
                while (n9 < n8) {
                    IMemento imsPsbQueryMemento = iMementoArray7[n9];
                    ImsPsbQuery imsPsbQuery = (ImsPsbQuery)imsPsbQuerySaver.loadFrom(imsPsbQueryMemento);
                    if (imsPsbQuery != null) {
                        this.imsContent.getPsbQueries().findOrAdd((Object)imsPsbQuery);
                    }
                    ++n9;
                }
                ImsDatabaseQuerySaver imsDatabaseQuerySaver = new ImsDatabaseQuerySaver(config.getSubsystem());
                IMemento[] iMementoArray8 = imsDatabaseQueryMementos = imsConfigMemento.getChildren(imsDatabaseQuerySaver.getTypeName());
                int n10 = imsDatabaseQueryMementos.length;
                int n11 = 0;
                while (n11 < n10) {
                    IMemento imsDatabaseQueryMemento = iMementoArray8[n11];
                    ImsDatabaseQuery imsDatabaseQuery = (ImsDatabaseQuery)imsDatabaseQuerySaver.loadFrom(imsDatabaseQueryMemento);
                    if (imsDatabaseQuery != null) {
                        this.imsContent.getDatabaseQueries().findOrAdd((Object)imsDatabaseQuery);
                    }
                    ++n11;
                }
            }
            ++n7;
        }
        IActionItemSaver aiSaver = new IActionItemSaver(system);
        IMemento[] iMementoArray9 = aiMementos = hostMemento.getChildren(aiSaver.getTypeName());
        int n12 = aiMementos.length;
        int n13 = 0;
        while (n13 < n12) {
            IMemento aiMemento = iMementoArray9[n13];
            IActionItem actionItem = aiSaver.loadFrom(aiMemento);
            if (actionItem != null) {
                this.actionHistoryContent.getRegistry().findOrAdd((Object)actionItem);
            }
            ++n13;
        }
    }

    public INaiveTreeUpdater createNaiveTreeUpdater() {
        return new FMNaiveTreeUpdater();
    }

    public boolean refreshAllRelatedTo(Object anObject) {
        return FMSystemsTreeUpdater.refreshAllRelatedTo(anObject);
    }
}

