/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.views.systems;

import com.ibm.etools.fm.core.model.Member;
import com.ibm.etools.fm.jhost.core.version.FMFeature;
import com.ibm.etools.fm.ui.history.ActionHistoryTreeSupport;
import com.ibm.etools.fm.ui.history.IActionItem;
import com.ibm.etools.fm.ui.views.systems.handlers.OpenFormatted;
import com.ibm.etools.fm.ui.views.systems.handlers.OpenTemplate;
import com.ibm.etools.fm.ui.views.systems.nodes.ActionItemNode;
import com.ibm.etools.fm.ui.views.systems.nodes.MemberNode;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.model.IPDNoDoubleClickFallbackPermitted;
import com.ibm.pdtools.common.component.core.util.PDUtils;
import com.ibm.pdtools.common.component.jhost.core.model.IHostProvider;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.ISystemsView;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import com.ibm.pdtools.common.component.jhost.version.PDFeature;
import com.ibm.pdtools.common.component.ui.util.EclipseUtils;
import com.ibm.pdtools.common.component.ui.views.systems.PDSystemsView;
import com.ibm.pdtools.common.component.ui.views.systems.handlers.PDEventNode;
import com.ibm.pdtools.common.component.ui.views.systems.handlers.SkeletonHandler;
import com.ibm.pdtools.common.component.ui.views.systems.nodes.SystemsTreeNode;
import java.lang.reflect.InvocationTargetException;
import java.util.EventObject;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.common.CommandException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerService;

public class FMSystemsView
implements ISystemsView {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2021. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final PDLogger logger = PDLogger.get(FMSystemsView.class);

    public void doubleClick(ISystemsView systemsView, Object eventObject, boolean defaultCommandProcessed) {
        if (defaultCommandProcessed) {
            return;
        }
        if (eventObject instanceof PDEventNode) {
            if (FMSystemsView.isFormattedEnabled((PDEventNode)eventObject) && FMSystemsView.isTemplateEditorEnabled((PDEventNode)eventObject)) {
                this.openTemplateOrFormatted(systemsView, (PDEventNode)eventObject);
            } else if (FMSystemsView.isFormattedEnabled((PDEventNode)eventObject)) {
                FMSystemsView.openFormatted((PDEventNode)eventObject, "Failed to open formatted editor on node: ");
            } else if (FMSystemsView.isTemplateEditorEnabled((PDEventNode)eventObject)) {
                FMSystemsView.openTemplate((PDEventNode)eventObject, "Failed to open template editor on node: ");
            }
            return;
        }
        EventObject event = (EventObject)eventObject;
        PDSystemsView pdSystemsView = (PDSystemsView)systemsView;
        ITreeSelection selection = (ITreeSelection)((DoubleClickEvent)event).getSelection();
        TreePath[] selectedPaths = selection.getPaths();
        if (selectedPaths.length > 0) {
            TreePath firstPath = selectedPaths[0];
            SystemsTreeNode node = (SystemsTreeNode)firstPath.getLastSegment();
            if (!pdSystemsView.getContentProvider().hasChildren((Object)node)) {
                if (node instanceof ActionItemNode) {
                    ActionItemNode actionItemNode = (ActionItemNode)node;
                    ActionHistoryTreeSupport.invokeDoubleClickBehaviour((IActionItem)actionItemNode.getDataObject());
                } else {
                    PDEventNode tmpEventNode = new PDEventNode(node, true);
                    if (node instanceof IPDNoDoubleClickFallbackPermitted) {
                        return;
                    }
                    if (FMSystemsView.isFormattedEnabled(tmpEventNode) && FMSystemsView.isTemplateEditorEnabled(tmpEventNode)) {
                        this.openTemplateOrFormatted((ISystemsView)pdSystemsView, tmpEventNode);
                    } else if (FMSystemsView.isFormattedEnabled(tmpEventNode)) {
                        FMSystemsView.openFormatted(tmpEventNode, "Failed to open formatted editor on node: ");
                    } else if (FMSystemsView.isTemplateEditorEnabled(tmpEventNode)) {
                        FMSystemsView.openTemplate(tmpEventNode, "Failed to open template editor on node: ");
                    }
                }
            }
        }
    }

    private static boolean isFormattedEnabled(PDEventNode node) {
        return node.isFromPDSystemsView() ? EclipseUtils.isCommandEnabled((String)"com.ibm.etools.fm.ui.model.commands.openFormatted") : true;
    }

    private static boolean isTemplateEditorEnabled(PDEventNode node) {
        return node.isFromPDSystemsView() ? EclipseUtils.isCommandEnabled((String)"com.ibm.etools.fm.ui.model.commands.openTemplate") : true;
    }

    private static void openFormatted(PDEventNode node, String error) {
        IHandlerService handlerService = (IHandlerService)EclipseUtils.getService(IHandlerService.class);
        String commandId = "com.ibm.etools.fm.ui.model.commands.openFormatted";
        FMSystemsView.checkAndActivateHandler(handlerService, commandId);
        try {
            handlerService.executeCommand(commandId, (Event)(node.isFromPDSystemsView() ? null : node));
        }
        catch (CommandException e) {
            logger.error((Object)(error + String.valueOf(node)), (Throwable)e);
        }
    }

    private static void openTemplate(PDEventNode node, String error) {
        IHandlerService handlerService = (IHandlerService)EclipseUtils.getService(IHandlerService.class);
        String commandId = "com.ibm.etools.fm.ui.model.commands.openTemplate";
        FMSystemsView.checkAndActivateHandler(handlerService, commandId);
        try {
            handlerService.executeCommand(commandId, (Event)(node.isFromPDSystemsView() ? null : node));
        }
        catch (CommandException e) {
            logger.error((Object)(error + String.valueOf(node)), (Throwable)e);
        }
    }

    private void openTemplateOrFormatted(ISystemsView pdSystemsView, PDEventNode node) {
        AtomicReference<Member.TemplateInfo> templateInfo = new AtomicReference<Member.TemplateInfo>();
        if (!this.tryToLoadTemplateInfo(pdSystemsView, node, templateInfo)) {
            return;
        }
        Member.TemplateInfo templInfo = templateInfo.get();
        if (templInfo != null) {
            if (templInfo.getType() == null) {
                FMSystemsView.openFormatted(node, "After template check, failed to open formatted editor on node: ");
            } else {
                FMSystemsView.openTemplate(node, "Failed to open template editor on node: ");
            }
        } else if (FMSystemsView.isFormattedEnabled(node)) {
            FMSystemsView.openFormatted(node, "After template check, failed to open formatted editor on node: ");
        }
    }

    public boolean tryToLoadTemplateInfo(ISystemsView pdSystemsView, PDEventNode eventNode, final AtomicReference<Member.TemplateInfo> templateInfo) {
        IPDHost host = null;
        SystemsTreeNode node = eventNode.getNode();
        if (node.getDataObject() instanceof IHostProvider) {
            host = ((IHostProvider)node.getDataObject()).getSystem();
        }
        if (host != null && host.supports((PDFeature)FMFeature.MEMBER_TEMPLATE_LIST) && node instanceof MemberNode) {
            final MemberNode memNode = (MemberNode)node;
            try {
                PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        IHowIsGoing howIsGoing = PDUtils.convertIprogressToIHowIsGoing((IProgressMonitor)monitor);
                        Member mem = (Member)memNode.getDataObject();
                        logger.trace((Object)("Checking whether member " + mem.getFormattedName() + " is a template"));
                        Result result = mem.loadTemplateInfo(howIsGoing);
                        if (result.isSuccessfulWithoutWarnings()) {
                            templateInfo.set(mem.getTemplateInfo());
                            PDSystemsView.tryRefresh();
                        }
                    }
                });
            }
            catch (InvocationTargetException e) {
                logger.error((Object)("Error fetching template info for member node " + String.valueOf(node)), e.getCause());
            }
            catch (InterruptedException e) {
                logger.trace((Object)("User cancelled attempt to fetch template info for member node " + String.valueOf(node) + "; aborting open attempt"));
                return false;
            }
        }
        return true;
    }

    private static void checkAndActivateHandler(IHandlerService handlerService, String commandId) {
        Command command = EclipseUtils.getCommand((String)commandId);
        if (!command.isHandled()) {
            SkeletonHandler handler = null;
            if ("com.ibm.etools.fm.ui.model.commands.openFormatted".equals(commandId)) {
                handler = new OpenFormatted();
            } else if ("com.ibm.etools.fm.ui.model.commands.openTemplate".equals(commandId)) {
                handler = new OpenTemplate();
            }
            if (handler != null) {
                handlerService.activateHandler(commandId, (IHandler)handler);
            }
        }
    }
}

