/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.views.systems;

import com.ibm.etools.fm.core.model.DataSet;
import com.ibm.etools.fm.core.model.DataSetQuery;
import com.ibm.etools.fm.core.model.Member;
import com.ibm.etools.fm.core.model.UssFile;
import com.ibm.etools.fm.core.model.UssFileQuery;
import com.ibm.etools.fm.core.model.cics.CicsFile;
import com.ibm.etools.fm.core.model.cics.CicsFileQuery;
import com.ibm.etools.fm.core.model.cics.CicsResource;
import com.ibm.etools.fm.core.model.cics.CicsResourceQuery;
import com.ibm.etools.fm.core.model.cics.CicsTemporaryStorage;
import com.ibm.etools.fm.core.model.cics.CicsTemporaryStorageQuery;
import com.ibm.etools.fm.core.model.cics.CicsTransientData;
import com.ibm.etools.fm.core.model.cics.CicsTransientDataQuery;
import com.ibm.etools.fm.ui.views.systems.nodes.CicsResourceQueryNode;
import com.ibm.etools.fm.ui.views.systems.nodes.DataSetQueryNode;
import com.ibm.etools.fm.ui.views.systems.nodes.UssFileQueryNode;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.ui.views.systems.PDTreeContentHolder;
import com.ibm.pdtools.common.component.ui.views.systems.nodes.SystemsTreeNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class FMSystemsTreeUpdater {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    protected static final PDLogger logger = PDLogger.get(FMSystemsTreeUpdater.class);

    public static boolean refreshAllRelatedTo(Object possibleZrl) {
        if (possibleZrl instanceof DataSet) {
            FMSystemsTreeUpdater.refreshQueriesRelatedTo((DataSet)possibleZrl);
            return true;
        }
        if (possibleZrl instanceof Member) {
            FMSystemsTreeUpdater.refreshDataSetsRelatedTo((Member)possibleZrl);
            return true;
        }
        if (possibleZrl instanceof UssFile) {
            FMSystemsTreeUpdater.refreshFilesRelatedTo((UssFile)possibleZrl);
            return true;
        }
        if (possibleZrl instanceof CicsTemporaryStorage) {
            FMSystemsTreeUpdater.refreshCicsQueriesRelatedTo((CicsResource)((CicsTemporaryStorage)possibleZrl));
            return true;
        }
        return false;
    }

    public static void refreshQueriesRelatedTo(DataSet dataSet) {
        List queryNodes = PDTreeContentHolder.getInstance().getNodesOfType(DataSetQueryNode.class);
        for (DataSetQueryNode node : queryNodes) {
            if (!((DataSetQuery)node.getDataObject()).matches(dataSet)) continue;
            node.refreshSelf();
        }
    }

    public static void refreshDataSetsRelatedTo(Member member) {
        Objects.requireNonNull(member, "Must specify a non-null member.");
        List affectedNodes = PDTreeContentHolder.getInstance().getNodesFor((Object)member.asDataSet());
        for (SystemsTreeNode node : affectedNodes) {
            node.refreshSelf();
        }
    }

    public static void refreshFilesRelatedTo(UssFile ussFile) {
        Objects.requireNonNull(ussFile, "Must specify a non-null ussFile.");
        ArrayList<SystemsTreeNode> ignoreQueryNodes = new ArrayList<SystemsTreeNode>();
        UssFile ussParent = ussFile.getParent();
        List fileNodes = PDTreeContentHolder.getInstance().getNodesFor((Object)ussParent);
        for (SystemsTreeNode node : fileNodes) {
            node.refreshSelf();
            SystemsTreeNode matchingParent = node.getParent();
            while (matchingParent != null && !(matchingParent instanceof UssFileQueryNode)) {
                matchingParent = matchingParent.getParent();
            }
            ignoreQueryNodes.add(matchingParent);
        }
        List queryNodes = PDTreeContentHolder.getInstance().getNodesOfType(UssFileQueryNode.class);
        for (UssFileQueryNode queryNode : queryNodes) {
            UssFileQuery query = (UssFileQuery)queryNode.getDataObject();
            if (!query.getPattern().matcher(ussFile.getFormattedName()).matches() || ignoreQueryNodes.contains((Object)queryNode)) continue;
            queryNode.refreshSelf();
        }
    }

    public static void refreshCicsQueriesRelatedTo(CicsResource possibleZrl) {
        List queryNodes = PDTreeContentHolder.getInstance().getNodesOfType(CicsResourceQueryNode.class);
        for (CicsResourceQueryNode queryNode : queryNodes) {
            boolean correctType;
            CicsResourceQuery query = (CicsResourceQuery)queryNode.getDataObject();
            boolean bl = correctType = query instanceof CicsFileQuery && possibleZrl instanceof CicsFile || query instanceof CicsTransientDataQuery && possibleZrl instanceof CicsTransientData || query instanceof CicsTemporaryStorageQuery && possibleZrl instanceof CicsTemporaryStorage;
            if (!correctType || !query.getPattern().matcher(possibleZrl.getName()).matches()) continue;
            queryNode.refreshSelf();
        }
    }
}

