/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.util;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.DataSetOrMember;
import com.ibm.etools.fm.core.model.MessageQueue;
import com.ibm.etools.fm.core.model.UssFile;
import com.ibm.etools.fm.core.model.cics.CicsFile;
import com.ibm.etools.fm.core.model.cics.CicsTemporaryStorage;
import com.ibm.etools.fm.core.model.cics.CicsTransientData;
import com.ibm.etools.fm.core.model.db2.Db2ObjectQuery;
import com.ibm.etools.fm.core.model.db2.Db2Subsystem;
import com.ibm.etools.fm.core.model.db2.Db2Table;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.util.PDUtils;
import com.ibm.pdtools.common.component.jhost.comms.HostType;
import com.ibm.pdtools.common.component.jhost.core.model.IZRL;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import com.ibm.pdtools.common.component.ui.util.PDDialogs;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.PlatformUI;

public class ZrlLoaderDialogUtils {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";

    public static Result<StringBuffer> refreshDataSetProperties(final DataSetOrMember dsom) throws InterruptedException {
        final Result result = new Result((Object)new StringBuffer());
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask(MessageFormat.format(Messages.ZRLUtilities_DS_PROPS_LOOKUP, dsom.getFormattedName()), 2);
                    IHowIsGoing howIsGoing = PDUtils.convertIprogressToIHowIsGoing((IProgressMonitor)monitor);
                    monitor.worked(1);
                    result.addSubResult(dsom.refreshSelf(howIsGoing));
                    monitor.worked(1);
                    monitor.done();
                }
            });
            return result;
        }
        catch (InvocationTargetException e) {
            result.add(e);
            return result;
        }
        catch (InterruptedException e) {
            PDLogger.get(ZrlLoaderDialogUtils.class).trace((Object)("User cancelled loading of properties, aborting. Dataset=" + String.valueOf(dsom)));
            throw e;
        }
    }

    public static Result<StringBuffer> retrieveInformation(final IZRL resource) throws InterruptedException {
        final Result result = new Result((Object)new StringBuffer());
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask(MessageFormat.format(Messages.ZRLUtilities_RETRIEVE_INFO, resource.getFormattedName()), 1);
                    IHowIsGoing howIsGoing = PDUtils.convertIprogressToIHowIsGoing((IProgressMonitor)monitor);
                    if (resource instanceof DataSetOrMember) {
                        result.addSubResult(((DataSetOrMember)resource).refreshSelf(howIsGoing));
                    } else if (resource instanceof MessageQueue) {
                        result.addSubResult(((MessageQueue)resource).refreshSelf(howIsGoing));
                    } else if (resource instanceof UssFile) {
                        result.addSubResult(((UssFile)resource).refreshSelf(howIsGoing));
                    } else if (resource instanceof CicsFile) {
                        result.addSubResult(((CicsFile)resource).refreshSelf(howIsGoing));
                    } else if (resource instanceof CicsTransientData) {
                        result.addSubResult(((CicsTransientData)resource).refreshSelf(howIsGoing));
                    } else if (resource instanceof CicsTemporaryStorage) {
                        result.addSubResult(((CicsTemporaryStorage)resource).refreshSelf(howIsGoing));
                    } else {
                        result.setRC(8);
                        result.add(MessageFormat.format(Messages.ZRLUtilities_UNKNOWN_TYPE, resource.getFormattedName()));
                    }
                    monitor.worked(1);
                    monitor.done();
                }
            });
            return result;
        }
        catch (InvocationTargetException e) {
            result.add(e);
            return result;
        }
        catch (InterruptedException e) {
            throw e;
        }
    }

    public static boolean tableExists(final Db2Table aTable, final Result<?> result, final boolean displayErrorIfAny) {
        final AtomicBoolean ok = new AtomicBoolean(false);
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask(MessageFormat.format(Messages.ZRLUtilities_RETRIEVE_INFO, aTable.getFormattedName()), 2);
                    IHowIsGoing howIsGoing = PDUtils.convertIprogressToIHowIsGoing((IProgressMonitor)monitor);
                    Db2ObjectQuery newQuery = Db2ObjectQuery.create((Db2Subsystem)aTable.getSubsystem(), Db2Table.class);
                    newQuery.setOwnerPattern(aTable.getOwner());
                    newQuery.setNamePattern(aTable.getName());
                    monitor.worked(1);
                    Result queryResult = newQuery.loadObjects(howIsGoing);
                    if (queryResult.isSuccessfulWithoutWarnings()) {
                        List aList = newQuery.getObjects();
                        if (aList.size() > 0) {
                            ok.set(true);
                        } else {
                            ok.set(false);
                        }
                        result.addSubResult(queryResult);
                    } else {
                        result.addSubResult(queryResult);
                        ok.set(false);
                        if (displayErrorIfAny) {
                            PDDialogs.openErrorThreadSafe((String)MessageFormat.format(Messages.ZrlLoaderDialogUtils_Db2StatusCheckErr, aTable.getOwner(), aTable.getName()), (String)queryResult.getMessagesCombined().toString());
                        }
                    }
                    monitor.worked(1);
                    monitor.done();
                }
            });
            return ok.get();
        }
        catch (InvocationTargetException e) {
            result.add(e);
            if (displayErrorIfAny) {
                PDDialogs.openErrorThreadSafe((String)MessageFormat.format(Messages.ZrlLoaderDialogUtils_Db2StatusCheckException, aTable.getOwner(), aTable.getName()), (String)result.getMessagesCombined().toString(), (Throwable)e);
            }
            return false;
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    public static String getNameForDisplay(IZRL aResource) {
        String aName = aResource.getFormattedName();
        String encoding = aResource.getPersistentProperty("encoding") != null ? aResource.getPersistentProperty("encoding") : aResource.getSystem().getHostType().getDefaultEncoding();
        try {
            byte[] byteValue = aName.getBytes(aResource.getSystem().getHostType().getCommunicationEncoding());
            return new String(byteValue, encoding);
        }
        catch (Exception e) {
            return aName;
        }
    }

    public static String getNameForProcessing(String aName, String encoding, HostType hostType) throws UnsupportedEncodingException {
        if (encoding == null || encoding.trim().isEmpty()) {
            return aName;
        }
        byte[] byteValue = aName.getBytes(encoding);
        return new String(byteValue, hostType.getCommunicationEncoding());
    }
}

