/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.ui.util;

import com.ibm.etools.fm.core.model.Member;
import com.ibm.etools.fm.jhost.core.util.ConversionUtil;
import com.ibm.pdtools.common.component.jhost.comms.HostType;
import java.util.regex.Pattern;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;

public abstract class UIValidator {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2025. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    public static final String MEMBER_SEPARATOR = ",";
    public static final String PATTERN_VALID_WILDCARD_MEMBER_NAME = "[-!@#$%\ufffd&*_=+{}A-Z0-9]{1,8}";
    public static final String PATTERN_VALID_WILDCARD_MEMBER_NAME_BODY = "-!@#$%\ufffd&*_=+{}A-Z0-9";
    public static final VerifyListener FORCE_UPPERCASE = new VerifyListener(){

        public void verifyText(VerifyEvent event) {
            event.text = event.text.toUpperCase();
        }
    };

    public static final boolean isValidWildcardableMember(String text2, String codepage) {
        Pattern validRegexp;
        String pattern = PATTERN_VALID_WILDCARD_MEMBER_NAME;
        if (codepage == null) {
            codepage = "cp037";
        }
        if (!codepage.equals(HostType.ZOS.getCommunicationEncoding())) {
            try {
                byte[] cpBytes_BODY = PATTERN_VALID_WILDCARD_MEMBER_NAME_BODY.getBytes(codepage);
                String qual_BODY = new String(cpBytes_BODY, codepage);
                pattern = new String("[" + qual_BODY + "]{1,8}");
            }
            catch (Exception cpBytes_BODY) {
                // empty catch block
            }
        }
        return (validRegexp = Pattern.compile("\\A" + pattern + "\\Z")).matcher(text2.toUpperCase()).matches();
    }

    public static boolean isValidMemberList(String textList, boolean allowEmptyMemberNames, String codepage) {
        String[] possibleMembers;
        if (textList.isEmpty()) {
            return true;
        }
        String[] stringArray = possibleMembers = textList.toUpperCase().split(MEMBER_SEPARATOR);
        int n = possibleMembers.length;
        int n2 = 0;
        while (n2 < n) {
            String member = stringArray[n2];
            if (!(allowEmptyMemberNames && member.isEmpty() || Member.isValidName((String)member, (String)codepage))) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static boolean isValidIntegerList(String textList, boolean allowEmpty) {
        String[] possibleInts;
        String[] stringArray = possibleInts = textList.toUpperCase().split(MEMBER_SEPARATOR);
        int n = possibleInts.length;
        int n2 = 0;
        while (n2 < n) {
            String possibleInt = stringArray[n2];
            if (!(allowEmpty && possibleInt.isEmpty() || ConversionUtil.isInt((String)possibleInt))) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static boolean isValidStringList(String textList, String[] validValues, boolean allowEmpty) {
        String[] possibleValues;
        String[] stringArray = possibleValues = textList.toUpperCase().split(MEMBER_SEPARATOR);
        int n = possibleValues.length;
        int n2 = 0;
        while (n2 < n) {
            String possibleValue = stringArray[n2];
            if (!allowEmpty || !possibleValue.isEmpty()) {
                boolean valid = false;
                String[] stringArray2 = validValues;
                int n3 = validValues.length;
                int n4 = 0;
                while (n4 < n3) {
                    String validValue = stringArray2[n4];
                    if (possibleValue.equals(validValue)) {
                        valid = true;
                    }
                    ++n4;
                }
                if (!valid) {
                    return false;
                }
            }
            ++n2;
        }
        return true;
    }

    public static boolean isInRange(String strNumber, int min, int max) {
        if (!ConversionUtil.isInt((String)strNumber)) {
            return false;
        }
        int number = ConversionUtil.toInt((String)strNumber);
        return number >= min && number <= max;
    }

    private UIValidator() {
    }
}

